<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("ProductConditionList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name
	Dim iConditionID

	Select Case sAction
		Case "New"
			sTitle = "Add Product Condition"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Product Condition Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_ProductConditions WHERE ProductConditionID = '" & Quote(iID) & "'")
			If Not oQuery.Eof Then
				Name	= HTMLEncode(oQuery("ProductConditionName"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Product Condition"

			CommonValidation()

			If GetValueFromTable(oConn, "ProductConditionID", "utb_ProductConditions", "WHERE ProductConditionName = '" & Quote(Name) & "'") <> "" Then
				AddError("Product Condition with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_ProductConditions(ProductConditionName) " &_
						 "VALUES(" & _
						 "	'" & Quote(Name) & "'" &_
						 ") "
				oConn.Execute(sQuery)
		
				iConditionID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product Condition has been inserted.")
					Redirect("ProductConditionForm.asp?Action=Edit&ID=" & iConditionID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Product Condition Ref # " & iID
		
			CommonValidation()

			If GetValueFromTable(oConn, "ProductConditionID", "utb_ProductConditions", "WHERE ProductConditionName = '" & Quote(Name) & "' AND ProductConditionID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Product Condition with name <strong>" & Name & "</strong> already exist in database.")
			End If
			
			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "UPDATE utb_ProductConditions" &_
						 "	 SET ProductConditionName = '" & Quote(Name) & "'" &_
						 " WHERE ProductConditionID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iConditionID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product Condition has been updated.")
					Redirect("ProductConditionForm.asp?Action=Edit&ID=" & iConditionID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			If GetValueFromTable(oConn, "COUNT(*)", "utb_Products", "WHERE ProductConditionID = '" & Quote(iID) & "'") = 0 Then
				oConn.BeginTrans
				On Error Resume Next
				
				oConn.Execute("DELETE FROM utb_ProductConditions WHERE ProductConditionID = '" & Quote(iID) & "'")
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product Condition has been deleted.")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If
			Redirect(sBackURL)
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Product Conditions</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="ProductConditionForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>" />
				<input type="hidden" name="ID" value="<%= iID %>" />
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
						<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:500px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
	End Sub

	Sub SetBackURL()
		Session("ProductConditionFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>