<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Product Conditions</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
			Dim sWhere : sWhere = ""

			Dim sOrder, sArrow, sOrderBy
			sOrder = "1"
			sArrow = "1"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

			sQuery = "SELECT *" &_
					 "	   , (SELECT COUNT(*) FROM utb_Products WHERE ProductConditionID = pc.ProductConditionID) AS ProductsCount" &_
					 "	FROM utb_ProductConditions pc" &_
					 " " & sWhere &_
					 " " & sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<a class="head-link-right icon-add" href="ProductConditionForm.asp?Action=New&amp;ID=0">Add Product Condition</a>
			<h2>Product Conditions</h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
			<tr class="head-line">
				<td style="width:50px;"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td style="text-align: left"><%= GetURLForOrder("Condition Name", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width:50px;">&nbsp;</td>
			</tr>
			<%
				Dim iCount : iCount = 0
				While Not oQuery.Eof 
					iCount = iCount + 1
			%>
			<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
				<td><%= oQuery("ProductConditionID") %></td>
				<td style="text-align: left"><%= oQuery("ProductConditionName") %></td>
				<td>
					<a href="ProductConditionForm.asp?Action=Edit&amp;ID=<%= oQuery("ProductConditionID") %>"><img src="images/grid-act-edit.png" alt="" title="Edit" width="16" height="16" /></a>
					&nbsp;
					<% If oQuery("ProductsCount") = 0 Then %>
					<a href="ProductConditionForm.asp?Action=Delete&amp;ID=<%= oQuery("ProductConditionID") %>" onclick="return areYouSure();"><img src="images/grid-act-delete.png" alt="" title="Delete" width="16" height="16" /></a>
					<% Else %>
					<img src="images/grid-act-delete-gray.png" alt="x" title="<%= oQuery("ProductsCount") %> products using this condition" width="16" height="16" />
					<% End If %>
				</td>
			</tr>
			<%
					oQuery.MoveNext
				Wend
			%>
		</table>
		<% If iRecordCount = 0 Then %>
			<!--#include file="inc/NoRecords.asp"-->
		<% End If %>
		<%
			oQuery.Close
			Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "ProductConditionID"

		Select Case sIndex
			Case "1" sColumn = "ProductConditionID"
			Case "2" sColumn = "ProductConditionName"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>