<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iProductID, oFSO, sImageName
	Dim Name, Description, Specification, Includes, Image
	Set oQuery = oConn.Execute("SELECT * FROM utb_Products WHERE ProductID = '" & Quote(iID) & "'")
	If Not oQuery.Eof Then
		Name			= oQuery("ProductName")
		Description		= oQuery("ProductDescription")
		Specification	= oQuery("ProductSpecification")
		Includes		= oQuery("ProductIncludes")
		Image			= oQuery("ProductImage")
	End If
	oQuery.Close
	Set oQuery = Nothing

	Dim SKU : SKU = Trim(Request("SKU"))

	Dim iMainImageCount, iExtraImageCount, iProductsCount, iAccessoriesCount, iKitsCount, iGiftsCount, iFeedsCount, iReviewsCount
	iMainImageCount		= GetValueFromTable(oConn, "CASE WHEN ProductImage IS NULL THEN 0 ELSE 1 END", "utb_Products", "WHERE ProductID = '" & Quote(iID) & "'")
	iExtraImageCount	= GetValueFromTable(oConn, "COUNT(*)", "utb_ProductImages", "WHERE ProductID = '" & Quote(iID) & "'")
	iProductsCount		= GetValueFromTable(oConn, "COUNT(*)", "utb_Compatibilities", "WHERE CompatibilityChildID = '" & Quote(iID) & "'")
	iAccessoriesCount	= GetValueFromTable(oConn, "COUNT(*)", "utb_Compatibilities", "WHERE CompatibilityParentID = '" & Quote(iID) & "'")
	iKitsCount			= GetValueFromTable(oConn, "COUNT(*)", "utb_Kits", "WHERE ParentID = '" & Quote(iID) & "'")
	iGiftsCount			= GetValueFromTable(oConn, "COUNT(*)", "utb_Gifts", "WHERE ParentID = '" & Quote(iID) & "'")

	iFeedsCount			= 0
	sQuery = "SELECT COUNT(*) AS FeedsCount" &_
			 "	FROM utb_Feeds AS f" &_
			 "		 LEFT JOIN utb_FeedProducts AS fp ON fp.FeedID = f.FeedID" &_
			 "			   AND fp.ProductID = '" & Quote(iID) & "'" &_
			 " WHERE f.FeedIsAllProducts = 0" &_
			 "	 AND ISNULL(fp.FeedProductID, 0) > 0"
	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		iFeedsCount		= oQuery("FeedsCount")
	End If
	oQuery.Close
	Set oQuery = Nothing

	iReviewsCount		= GetValueFromTable(oConn, "COUNT(*)", "utb_ProductReviews", "WHERE ProductID = " & Quote(iID))

	If Request("Submit") <> "" Then
		If SKU = "" Then
			AddError("Product SKU is required.")
		End If

		If Not IsError() Then
			iProductID = GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductSKU = '" & Quote(SKU) & "'")
			If iProductID = iID Then
				AddError("It is the same product.")
			End If
		End If

		If Not IsError() Then
			oConn.BeginTrans
			On Error Resume Next

			' Product Information
			If Request("CopyInfo") <> "" Then
				sQuery = "UPDATE utb_Products" &_
						 "	 SET ProductDescription = '" & Quote(Description) & "'" &_
						 "	   , ProductSpecification = '" & Quote(Specification) & "'" &_
						 "	   , ProductIncludes = '" & Quote(Includes) & "'" &_
						 " WHERE ProductID = " & iProductID
				oConn.Execute(sQuery)
			End If

			' Main Image
			If Request("CopyMainImage") <> "" Then
				Dim sOldImage : sOldImage = GetValueFromTable(oConn, "ProductImage", "utb_Products", "WHERE ProductID = " & iProductID)
				If sOldImage <> "" Then
					Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & sOldImage)
					Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & sOldImage)
					Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & sOldImage)
				End If

				If iMainImageCount > 0 Then
					sImageName = MakeFileName(Name, GetFileExtension(Image), iProductID)

					Set oFSO = CreateObject("Scripting.FileSystemObject")
					oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & sImageName
					oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & sImageName
					oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & sImageName
					oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & sImageName
					Set oFSO = Nothing

					sQuery = "UPDATE utb_Products SET ProductImage = '" & Quote(sImageName) & "' WHERE ProductID = " & iProductID
				Else
					sQuery = "UPDATE utb_Products SET ProductImage = NULL WHERE ProductID = " & iProductID
				End If

				oConn.Execute(sQuery)
			End If

			' Extra Images
			If Request("CopyExtraImages") <> "" Then
				sQuery = "SELECT ProductImageName" &_
						 "	FROM utb_ProductImages" &_
						 " WHERE ProductID = " & Quote(iProductID)
				Set oQuery = oConn.Execute(sQuery)
				While Not oQuery.Eof
					If oQuery("ProductImageName") <> "" Then
						Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & oQuery("ProductImageName"))
						Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & oQuery("ProductImageName"))
						Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & oQuery("ProductImageName"))
					End If
					oQuery.MoveNext
				Wend
				oConn.Execute("DELETE FROM utb_ProductImages WHERE ProductID = " & iProductID)

				If iExtraImageCount > 0 Then
					Dim sQuery2 : sQuery2 = ""

					sQuery = "SELECT *" &_
							 "	FROM utb_ProductImages" &_
							 " WHERE ProductID = '" & Quote(iID) & "'"
					Set oQuery = oConn.Execute(sQuery)
					While Not oQuery.Eof
						sImageName = MakeFileName(Name & "_" & oQuery("ProductImageID"), GetFileExtension(oQuery("ProductImageName")), iProductID)

						sQuery2 = sQuery2 &_
								 "INSERT INTO utb_ProductImages(" &_
								 "	ProductID" &_
								 ", ProductImageName" &_
								 ", ProductImageSortOrder" &_
								 ", ProductImageCreateDate" &_
								 ") " &_
								 "VALUES(" &_
								 "	'" & Quote(iProductID) & "'" &_
								 ",	'" & Quote(sImageName) & "'" &_
								 ",	'" & Quote(oQuery("ProductImageSortOrder")) & "'" &_
								 ",	'" & Quote(oQuery("ProductImageCreateDate")) & "'" &_
								 ")" &_
								 vbNewLine

						Set oFSO = CreateObject("Scripting.FileSystemObject")
						oFSO.CopyFile Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & oQuery("ProductImageName"), Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & sImageName
						oFSO.CopyFile Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & oQuery("ProductImageName"), Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & sImageName
						oFSO.CopyFile Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & oQuery("ProductImageName"), Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & sImageName
						Set oFSO = Nothing

						oQuery.MoveNext
					Wend

					If sQuery2 <> "" Then
						oConn.Execute(sQuery2)
					End If
				End If
			End If

			' Assigned Products
			If Request("CopyProducts") <> "" Then
				oConn.Execute("DELETE FROM utb_Compatibilities WHERE CompatibilityChildID = " & iProductID)

				If iProductsCount > 0 Then
					sQuery = "INSERT INTO utb_Compatibilities(CompatibilityParentID, CompatibilityChildID) " &_
							 "SELECT CompatibilityParentID" &_
							 "	   , " & iProductID &_
							 "	FROM utb_Compatibilities" &_
							 " WHERE CompatibilityChildID = '" & iID & "'"

					oConn.Execute(sQuery)
				End If
			End If

			' Assigned Accessories
			If Request("CopyAccessories") <> "" Then
				oConn.Execute("DELETE FROM utb_Compatibilities WHERE CompatibilityParentID = " & iProductID)

				If iAccessoriesCount > 0 Then
					sQuery = "INSERT INTO utb_Compatibilities(CompatibilityParentID, CompatibilityChildID) " &_
							 "SELECT " & iProductID &_
							 "	   , CompatibilityChildID" &_
							 "	FROM utb_Compatibilities" &_
							 " WHERE CompatibilityParentID = '" & iID & "'"

					oConn.Execute(sQuery)
				End If
			End If

			' Kits
			If Request("CopyKits") <> "" Then
				oConn.Execute("DELETE FROM utb_Kits WHERE ParentId = " & iProductID)

				If iKitsCount > 0 Then
					sQuery = "INSERT INTO utb_Kits(ParentId, ChildId) " &_
							 "SELECT " & iProductID &_
							 "	   , ChildId" &_
							 "	FROM utb_Kits" &_
							 " WHERE ParentId = '" & iID & "'"

					oConn.Execute(sQuery)
				End If
			End If

			' Gifts
			If Request("CopyGifts") <> "" Then
				oConn.Execute("DELETE FROM utb_Gifts WHERE ParentId = " & iProductID)

				If iGiftsCount > 0 Then
					sQuery = "INSERT INTO utb_Gifts(ParentId, ChildId) " &_
							 "SELECT " & iProductID &_
							 "	   , ChildId" &_
							 "	FROM utb_Gifts" &_
							 " WHERE ParentId = '" & iID & "'"

					oConn.Execute(sQuery)
				End If
			End If

			' Feeds
			If Request("CopyFeeds") <> "" Then
				oConn.Execute("DELETE FROM utb_FeedProducts WHERE ProductID = " & iProductID)

				If iFeedsCount > 0 Then
					sQuery = "INSERT INTO utb_FeedProducts(FeedID, ProductID) " &_
							 "SELECT FeedID" &_
							 "	   , " & iProductID &_
							 "	FROM utb_FeedProducts" &_
							 " WHERE ProductID = '" & iID & "'"

					oConn.Execute(sQuery)
				End If
			End If

			' Reviews
			If Request("CopyReviews") <> "" Then
				oConn.Execute("DELETE FROM utb_ProductReviews WHERE ProductID = " & iProductID)

				If iReviewsCount > 0 Then
					sQuery = "INSERT INTO utb_ProductReviews(" &_
							 "	ProductID" &_
							 ", ProductReviewName" &_
							 ", ProductReviewContent" &_
							 ", ProductReviewRating" &_
							 ", ProductReviewIP" &_
							 ", ProductReviewIsActive" &_
							 ", ProductReviewCreateDate" &_
							 ") " &_
							 "SELECT " & iProductID &_
							 "	   , ProductReviewName" &_
							 "	   , ProductReviewContent" &_
							 "	   , ProductReviewRating" &_
							 "	   , ProductReviewIP" &_
							 "	   , ProductReviewIsActive" &_
							 "	   , ProductReviewCreateDate" &_
							 "	FROM utb_ProductReviews" &_
							 " WHERE ProductID = '" & iID & "'"
					oConn.Execute(sQuery)
				End If
			End If

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Product data have been updated.<br/><a href=""ProductForm.asp?Action=Edit&amp;ID=" & iProductID & """>Review updated product</a>")
				Redirect("ProductCopyExistingForm.asp?ID=" & iID)
			Else
				oConn.RollbackTrans
				AddError(Err.Description)
			End If
		End If
	End If
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Copy <%= Name %></h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2>Copy to Existing</h2>
		</div>
		<div class="box">
			<form action="" method="post">
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Copy to SKU</td>
						<td><input type="text" class="form-field" name="SKU" value="<%= SKU %>" style="width:150px;" maxlength="50"/><span></span></td>
					</tr>
					<tr valign="top">
						<td style="text-align:right; padding-top: 10px"><span class="asterisk">*</span> Copy</td>
						<td>
							<table cellpadding="0" cellspacing="0" border="0" class="copy-items">
								<tr>
									<td><input type="checkbox" name="CopyInfo" id="CopyInfo" value="1"<%= IIF(Request("CopyInfo") <> "", " checked='checked'", "") %>/></td>
									<td><label for="CopyInfo">Product Information (Description, Specification, Includes)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyMainImage" id="CopyMainImage" value="1"<%= IIF(Request("CopyMainImage") <> "", " checked='checked'", "") %>/></td>
									<td><label for="CopyMainImage">Main Image (<%= iMainImageCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyExtraImages" id="CopyExtraImages" value="1"<%= IIF(Request("CopyExtraImages") <> "", " checked='checked'", "") %>/></td>
									<td><label for="CopyExtraImages">Extra Images (<%= iExtraImageCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyProducts" id="CopyProducts" value="1"<%= IIF(Request("CopyProducts") <> "", " checked='checked'", "") %>/></td>
									<td><label for="CopyProducts">Assigned Products (<%= iProductsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyAccessories" id="CopyAccessories" value="1"<%= IIF(Request("CopyAccessories") <> "", " checked='checked'", "") %>/></td>
									<td><label for="CopyAccessories">Assigned Accessories / Kits (<%= iAccessoriesCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyKits" id="CopyKits" value="1"<%= IIF(Request("CopyKits") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyKits">Kit Items (<%= iKitsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyGifts" id="CopyGifts" value="1"<%= IIF(Request("CopyGifts") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyGifts">Free Items (<%= iGiftsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyFeeds" id="CopyFeeds" value="1"<%= IIF(Request("CopyFeeds") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyFeeds">Network Feeds (<%= iFeedsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyReviews" id="CopyReviews" value="1"<%= IIF(Request("CopyReviews") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyReviews">Reviews (<%= iReviewsCount %>)</label></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" name="Submit" class="form-btn" value="Copy" disabled="disabled"/></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		var tOut, lastVal;
		$(function(){
			$('input[name="SKU"]').click(function(){
				checkSku($(this));
			}).blur(function(){
				checkSku($(this));
			}).keyup(function(){
				var a = $(this);
				tOut = setTimeout(function(){
					checkSku(a);
				}, 500);
			}).keydown(function(){
				clearTimeout(tOut);
			}).focus();

			<% If Request("Submit") <> "" Then %>
			checkSku($('input[name="SKU"]'));
			<% End If %>

			$('.copy-items input').click(function(){
				if (countChecked() > 0) {
					$('input[type="submit"]').removeAttr('disabled');
				}
				else {
					$('input[type="submit"]').attr('disabled', true);
				}
			});
		});

		function checkSku(a) {
			var aRes = a.parent().find('span');

			if (lastVal == a.val()) {
				return;
			}
			lastVal = a.val();

			if (lastVal == '') {
				aRes.empty();
				$('.copy-items input').removeAttr('disabled');
				if (countChecked() > 0) {
					$('input[type="submit"]').removeAttr('disabled');
				}
				return;
			}

			a.next().after('<div class="iloading"><div style="top: -18px; left: 170px"><img src="images/ajax-loading.gif" alt="..."/></div></div>');
			$.post('ajax/CheckSku.asp', {SKU: lastVal, ID: <%= iID %>}, function(retData){
				$('.iloading').remove();
				if (retData.success) {
					aRes.html('<img src="images/accept.png" align="top" alt="" title="Product found." style="margin: 3px 0 0 6px"/>');
					$('.copy-items input').removeAttr('disabled');
					if (countChecked() > 0) {
						$('input[type="submit"]').removeAttr('disabled');
					}
				}
				else if (typeof(retData.redirect) != 'undefined') {
					redirect(retData.redirect);
				}
				else if (typeof(retData.message) != 'undefined') {
					aRes.html('<img src="images/error.png" align="top" alt="" style="margin: 3px 0 0 6px"/> <span style="color: red">'+retData.message+'</span>');
					$('.copy-items input, input[type="submit"]').attr('disabled', true);
				}
				else {
					alert('Unknown Error. Please contact support.');
				}
			}, 'json');
		}
		
		function countChecked() {
			var cnt = 0;
			$('.copy-items input').each(function(){
				if ($(this).attr('checked')) {
					cnt++;
				}
			});
			
			return cnt;
		}
		</script>
	</body>
</html>
<%
	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("ProductFormBackURL") = "", sDefaultURL, Session("ProductFormBackURL"))
	End Function

	Sub SetBackURL()
		Session("ProductCopyFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>