<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim iProductID, oFSO, sImageName
	Dim Name, SKU, Image
	Set oQuery = oConn.Execute("SELECT * FROM utb_Products WHERE ProductID = '" & Quote(iID) & "'")
	If Not oQuery.Eof Then
		Name	= HTMLEncode(oQuery("ProductName"))
		SKU		= HTMLEncode(oQuery("ProductSKU"))
		Image	= oQuery("ProductImage")
	End If
	oQuery.Close
	Set oQuery = Nothing

	Dim sTitle
	sTitle = "Duplicate " & Name

	Dim iMainImageCount, iExtraImageCount, iProductsCount, iAccessoriesCount, iKitsCount, iGiftsCount, iFeedsCount, iReviewsCount
	iMainImageCount		= GetValueFromTable(oConn, "CASE WHEN ProductImage IS NULL THEN 0 ELSE 1 END", "utb_Products", "WHERE ProductID = '" & Quote(iID) & "'")
	iExtraImageCount	= GetValueFromTable(oConn, "COUNT(*)", "utb_ProductImages", "WHERE ProductID = '" & Quote(iID) & "'")
	iProductsCount		= GetValueFromTable(oConn, "COUNT(*)", "utb_Compatibilities", "WHERE CompatibilityChildID = '" & Quote(iID) & "'")
	iAccessoriesCount	= GetValueFromTable(oConn, "COUNT(*)", "utb_Compatibilities", "WHERE CompatibilityParentID = '" & Quote(iID) & "'")
	iKitsCount			= GetValueFromTable(oConn, "COUNT(*)", "utb_Kits", "WHERE ParentID = '" & Quote(iID) & "'")
	iGiftsCount			= GetValueFromTable(oConn, "COUNT(*)", "utb_Gifts", "WHERE ParentID = '" & Quote(iID) & "'")

	iFeedsCount			= 0
	sQuery = "SELECT COUNT(*) AS FeedsCount" &_
			 "	FROM utb_Feeds AS f" &_
			 "		 LEFT JOIN utb_FeedProducts AS fp ON fp.FeedID = f.FeedID" &_
			 "			   AND fp.ProductID = '" & Quote(iID) & "'" &_
			 " WHERE f.FeedIsAllProducts = 0" &_
			 "	 AND ISNULL(fp.FeedProductID, 0) > 0"
	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		iFeedsCount		= oQuery("FeedsCount")
	End If
	oQuery.Close
	Set oQuery = Nothing

	iReviewsCount		= GetValueFromTable(oConn, "COUNT(*)", "utb_ProductReviews", "WHERE ProductID = '" & Quote(iID) & "'")

	If Request("Submit") <> "" Then
		Name = Trim(Request("Name"))
		SKU = Trim(Request("SKU"))

		If C_CHECK_DUPLICATE_PRODUCT_NAME Then
			If GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductName = '" & Quote(Name) & "' ") <> "" Then
				AddError("Product with name <strong>" & Name & "</strong> already exist in database.")
			End If
		End If

		If GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductSKU = '" & Quote(SKU) & "' ") <> "" Then
			AddError("Product with SKU <strong>" & SKU & "</strong> already exist in database.")
		End If

		If Not IsError() Then
			oConn.BeginTrans
			On Error Resume Next

			' Product Info
			sQuery = "INSERT INTO utb_Products(" &_
					 "  ManufacturerID" &_
					 ", ProductTypeID" &_
					 ", ProductConditionID" &_
					 ", WarrantyID" &_
					 ", ProductStatusID" &_
					 ", PolicyID" &_
					 ", ShippingLevelID" &_
					 ", ProductName" &_
					 ", ProductModel" &_
					 ", ProductDescription" &_
					 ", ProductSpecification" &_
					 ", ProductSKU" &_
					 ", ProductMSRP" &_
					 ", ProductPrice" &_
					 ", ProductCost" &_
					 ", ProductIsBestSeller" &_
					 ", ProductIsNew" &_
					 ", ProductIsKit" &_
					 ", ProductIsOnSale" &_
					 ", ProductIsOther" &_
					 ", ProductQuantity" &_
					 ", ProductMetaTitle" &_
					 ", ProductMetaDescription" &_
					 ", ProductMetaKey" &_
					 ", ProductCreateUser" &_
					 ", ProductColor" &_
					 ", ProductLocation" &_
					 ", ProductKeyFeature" &_
					 ", ProductIncludes" &_
					 ", ProductPunchLine" &_
					 ", ProductOrigin" &_
					 ") " &_
					 "SELECT ManufacturerID" &_
					 "	   , ProductTypeID" &_
					 "	   , ProductConditionID" &_
					 "	   , WarrantyID" &_
					 "	   , 0" &_
					 "	   , PolicyID" &_
					 "	   , ShippingLevelID" &_
					 "	   , '" & Quote(Name) & "'" &_
					 "	   , ProductModel" &_
					 "	   , ProductDescription" &_
					 "	   , ProductSpecification" &_
					 "	   , '" & Quote(SKU) & "'" &_
					 "	   , ProductMSRP" &_
					 "	   , ProductPrice" &_
					 "	   , ProductCost" &_
					 "	   , ProductIsBestSeller" &_
					 "	   , ProductIsNew" &_
					 "	   , ProductIsKit" &_
					 "	   , ProductIsOnSale" &_
					 "	   , ProductIsOther" &_
					 "	   , ProductQuantity" &_
					 "	   , ProductMetaTitle" &_
					 "	   , ProductMetaDescription" &_
					 "	   , ProductMetaKey" &_
					 "	   , '" & Quote(Session("UserNickName")) & "'" &_
					 "	   , ProductColor" &_
					 "	   , ProductLocation" &_
					 "	   , ProductKeyFeature" &_
					 "	   , ProductIncludes" &_
					 "	   , ProductPunchLine" &_
					 "	   , ProductOrigin" &_
					 "	FROM utb_Products" &_
					 "  WHERE ProductID = '" & Quote(iID) & "'"

			oConn.Execute(sQuery)
			iProductID = GetLastID(oConn)

			' Main Image
			If Request("CopyMainImage") <> "" And iMainImageCount > 0 Then
				sImageName = MakeFileName(Name, GetFileExtension(Image), iProductID)

				Set oFSO = CreateObject("Scripting.FileSystemObject")
				oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & sImageName
				oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & sImageName
				oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & sImageName
				oFSO.CopyFile Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & Image, Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & sImageName
				Set oFSO = Nothing

				sQuery = "UPDATE utb_Products SET ProductImage = '" & Quote(sImageName) & "' WHERE ProductID = " & iProductID
				oConn.Execute(sQuery)
			End If

			' Extra Images
			If Request("CopyExtraImages") <> "" And iExtraImageCount > 0 Then
				Dim sQuery2 : sQuery2 = ""

				sQuery = "SELECT *" &_
						 "	FROM utb_ProductImages" &_
						 " WHERE ProductID = '" & Quote(iID) & "'"
				Set oQuery = oConn.Execute(sQuery)
				While Not oQuery.Eof
					sImageName = MakeFileName(Name & "_" & oQuery("ProductImageID"), GetFileExtension(oQuery("ProductImageName")), iProductID)

					sQuery2 = sQuery2 &_
							 "INSERT INTO utb_ProductImages(" &_
							 "	ProductID" &_
							 ", ProductImageName" &_
							 ", ProductImageSortOrder" &_
							 ", ProductImageCreateDate" &_
							 ") " &_
							 "VALUES(" &_
							 "	'" & Quote(iProductID) & "'" &_
							 ",	'" & Quote(sImageName) & "'" &_
							 ",	'" & Quote(oQuery("ProductImageSortOrder")) & "'" &_
							 ",	'" & Quote(oQuery("ProductImageCreateDate")) & "'" &_
							 ")" &_
							 vbNewLine

					Set oFSO = CreateObject("Scripting.FileSystemObject")
					oFSO.CopyFile Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & oQuery("ProductImageName"), Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & sImageName
					oFSO.CopyFile Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & oQuery("ProductImageName"), Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & sImageName
					oFSO.CopyFile Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & oQuery("ProductImageName"), Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & sImageName
					Set oFSO = Nothing

					oQuery.MoveNext
				Wend

				If sQuery2 <> "" Then
					oConn.Execute(sQuery2)
				End If
			End If

			' Assigned Products
			If Request("CopyProducts") <> "" And iProductsCount > 0 Then
				sQuery = "INSERT INTO utb_Compatibilities(CompatibilityParentID, CompatibilityChildID) " &_
						 "SELECT CompatibilityParentID" &_
						 "	   , " & iProductID &_
						 "	FROM utb_Compatibilities" &_
						 " WHERE CompatibilityChildID = '" & iID & "'"

				oConn.Execute(sQuery)
			End If

			' Assigned Accessories
			If Request("CopyAccessories") <> "" And iAccessoriesCount > 0 Then
				sQuery = "INSERT INTO utb_Compatibilities(CompatibilityParentID, CompatibilityChildID) " &_
						 "SELECT " & iProductID &_
						 "	   , CompatibilityChildID" &_
						 "	FROM utb_Compatibilities" &_
						 " WHERE CompatibilityParentID = '" & iID & "'"

				oConn.Execute(sQuery)
			End If

			' Kits
			If Request("CopyKits") <> "" And iKitsCount > 0 Then
				sQuery = "INSERT INTO utb_Kits(ParentId, ChildId) " &_
						 "SELECT " & iProductID &_
						 "	   , ChildId" &_
						 "	FROM utb_Kits" &_
						 " WHERE ParentId = '" & iID & "'"

				oConn.Execute(sQuery)
			End If

			' Gifts
			If Request("CopyGifts") <> "" And iGiftsCount > 0 Then
				sQuery = "INSERT INTO utb_Gifts(ParentId, ChildId) " &_
						 "SELECT " & iProductID &_
						 "	   , ChildId" &_
						 "	FROM utb_Gifts" &_
						 " WHERE ParentId = '" & iID & "'"

				oConn.Execute(sQuery)
			End If

			' Feeds
			If Request("CopyFeeds") <> "" And iFeedsCount > 0 Then
				sQuery = "INSERT INTO utb_FeedProducts(FeedID, ProductID) " &_
						 "SELECT FeedID" &_
						 "	   , " & iProductID &_
						 "	FROM utb_FeedProducts" &_
						 " WHERE ProductID = '" & iID & "'"

				oConn.Execute(sQuery)
			End If

			' Reviews
			If Request("CopyReviews") <> "" And iReviewsCount > 0 Then
				sQuery = "INSERT INTO utb_ProductReviews(" &_
						 "	ProductID" &_
						 ", ProductReviewName" &_
						 ", ProductReviewContent" &_
						 ", ProductReviewRating" &_
						 ", ProductReviewIP" &_
						 ", ProductReviewIsActive" &_
						 ", ProductReviewCreateDate" &_
						 ") " &_
						 "SELECT " & iProductID &_
						 "	   , ProductReviewName" &_
						 "	   , ProductReviewContent" &_
						 "	   , ProductReviewRating" &_
						 "	   , ProductReviewIP" &_
						 "	   , ProductReviewIsActive" &_
						 "	   , ProductReviewCreateDate" &_
						 "	FROM utb_ProductReviews" &_
						 " WHERE ProductID = '" & iID & "'"

				oConn.Execute(sQuery)
			End If

			' Categories
			sQuery = "INSERT INTO utb_ProductCategories(" &_
					 "	ProductID" &_
					 ", CategoryID" &_
					 ", ProductCategoryIsMain" &_
					 ") " &_
					 "SELECT " & iProductID &_
					 "	   , CategoryID" &_
					 "	   , ProductCategoryIsMain" &_
					 "	FROM utb_ProductCategories" &_
					 " WHERE ProductID = '" & iID & "'"

			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Product has been copied.")
				Redirect("ProductForm.asp?Action=Edit&ID=" & iProductID)
			Else
				oConn.RollbackTrans
				AddError(Err.Description)
			End If
		End If
	End If
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1><%= sTitle %></h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2>Duplicate Product</h2>
		</div>
		<div class="box">
			<form action="" method="post">
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> New Name</td>
						<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:820px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> New SKU</td>
						<td><input type="text" class="form-field" name="SKU" value="<%= SKU %>" style="width:150px;" maxlength="50" /></td>
					</tr>
					<tr valign="top">
						<td style="text-align:right; padding-top: 10px">Copy</td>
						<td>
							<table cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td><input type="checkbox" name="CopyInfo" id="CopyInfo" value="1" checked="checked" disabled="disabled" /></td>
									<td><label for="CopyInfo">Product Information</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyMainImage" id="CopyMainImage" value="1"<%= IIF(Request("CopyMainImage") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyMainImage">Main Image (<%= iMainImageCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyExtraImages" id="CopyExtraImages" value="1"<%= IIF(Request("CopyExtraImages") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyExtraImages">Extra Images (<%= iExtraImageCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyProducts" id="CopyProducts" value="1"<%= IIF(Request("CopyProducts") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyProducts">Assigned Products (<%= iProductsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyAccessories" id="CopyAccessories" value="1"<%= IIF(Request("CopyAccessories") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyAccessories">Assigned Accessories / Kits (<%= iAccessoriesCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyKits" id="CopyKits" value="1"<%= IIF(Request("CopyKits") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyKits">Kit Items (<%= iKitsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyGifts" id="CopyGifts" value="1"<%= IIF(Request("CopyGifts") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyGifts">Free Items (<%= iGiftsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyFeeds" id="CopyFeeds" value="1"<%= IIF(Request("CopyFeeds") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyFeeds">Network Feeds (<%= iFeedsCount %>)</label></td>
								</tr>
								<tr>
									<td><input type="checkbox" name="CopyReviews" id="CopyReviews" value="1"<%= IIF(Request("CopyReviews") <> "", " checked='checked'", "") %> /></td>
									<td><label for="CopyReviews">Reviews (<%= iReviewsCount %>)</label></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" name="Submit" class="form-btn" value="Submit" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("ProductFormBackURL") = "", sDefaultURL, Session("ProductFormBackURL"))
	End Function

	Sub SetBackURL()
		Session("ProductCopyFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>