<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Upload.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim iProductID : iProductID = Request("ProductID")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	Dim oUploader
	Set oUploader = New FileUploader
	oUploader.Upload()

	iID = IIF(iID <> "", iID, oUploader.Form("ID"))
	sAction = IIF(sAction <> "", sAction, oUploader.Form("Action"))
	iProductID = IIF(iProductID <> "", iProductID, oUploader.Form("ProductID"))

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If Not ValidateInteger(iProductID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle 
	Dim SortOrder
	Dim iProductImageID, sFileName, oFile

	Dim sProductName : sProductName = GetValueFromTable(oConn, "ProductName", "utb_Products", "WHERE ProductID = '" & Quote(iProductID) & "'")
	Dim sImageName : sImageName = GetValueFromTable(oConn, "ProductImageName", "utb_ProductImages", "WHERE ProductImageID = '" & Quote(iID) & "'")

	Select Case sAction
		Case "New"
			sTitle = "Add Extra Image"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Extra Image Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_ProductImages WHERE ProductImageID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				SortOrder = oQuery("ProductImageSortOrder")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Extra Image"
		
			CommonValidation()

			If oUploader.Files.Count = 0 Then
				AddError("Field <strong>File</strong> is required.")
			End If
		
			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next
		
				sQuery = " INSERT INTO utb_ProductImages (ProductID, ProductImageSortOrder) " & _
						 " VALUES ( " & _
						 "   '" & Quote(iProductID) & "' " & _
						 " , '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 " ) "
				oConn.Execute(sQuery)

				iProductImageID = GetLastID(oConn)
		
				Set oFile = oUploader.Files.Item("File") 
				sFileName = MakeFileName(sProductName, GetFileExtension(oFile.FileName), iProductImageID)

				sQuery = " UPDATE utb_ProductImages " & _
						 "	SET ProductImageName = '" & Quote(sFileName) & "' " & _
						 "  WHERE ProductImageID = '" & Quote(iProductImageID) & "' "
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					Call SaveImage(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & sFileName, oFile.FileData, C_PRODUCT_EXTRA_IMAGE_SMALL_WIDTH, C_PRODUCT_EXTRA_IMAGE_SMALL_HEIGHT)
					Call SaveImage(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & sFileName, oFile.FileData, C_PRODUCT_EXTRA_IMAGE_MEDIUM_WIDTH, C_PRODUCT_EXTRA_IMAGE_MEDIUM_HEIGHT)
					Call SaveImage(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & sFileName, oFile.FileData, C_PRODUCT_EXTRA_IMAGE_LARGE_WIDTH, C_PRODUCT_EXTRA_IMAGE_LARGE_HEIGHT)
					
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product extra image has been inserted.")
					Redirect("ProductExtraImageForm.asp?Action=Edit&ID=" & iProductImageID & "&ProductID=" & iProductID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Update"
			sTitle = "Edit Extra Image Ref # " & iID

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				iProductImageID = iID
				Dim bFileExist : bFileExist = (oUploader.Files.Count > 0)
				
				If bFileExist Then
					Set oFile = oUploader.Files.Item("File") 
					sFileName = MakeFileName(sProductName, GetFileExtension(oFile.FileName), iProductImageID)
				End If

				sQuery = " UPDATE utb_ProductImages " & _
						 "	SET ProductImageSortOrder = '" & Quote(oUploader.Form("SortOrder")) & "' " & _
						 "	  " & IIF(bFileExist, ", ProductImageName = '" & Quote(sFileName) & "' ", "") & _
						 "  WHERE ProductImageID = '" & Quote(iProductImageID) & "' "
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					If bFileExist Then
						Call SaveImage(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & sFileName, oFile.FileData, C_PRODUCT_EXTRA_IMAGE_SMALL_WIDTH, C_PRODUCT_EXTRA_IMAGE_SMALL_HEIGHT)
						Call SaveImage(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & sFileName, oFile.FileData, C_PRODUCT_EXTRA_IMAGE_MEDIUM_WIDTH, C_PRODUCT_EXTRA_IMAGE_MEDIUM_HEIGHT)
						Call SaveImage(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & sFileName, oFile.FileData, C_PRODUCT_EXTRA_IMAGE_LARGE_WIDTH, C_PRODUCT_EXTRA_IMAGE_LARGE_HEIGHT)
					End If

					If Err.Number = 0 Then
						If bFileExist And sImageName <> sFileName Then
							Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & sImageName)
							Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & sImageName)
							Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & sImageName)
						End If

						oConn.CommitTrans
						Call SetAlertMessage("success", "Product extra image has been updated.")
						Redirect("ProductExtraImageForm.asp?Action=Edit&ID=" & iProductImageID & "&ProductID=" & iProductID)
					Else
						oConn.RollbackTrans
						AddError(Err.Description)
					End If
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_ProductImages " & _
					 "  WHERE ProductImageID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				If sImageName <> "" Then
					Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_SMALL_PATH) & "/" & sImageName)
					Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH) & "/" & sImageName)
					Call DeleteFile(Server.MapPath(C_PRODUCT_EXTRA_IMAGE_LARGE_PATH) & "/" & sImageName)
				End If

				oConn.CommitTrans
				Call SetAlertMessage("success", "Product extra image has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Products</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="ProductExtraImageForm.asp" method="post" enctype="multipart/form-data">
		<input type="hidden" name="Action" id="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<input type="hidden" name="ProductID" value="<%= iProductID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> File</td>
				<td><input type="file" name="File" style="width:400px;" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Sort Order</td>
				<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width:60px;" maxlength="10" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
		<% If sImageName <> "" Then %>
		<br />
		<table cellpadding="5" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td>
					Small:
					<br />
					<img src="<%= C_PRODUCT_EXTRA_IMAGE_SMALL_PATH & "/" & sImageName %>" alt="" class="imgborder">
				</td>
			</tr>
			<tr>
				<td>
					Medium:
					<br />
					<img src="<%= C_PRODUCT_EXTRA_IMAGE_MEDIUM_PATH & "/" & sImageName %>" alt="" class="imgborder">
				</td>
			</tr>
			<tr>
				<td>
					Large:
					<br />
					<img src="<%= C_PRODUCT_EXTRA_IMAGE_LARGE_PATH & "/" & sImageName %>" alt="" class="imgborder">
				</td>
			</tr>
		</table>
		<% End If %>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		SortOrder = Trim(oUploader.Form("SortOrder"))

		If SortOrder <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Sort Order</strong> is invalid.")
			End If
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("ProductExtraImageBackURL") = "", sDefaultURL, Session("ProductExtraImageBackURL"))
	End Function
%>