<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")

	Dim iCategoryID : iCategoryID = Request("CategoryID")
	Dim iCategoryIDs : iCategoryIDs = Request("CategoryIDs")
	Dim iManufacturerID : iManufacturerID = Request("ManufacturerID")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "UpdateCost")) = -1 Then
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor, iProductID
	Dim Name, Link, Model, PunchLine, CategoryID, CategoryIDs, ManufacturerID, TypeID, ConditionID, WarrantyID, StatusID, PolicyID
	Dim ShippingLevelID, Origin, Quantity, SortOrder, SKU, MPN, UPC, Price, MSRP, Cost, RealCost, PriceBeforeSale, SaleFinishDate, IsBestSeller, IsNew
	Dim IsOnSale, IsOther, Color, Location, IsKit, Description, Specification, KeyFeature, Includes, MetaTitle
	Dim MetaDescription, MetaKey, Rating, CreateDate, CreateUser, UpdateDate, UpdateUser

	Dim InfoName1, InfoName2, InfoName3, InfoName4, InfoName5
	Dim InfoValue1, InfoValue2, InfoValue3, InfoValue4, InfoValue5
	Dim arInfoNameValue

	Dim arQuery : arQuery = Array()
	Dim iIndex, arCheckedID, arCategoryQuery, arCategoryCheckedID, sDelim
	Dim sImageName : sImageName = GetValueFromTable(oConn, "ProductImage", "utb_Products", "WHERE ProductID = '" & Quote(iID) & "'")

	Select Case sAction
		Case "New"
			sTitle = "Add Product"
			sAction = "Insert"

			CategoryID = iCategoryID
			ManufacturerID = iManufacturerID
			StatusID = "0"
			SortOrder = "0"
			ShippingLevelID = "1"

		Case "Edit"
			sTitle = "Edit Product #" & iID
			sAction = "Update"

			sQuery = "SELECT *" &_
					 "		, ISNULL(ProductOrigin, 0) AS ProductOrigin" &_
					 "	FROM utb_Products" &_
					 " WHERE ProductID = '" & Quote(iID) & "'"
			Set oQuery = oConn.Execute(sQuery)
			If Not oQuery.Eof Then
				Name			= HTMLEncode(oQuery("ProductName"))
				Link			= HTMLEncode(oQuery("ProductLink"))
				Model			= HTMLEncode(oQuery("ProductModel"))
				PunchLine		= HTMLEncode(oQuery("ProductPunchLine"))
				ManufacturerID	= oQuery("ManufacturerID")
				TypeID			= oQuery("ProductTypeID")
				ConditionID		= oQuery("ProductConditionID")
				WarrantyID		= oQuery("WarrantyID")
				StatusID		= oQuery("ProductStatusID")
				Origin			= oQuery("ProductOrigin")
				PolicyID		= IIF(IsNull(oQuery("PolicyID")), "", oQuery("PolicyID"))
				ShippingLevelID	= oQuery("ShippingLevelID")
				Quantity		= oQuery("ProductQuantity")
				SortOrder		= oQuery("ProductSortOrder")
				Description		= oQuery("ProductDescription")
				Specification	= oQuery("ProductSpecification")
				SKU				= HTMLEncode(oQuery("ProductSKU"))
				MPN				= HTMLEncode(oQuery("ProductMPN"))
				UPC				= HTMLEncode(oQuery("ProductUPC"))
				MSRP			= DecimalFormat(oQuery("ProductMSRP"), 2)
				Price			= DecimalFormat(oQuery("ProductPrice"), 2)
				Cost			= DecimalFormat(oQuery("ProductCost"), 2)
				RealCost		= DecimalFormat(oQuery("ProductRealCost"), 2)
				IsBestSeller	= oQuery("ProductIsBestSeller")
				IsNew			= oQuery("ProductIsNew")
				IsKit			= oQuery("ProductIsKit")
				IsOnSale		= oQuery("ProductIsOnSale")
				IsOther			= oQuery("ProductIsOther")
				MetaTitle		= HTMLEncode(oQuery("ProductMetaTitle"))
				MetaDescription	= HTMLEncode(oQuery("ProductMetaDescription"))
				MetaKey			= HTMLEncode(oQuery("ProductMetaKey"))
				Rating			= oQuery("ProductRating")
				CreateDate		= oQuery("ProductCreateDate")
				CreateUser		= oQuery("ProductCreateUser")
				UpdateDate		= oQuery("ProductUpdateDate")
				UpdateUser		= oQuery("ProductUpdateUser")
				SaleFinishDate	= oQuery("ProductSaleFinishDate")
				PriceBeforeSale	= DecimalFormat(oQuery("ProductPriceBeforeSale"), 2)
				Color			= HTMLEncode(oQuery("ProductColor"))
				Location		= HTMLEncode(oQuery("ProductLocation"))
				KeyFeature		= HTMLEncode(oQuery("ProductKeyFeature"))
				Includes		= HTMLEncode(oQuery("ProductIncludes"))

				If Not IsNull(oQuery("ProductInfoNameValue1")) Then
					arInfoNameValue = Split(oQuery("ProductInfoNameValue1"), "|")
					InfoName1	= arInfoNameValue(0)
					InfoValue1	= arInfoNameValue(1)
				End If
				If Not IsNull(oQuery("ProductInfoNameValue2")) Then
					arInfoNameValue = Split(oQuery("ProductInfoNameValue2"), "|")
					InfoName2	= arInfoNameValue(0)
					InfoValue2	= arInfoNameValue(1)
				End If
				If Not IsNull(oQuery("ProductInfoNameValue3")) Then
					arInfoNameValue = Split(oQuery("ProductInfoNameValue3"), "|")
					InfoName3	= arInfoNameValue(0)
					InfoValue3	= arInfoNameValue(1)
				End If
				If Not IsNull(oQuery("ProductInfoNameValue4")) Then
					arInfoNameValue = Split(oQuery("ProductInfoNameValue4"), "|")
					InfoName4	= arInfoNameValue(0)
					InfoValue4	= arInfoNameValue(1)
				End If
				If Not IsNull(oQuery("ProductInfoNameValue5")) Then
					arInfoNameValue = Split(oQuery("ProductInfoNameValue5"), "|")
					InfoName5	= arInfoNameValue(0)
					InfoValue5	= arInfoNameValue(1)
				End If
			End If
			oQuery.Close
			Set oQuery = Nothing

			sQuery = "SELECT CategoryID" &_
					 "	   , ProductCategoryIsMain" &_
					 "	FROM utb_ProductCategories" &_
					 " WHERE ProductID = '" & Quote(iID) & "'"
			Set oQuery = oConn.Execute(sQuery)
			If Not oQuery.Eof Then
				While Not oQuery.Eof
					If oQuery("ProductCategoryIsMain") = 1 Then
						CategoryID = oQuery("CategoryID")
					Else
						CategoryIDs = CategoryIDs & sDelim & oQuery("CategoryID")
						sDelim = ", "
					End If
					oQuery.MoveNext
				Wend
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Product"

			CommonValidation()

			If SKU <> "" And GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductSKU = '" & Quote(SKU) & "'") <> "" Then
				AddError("Product with SKU <strong>" & SKU & "</strong> already exist in database.")
			End If

			If C_CHECK_DUPLICATE_PRODUCT_NAME Then
				If GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductName = '" & Quote(Name) & "'") <> "" Then
					AddError("Product with name <strong>" & Name & "</strong> already exist in database.")
				End If
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Products(" &_
						 "	ProductName" &_
						 ", ProductLink" &_
						 ", ProductModel" &_
						 ", ManufacturerID" &_
						 ", ProductTypeID" &_
						 ", ProductConditionID" &_
						 ", WarrantyID" &_
						 ", ProductStatusID" &_
						 ", PolicyID" &_
						 ", ShippingLevelID" &_
						 ", ProductSortOrder" &_
						 ", ProductQuantity" &_
						 ", ProductDescription" &_
						 ", ProductSpecification" &_
						 ", ProductSKU" &_
						 ", ProductMPN" &_
						 ", ProductUPC" &_
						 ", ProductMSRP" &_
						 ", ProductPrice" &_
						 ", ProductCost" &_
						 ", ProductRealCost" &_
						 ", ProductIsBestSeller" &_
						 ", ProductIsNew" &_
						 ", ProductIsKit" &_
						 ", ProductIsOnSale" &_
						 ", ProductIsOther" &_
						 ", ProductMetaTitle" &_
						 ", ProductMetaDescription" &_
						 ", ProductMetaKey" &_
						 ", ProductSaleFinishDate" &_
						 ", ProductPriceBeforeSale" &_
						 ", ProductCreateUser" &_
						 ", ProductColor" &_
						 ", ProductLocation" &_
						 ", ProductKeyFeature" &_
						 ", ProductIncludes" &_
						 ", ProductPunchLine" &_

						 ", ProductInfoNameValue1" &_
						 ", ProductInfoNameValue2" &_
						 ", ProductInfoNameValue3" &_
						 ", ProductInfoNameValue4" &_
						 ", ProductInfoNameValue5" &_
						 ", ProductOrigin" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(Name) & "' " &_
						 ", '" & Quote(Text2Url(Name)) & "' " &_
						 ", '" & Quote(Model) & "' " &_
						 ", '" & Quote(ManufacturerID) & "' " &_
						 ", '" & Quote(TypeID) & "' " &_
						 ", '" & Quote(ConditionID) & "' " &_
						 ", '" & Quote(WarrantyID) & "' " &_
						 ", '" & Quote(StatusID) & "' " &_
						 ",  " & IIF(PolicyID <> "", "'" & Quote(PolicyID) & "'", "NULL") & " " &_
						 ", '" & Quote(ShippingLevelID) & "' " &_
						 ", '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " &_
						 ", '" & IIF(Quantity = "", "0", Quote(Quantity)) & "' " &_
						 ",  " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") & " " &_
						 ",  " & IIF(Specification <> "", "'" & Quote(Specification) & "'", "NULL") & " " &_
						 ", '" & Quote(SKU) & "' " &_
						 ", '" & Quote(MPN) & "' " &_
						 ", '" & Quote(UPC) & "' " &_
						 ", '" & IIF(MSRP = "", "0", Quote(DecimalPatch(MSRP))) & "' " &_
						 ", '0'" &_
						 ", '" & IIF(Cost = "", "0", Quote(DecimalPatch(Cost))) & "' " &_
						 ", '" & IIF(RealCost = "", "0", Quote(DecimalPatch(RealCost))) & "' " &_
						 ", '" & IIF(IsBestSeller = "", "0", Quote(IsBestSeller)) & "' " &_
						 ", '" & IIF(IsNew = "", "0", Quote(IsNew)) & "' " &_
						 ", '" & IIF(IsKit = "", "0", Quote(IsKit)) & "' " &_
						 ", '" & IIF(IsOnSale = "", "0", Quote(IsOnSale)) & "' " &_
						 ", '" & IIF(IsOther = "", "0", Quote(IsOther)) & "' " &_
						 ",  " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") & " " &_
						 ",  " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") & " " &_
						 ",  " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") & " " &_
						 ",  " & IIF(SaleFinishDate <> "", "'" & Quote(SaleFinishDate) & "'", "NULL") & " " &_
						 ",  " & IIF(PriceBeforeSale <> "", "'" & Quote(PriceBeforeSale) & "'", "NULL") & " " &_
						 ", '" & Quote(Session("UserNickName")) & "' " &_
						 ",  " & IIF(Color <> "", "'" & Quote(Color) & "'", "NULL") & " " &_
						 ",  " & IIF(Location <> "", "'" & Quote(Location) & "'", "NULL") & " " &_
						 ",  " & IIF(KeyFeature <> "", "'" & Quote(KeyFeature) & "'", "NULL") & " " &_
						 ",  " & IIF(Includes <> "", "'" & Quote(Includes) & "'", "NULL") & " " &_
						 ",  " & IIF(PunchLine <> "", "'" & Quote(PunchLine) & "'", "NULL") & " " &_

						 ",  " & IIF(InfoName1 <> "" Or InfoValue1 <> "", "'" & Quote(InfoName1 & "|" & InfoValue1) & "'", "NULL") &_
						 ",  " & IIF(InfoName2 <> "" Or InfoValue2 <> "", "'" & Quote(InfoName2 & "|" & InfoValue2) & "'", "NULL") &_
						 ",  " & IIF(InfoName3 <> "" Or InfoValue3 <> "", "'" & Quote(InfoName3 & "|" & InfoValue3) & "'", "NULL") &_
						 ",  " & IIF(InfoName4 <> "" Or InfoValue4 <> "", "'" & Quote(InfoName4 & "|" & InfoValue4) & "'", "NULL") &_
						 ",  " & IIF(InfoName5 <> "" Or InfoValue5 <> "", "'" & Quote(InfoName5 & "|" & InfoValue5) & "'", "NULL") &_
						 ",  " & IIF(ValidateInteger(Origin), Origin, "NULL") &_
						 ")"
				oConn.Execute(sQuery)

				iProductID = GetLastID(oConn)

				sQuery = "INSERT INTO utb_ProductCategories(CategoryID, ProductID, ProductCategoryIsMain) " &_
						 "VALUES('" & Quote(CategoryID) & "', '" & Quote(iProductID) & "', 1)"
				oConn.Execute(sQuery)

				arCheckedID = Split(Request("CheckedID"), ", ")
				ReDim arQuery(UBound(arCheckedID))
				For iIndex = 0 To UBound(arCheckedID)
					sQuery = "INSERT INTO utb_FeedProducts(FeedID, ProductID) " &_
							 "VALUES('" & Quote(arCheckedID(iIndex)) & "', '" & Quote(iProductID) & "')"
					arQuery(iIndex) = sQuery
				Next
				If UBound(arQuery) >= 0 Then
					oConn.Execute(Join(arQuery, vbNewLine))
				End If

				'Prices
				Call SavePrices()

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product has been inserted.")
					Redirect("ProductForm.asp?Action=Edit&ID=" & iProductID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Product #" & iID

			CommonValidation()

			If GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductSKU = '" & Quote(SKU) & "' AND ProductID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Product with SKU <strong>" & SKU & "</strong> already exist in database.")
			End If

			If C_CHECK_DUPLICATE_PRODUCT_NAME Then
				If GetValueFromTable(oConn, "ProductID", "utb_Products", "WHERE ProductName = '" & Quote(Name) & "' AND ProductID <> '" & Quote(iID) & "'") <> "" Then
					AddError("Product with name <strong>" & Name & "</strong> already exist in database.")
				End If
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				If IsKit = "" Then
					oConn.Execute("DELETE FROM utb_Kits WHERE ParentId = '" & Quote(iID) & "'")
				End If

				sQuery = "UPDATE utb_products" &_
						 "	 SET ProductName = '" & Quote(Name) & "'" &_
						 "	   , ProductLink = '" & Quote(Text2Url(Name)) & "'" &_
						 "	   , ProductModel = '" & Quote(Model) & "'" &_
						 "	   , ManufacturerID = '" & Quote(ManufacturerID) & "'" &_
						 "	   , ProductTypeID = '" & Quote(TypeID) & "'" &_
						 "	   , ProductConditionID = '" & Quote(ConditionID) & "'" &_
						 "	   , WarrantyID = " & IIF(WarrantyID <> "", "'" & Quote(WarrantyID) & "'", "NULL") &_
						 "	   , ProductStatusID = '" & Quote(StatusID) & "'" &_
						 "	   , PolicyID = " & IIF(PolicyID <> "", "'" & Quote(PolicyID) & "'", "NULL") &_
						 "	   , ShippingLevelID = '" & Quote(ShippingLevelID) & "'" &_
						 "	   , ProductSortOrder = '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "'" &_
						 "	   , ProductQuantity = '" & IIF(Quantity = "", "0", Quote(Quantity)) & "'" &_
						 "	   , ProductDescription = " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") &_
						 "	   , ProductSpecification = " & IIF(Specification <> "", "'" & Quote(Specification) & "'", "NULL") &_
						 "	   , ProductSKU = '" & Quote(SKU) & "'" &_
						 "	   , ProductMPN = '" & Quote(MPN) & "'" &_
						 "	   , ProductUPC = '" & Quote(UPC) & "'" &_
						 "	   , ProductMSRP = '" & IIF(MSRP = "", "0", Quote(DecimalPatch(MSRP))) & "'" &_
						 "	   , ProductCost = '" & IIF(Cost = "", "0", Quote(DecimalPatch(Cost))) & "'" &_
						 "	   , ProductRealCost = '" & IIF(RealCost = "", "0", Quote(DecimalPatch(RealCost))) & "'" &_
						 "	   , ProductIsBestSeller = '" & IIF(IsBestSeller = "", "0", Quote(IsBestSeller)) & "'" &_
						 "	   , ProductIsNew = '" & IIF(IsNew = "", "0", Quote(IsNew)) & "'" &_
						 "	   , ProductIsKit = '" & IIF(IsKit = "", "0", "1") & "'" &_
						 "	   , ProductIsOnSale = '" & IIF(IsOnSale = "", "0", Quote(IsOnSale)) & "'" &_
						 "	   , ProductIsOther = '" & IIF(IsOther = "", "0", Quote(IsOther)) & "'" &_
						 "	   , ProductMetaTitle = " & IIF(MetaTitle <> "", "'" & Quote(MetaTitle) & "'", "NULL") &_
						 "	   , ProductMetaDescription = " & IIF(MetaDescription <> "", "'" & Quote(MetaDescription) & "'", "NULL") &_
						 "	   , ProductMetaKey = " & IIF(MetaKey <> "", "'" & Quote(MetaKey) & "'", "NULL") &_
						 "	   , ProductSaleFinishDate = " & IIF(SaleFinishDate <> "", "'" & Quote(SaleFinishDate) & "'", "NULL") &_
						 "	   , ProductPriceBeforeSale = " & IIF(PriceBeforeSale <> "", "'" & Quote(DecimalPatch(PriceBeforeSale)) & "'", "NULL") &_
						 "	   , ProductUpdateDate = GETDATE()" &_
						 "	   , ProductUpdateUser = '" & Quote(Session("UserNickName")) & "'" &_
						 "	   , ProductColor = " & IIF(Color <> "", "'" & Quote(Color) & "'", "NULL") &_
						 "	   , ProductLocation = " & IIF(Location <> "", "'" & Quote(Location) & "'", "NULL") &_
						 "	   , ProductKeyFeature = " & IIF(KeyFeature <> "", "'" & Quote(KeyFeature) & "'", "NULL") &_
						 "	   , ProductIncludes = " & IIF(Includes <> "", "'" & Quote(Includes) & "'", "NULL") &_
						 "	   , ProductPunchLine = " & IIF(PunchLine <> "", "'" & Quote(PunchLine) & "'", "NULL") &_

						 "	   , ProductInfoNameValue1 = " & IIF(InfoName1 <> "" Or InfoValue1 <> "", "'" & Quote(InfoName1 & "|" & InfoValue1) & "'", "NULL") &_
						 "	   , ProductInfoNameValue2 = " & IIF(InfoName2 <> "" Or InfoValue2 <> "", "'" & Quote(InfoName2 & "|" & InfoValue2) & "'", "NULL") &_
						 "	   , ProductInfoNameValue3 = " & IIF(InfoName3 <> "" Or InfoValue3 <> "", "'" & Quote(InfoName3 & "|" & InfoValue3) & "'", "NULL") &_
						 "	   , ProductInfoNameValue4 = " & IIF(InfoName4 <> "" Or InfoValue4 <> "", "'" & Quote(InfoName4 & "|" & InfoValue4) & "'", "NULL") &_
						 "	   , ProductInfoNameValue5 = " & IIF(InfoName5 <> "" Or InfoValue5 <> "", "'" & Quote(InfoName5 & "|" & InfoValue5) & "'", "NULL") &_
						 "	   , ProductOrigin = " & IIF(ValidateInteger(Origin), Origin, "NULL") &_
						 " WHERE ProductID = '" & Quote(iID) & "'"
				oConn.Execute(sQuery)

				iProductID = iID

				oConn.Execute("DELETE FROM utb_ProductCategories WHERE ProductID = '" & Quote(iProductID) & "'")
				arCategoryCheckedID = Split(Request("CategoryIDs"), ", ")
				ReDim arCategoryQuery(UBound(arCategoryCheckedID) + 1)
				For iIndex = 0 To UBound(arCategoryCheckedID)
					sQuery = "INSERT INTO utb_ProductCategories(CategoryID, ProductID, ProductCategoryIsMain) " &_
							 "VALUES('" & Quote(arCategoryCheckedID(iIndex)) & "', '" & Quote(iProductID) & "', 0)"
					arCategoryQuery(iIndex) = sQuery
				Next
				sQuery = "INSERT INTO utb_ProductCategories(CategoryID, ProductID, ProductCategoryIsMain) " &_
						 "VALUES('" & Quote(CategoryID) & "', '" & Quote(iProductID) & "', 1)"
				arCategoryQuery(iIndex) = sQuery
				If UBound(arCategoryQuery) >= 0 Then
					oConn.Execute(Join(arCategoryQuery, vbNewLine))
				End If

				oConn.Execute("DELETE FROM utb_FeedProducts WHERE ProductID = '" & Quote(iProductID) & "'")
				arCheckedID = Split(Request("CheckedID"), ", ")
				ReDim arQuery(UBound(arCheckedID))
				For iIndex = 0 To UBound(arCheckedID)
					sQuery = "INSERT INTO utb_FeedProducts(FeedID, ProductID) " &_
							 "VALUES('" & Quote(arCheckedID(iIndex)) & "', '" & Quote(iProductID) & "')"
					arQuery(iIndex) = sQuery
				Next
				If UBound(arQuery) >= 0 Then
					oConn.Execute(Join(arQuery, vbNewLine))
				End If

				'Prices
				Call SavePrices()

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product has been updated.")
					Redirect("ProductForm.asp?Action=Edit&ID=" & iProductID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
	End Select

	Dim isWarranty : isWarranty = False
	If GetValueFromTable(oConn, "COUNT(*)", "utb_ProductWarranties", "WHERE ProductID = '" & Quote(iID) & "'") > 0 Then
		isWarranty = true
	End If

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(document).ready(function(){
			$('#SaleFinishDate').datepicker({ dateFormat: 'm/d/yy'});
		});
		//]]>
		</script>
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1><%= sTitle %></h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<% If iID > 0 Then %>
				<a class="head-link-right" href="AssignAccessoryList.asp?ProductID=<%= iID %>">Assign Accessories (<%= GetValueFromTable(oConn, "COUNT(*)", "utb_Compatibilities", "WHERE CompatibilityParentID = '" & Quote(iID) & "'") %>)</a>
				<a class="head-link-right" href="AssignProductList.asp?ProductID=<%= iID %>">Assign Products (<%= GetValueFromTable(oConn, "COUNT(*)", "utb_Compatibilities", "WHERE CompatibilityChildID = '" & Quote(iID) & "'") %>)</a>
				<!--<a class="head-link-right" href="ProductExtraImageList.asp?ProductID=<%= iID %>">Extra Images (<%= GetValueFromTable(oConn, "COUNT(*)", "utb_ProductImages", "WHERE ProductID = '" & Quote(iID) & "'") %>)</a>-->
				<a class="head-link-right" href="ProductMainImageForm.asp?ID=<%= iID %>">Main Image</a>
				<a class="head-link-right" href="ProductCopyForm.asp?ID=<%= iID %>">Duplicate Product</a>
				<a class="head-link-right" href="ProductCopyExistingForm.asp?ID=<%= iID %>">Copy to Existing</a>
			<% End If %>
			<h2>&nbsp;</h2>
		</div>
		<div class="box">
			<!--#include file="../ckeditor/ckeditor.asp"-->
			<form id="MainForm" action="ProductForm.asp" method="post">
				<div>
					<input type="hidden" name="Action" id="Action" value="<%= sAction %>"/>
					<input type="hidden" name="ID" value="<%= iID %>"/>
				</div>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right; width: 110px"><label for="Name"><span class="asterisk">*</span> Name</label></td>
						<td colspan="2"><input type="text" class="form-field" name="Name" id="Name" value="<%= Name %>" style="width: 800px" maxlength="255"/></td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right"><label for="Model"><span class="asterisk">*</span> Model</label></td>
						<td colspan="2"><input type="text" class="form-field" name="Model" id="Model" value="n/a" style="width: 361px" maxlength="50"/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="PunchLine">Punch Line</label></td>
						<td colspan="2"><input type="text" class="form-field" name="PunchLine" id="PunchLine" value="<%= PunchLine %>" style="width: 800px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="CategoryID"><span class="asterisk">*</span> Main Category</label></td>
						<td>
							<select class="selector" name="CategoryID" id="CategoryID" style="width: 375px">
								<option value="">Select One</option>
								<%
								Set oQuery = oConn.Execute(" exec usp_CategoriesGet")
								While Not oQuery.Eof 
									%><option value="<%= oQuery("CategoryID") %>"<%= IIF(CStr(oQuery("CategoryID")) = CStr(CategoryID), " selected='selected'", "") %>><%= TreeLevelOffset(oQuery("Indent"), 6, "&nbsp;") %><%= oQuery("CategoryName") %> (<%= oQuery("CategoryID") %>)</option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						</td>
						<td valign="top" rowspan="8" style="text-align: center; width: 162px; padding: 0 11px 0 0">
						<% If iID > 0 Then %>
							<a href="ProductMainImageForm.asp?ID=<%= iID %>"><img src="<%= IIF(sImageName <> "", C_PRODUCT_IMAGE_SMALL_PATH & "/" & sImageName, C_NO_IMAGE_SMALL) %>" alt="" class="imgborder"/></a>
						<% End If %>
						</td>
					</tr>
					<% If iID > 0 Then %>
					<tr valign="top">
						<td style="text-align: right">Extra Categories</td>
						<td>
							<div id="ProductCategoriesIE7" style="position: relative; display: none">
								<div id="ProductCategories" style="position: absolute; top: -4px; left: 0; background: #fff; width: 375px">
									<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid align-left">
										<tr class="head-line">
											<td style="padding: 0 5px">
												<img src="images/close.png" id="CategoriesClose" width="16" height="16" style="float: right; cursor: pointer" title="Close (Cancel)"/>
												Select Categories
											</td>
										</tr>
										<tr>
											<td style="padding: 0">
												<ul>
												<%
												Dim arCategoryIds : arCategoryIds = Split(CategoryIDs, ", ")
												Dim isSelected : isSelected = False
												Dim isDisabled : isDisabled = False
												Set oQuery = oConn.Execute("EXEC usp_CategoriesGet")
												While Not oQuery.Eof
													isSelected = ItemExists(arCategoryIds, oQuery("CategoryID"))
													isDisabled = CLng(CategoryID) = CLng(oQuery("CategoryID"))
													%>
													<li style="padding-left: <%= oQuery("Indent") * 16 %>px" class="<%= IIF(isSelected, "checked", "") %><%= IIF(isDisabled, "disabled", "") %>">
														<input type="checkbox" name="CategoryIDs" id="CategoryID<%= oQuery("CategoryID") %>" value="<%= oQuery("CategoryID") %>"<%= IIF(isSelected, " checked='checked'", "") %><%= IIF(isDisabled, " disabled='disabled'", "") %>/>
														<label for="CategoryID<%= oQuery("CategoryID") %>" id="CategoryLabel<%= oQuery("CategoryID") %>"><%= oQuery("CategoryName") %></label>
													</li>
													<%
													oQuery.MoveNext
												Wend
												oQuery.Close
												Set oQuery = Nothing
												%>
												</ul>
											</td>
										</tr>
										<tr class="head-line">
											<td style="text-align: center; padding: 3px">
												<input type="button" name="Apply" value="Apply"/>
												&nbsp;
												<input type="button" name="Cancel" value="Cancel"/>
											</td>
										</tr>
									</table>
								</div>
							</div>
							<div id="ProductCategoriesCurrent">
								<% If CategoryIDs <> "" Then %>
									<%
									sDelim = ""
									Set oQuery = oConn.Execute("SELECT CategoryID, CategoryName FROM utb_Categories WHERE CategoryID IN(" & CategoryIDs & ")")
									While Not oQuery.Eof
										Response.Write sDelim
										%><a id="CategoryLink<%= oQuery("CategoryID") %>" href="#"><%= oQuery("CategoryName") %></a><%
										sDelim = ", "
										oQuery.MoveNext
									Wend
									oQuery.Close
									Set oQuery = Nothing
									%>
								<% Else %>
								<a href="#" id="CategoryLink0">Click here to select categories</a>
								<% End If %>
							</div>
						</td>
					</tr>
					<% End If %>
					<tr>
						<td style="text-align: right"><label for="ManufacturerID"><span class="asterisk">*</span> Manufacturer</label></td>
						<td>
							<select class="selector" name="ManufacturerID" id="ManufacturerID" style="width: 375px">
								<option value="">Select One</option>
								<%
								Set oQuery = oConn.Execute(" SELECT * FROM utb_Manufacturers ORDER BY ManufacturerName ")
								While Not oQuery.Eof 
									%><option value="<%= oQuery("ManufacturerID") %>"<%= IIF(CStr(oQuery("ManufacturerID")) = CStr(ManufacturerID), " selected='selected'", "") %>><%= oQuery("ManufacturerName") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="TypeID"><span class="asterisk">*</span> Type</label></td>
						<td>
							<select class="selector" name="TypeID" id="TypeID" style="width: 300px">
								<option value="">Select One</option>
								<%
								Set oQuery = oConn.Execute(" SELECT * FROM utb_ProductTypes ORDER BY ProductTypeID ")
								While Not oQuery.Eof 
									%><option value="<%= oQuery("ProductTypeID") %>"<%= IIF(CStr(oQuery("ProductTypeID")) = CStr(TypeID), " selected='selected'", "") %>><%= oQuery("ProductTypeName") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="ConditionID"><span class="asterisk">*</span> Condition</label></td>
						<td>
							<select class="selector" name="ConditionID" id="ConditionID" style="width: 300px">
								<option value="">Select One</option>
								<%
								Set oQuery = oConn.Execute("SELECT * FROM utb_ProductConditions ORDER BY ProductConditionName")
								While Not oQuery.Eof
									%><option value="<%= oQuery("ProductConditionID") %>"<%= IIF(CStr(oQuery("ProductConditionID")) = CStr(IIF(IsNull(ConditionID), "", ConditionID)), " selected='selected'", "") %>><%= oQuery("ProductConditionName") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						</td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right"><label for="WarrantyID">Warranty</label></td>
						<td>
						<% If Not isWarranty Then %>
							<select class="selector" name="WarrantyID" id="WarrantyID" style="width: 300px">
								<option value="">None</option>
								<%
								Set oQuery = oConn.Execute("SELECT * FROM utb_Warranties ORDER BY WarrantyName")
								While Not oQuery.Eof
									%><option value="<%= oQuery("WarrantyID") %>"<%= IIF(CStr(oQuery("WarrantyID")) = CStr(IIF(IsNull(WarrantyID), "", WarrantyID)), " selected='selected'", "") %>><%= oQuery("WarrantyName") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						<% Else %>
							<a href="ProductWarrantyForm.asp?ID=<%= iID %>">This product is a warranty</a>
						<% End If %>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="StatusID"><span class="asterisk">*</span> Status</label></td>
						<td>
							<select class="selector" name="StatusID" id="StatusID" style="width: 300px">
								<%
								Set oQuery = oConn.Execute(" SELECT * FROM utb_ProductStatuses ORDER BY ProductStatusID ")
								While Not oQuery.Eof 
									%><option value="<%= oQuery("ProductStatusID") %>"<%= IIF(CStr(oQuery("ProductStatusID")) = CStr(StatusID), " selected='selected'", "") %>><%= oQuery("ProductStatusName") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						</td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right"><label for="PolicyID">Return Policy</label></td>
						<td colspan="2">
							<select class="selector" name="PolicyID" id="PolicyID" style="width: 300px">
								<option value="">None</option>
								<%
								Set oQuery = oConn.Execute("SELECT * FROM utb_Policies ORDER BY PolicyName")
								While Not oQuery.Eof 
									%><option value="<%= oQuery("PolicyID") %>"<%= IIF(CStr(oQuery("PolicyID")) = CStr(PolicyID), " selected='selected'", "") %>><%= oQuery("PolicyName") & " - " & IIF(oQuery("PolicyIsVisible") = "1", "Display", "Hide") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
							%>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="ShippingLevelID"><span class="asterisk">*</span> Shipping Level</label></td>
						<td>
							<select class="selector" name="ShippingLevelID" id="ShippingLevelID" style="width: 300px">
								<option value="">Select One</option>
								<%
								Set oQuery = oConn.Execute(" SELECT * FROM utb_ShippingLevels ORDER BY ShippingLevelID ")
								While Not oQuery.Eof 
									%><option value="<%= oQuery("ShippingLevelID") %>"<%= IIF(CStr(oQuery("ShippingLevelID")) = CStr(ShippingLevelID), " selected='selected'", "") %>><%= oQuery("ShippingLevelName") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="Origin">Origin</label></td>
						<td>
							<select class="selector" name="Origin" id="Origin" style="width: auto">
								<option value="">NONE</option>
								<option value="1"<%= IIF(ValidateInteger(Origin) And Origin = "1", " selected='selected'", "") %>>EUROPE</option>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="Quantity">Quantity</label></td>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="internal_table">
								<tr>
									<td><input type="text" class="form-field" name="Quantity" id="Quantity" value="<%= Quantity %>" style="width: 100px" maxlength="10"/></td>
									<td style="text-align: right; width: 110px"><label for="SortOrder">Sort Order</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="SortOrder" id="SortOrder" value="<%= SortOrder %>" style="width: 100px" maxlength="10"/></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="SKU"><span class="asterisk">*</span> SKU</label></td>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="internal_table">
								<tr>
									<td><input type="text" class="form-field" name="SKU" id="SKU" value="<%= SKU %>" style="width: 130px" maxlength="50"/></td>
									<td style="text-align: right; width: 80px"><label for="MPN">MPN</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="MPN" id="MPN" value="<%= MPN %>" style="width: 130px" maxlength="50"/></td>
									<td style="text-align: right; width: 80px"><label for="UPC">UPC</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="UPC" id="UPC" value="<%= UPC %>" style="width: 130px" maxlength="50"/></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="Price">Price</label></td>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="internal_table">
								<tr>
									<td><input type="text" class="form-field" name="Price" id="Price" value="<%= Price %>" style="width: 130px" maxlength="15" disabled="disabled"/></td>
									<td style="text-align: right; width: 80px"><label for="MSRP">MSRP</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="MSRP" id="MSRP" value="<%= MSRP %>" style="width: 130px" maxlength="15"/></td>
									<td style="text-align: right; width: 80px"><label for="Cost">Cost</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="Cost" id="Cost" value="<%= Cost %>" style="width: 130px" maxlength="15"/></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right; white-space: nowrap"><label for="PriceBeforeSale">Price Before Sale</label></td>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="internal_table">
								<tr>
									<td><input type="text" class="form-field" name="PriceBeforeSale" id="PriceBeforeSale" value="<%= PriceBeforeSale %>" style="width: 130px" maxlength="15"/></td>
									<td style="text-align: right; width: 110px"><label for="SaleFinishDate">Sale Finish Date&nbsp;</label></td>
									<td><input type="text" class="form-field" name="SaleFinishDate" id="SaleFinishDate" value="<%= SaleFinishDate %>" style="width: 100px" maxlength="10"/></td>
									<% If CheckUserPermission(3) Then %>
										<td style="text-align: right; width: 80px"><label for="RealCost">Real Cost</label>&nbsp;&nbsp;</td>
										<td><input type="text" class="form-field" name="RealCost" id="RealCost" value="<%= RealCost %>" style="width: 130px" maxlength="15"/></td>
									<% Else %>
										<td style="text-align: right; width: 80px">&nbsp;</td>
										<td><input type="hidden" name="RealCost" id="RealCost" value="<%= RealCost %>"/></td>
									<% End If %>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsBestSeller">Best Seller</label></td>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="internal_table">
								<tr>
									<td><input type="text" class="form-field" name="IsBestSeller" id="IsBestSeller" value="<%= IsBestSeller %>" style="width: 85px" maxlength="10"/></td>
									<td style="text-align: right; width: 56px"><label for="IsNew">New</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="IsNew" id="IsNew" value="<%= IsNew %>" style="width: 85px" maxlength="10"/></td>
									<td style="text-align: right; width: 84px"><label for="IsOnSale">On Sale</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="IsOnSale" id="IsOnSale" value="<%= IsOnSale %>" style="width: 85px" maxlength="10"/></td>
									<td style="text-align: right; width: 56px"><label for="IsOther">Other</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="IsOther" id="IsOther" value="<%= IsOther %>" style="width: 85px" maxlength="10"/></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right"><label for="Color">Color</label></td>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="internal_table">
								<tr>
									<td><input type="text" class="form-field" name="Color" id="Color" value="<%= Color %>" style="width: 240px" maxlength="50"/></td>
									<td style="text-align: right; width: 84px"><label for="Location">Location</label>&nbsp;&nbsp;</td>
									<td><input type="text" class="form-field" name="Location" id="Location" value="<%= Location %>" style="width: 240px" maxlength="50"/></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td style="text-align: right; vertical-align: top"><label><span class="asterisk">*</span> Prices</label></td>
						<td colspan="2" style="padding-top: 0">
							<table cellpadding="0" cellspacing="0" border="0" class="prices">
								<tr>
									<td style="padding-bottom: 0"><label>Quantity From</label></td>
									<td style="padding-bottom: 0"><label>Quantity To</label></td>
									<td style="padding-bottom: 0"><label>Price</label></td>
									<td style="padding-bottom: 0">&nbsp;</td>
								</tr>
								<%
								If iID = 0 Then
									Dim iiIndex : iiIndex = 0
									Dim iQtyFrom, iQtyTo, dQtyPrice
									Dim arQtyFrom, arQtyTo, arQtyPrice
									arQtyFrom	= Split(Request("QtyFrom"), ", ")
									arQtyTo		= Split(Request("QtyTo"), ", ")
									arQtyPrice	= Split(Request("QtyPrice"), ", ")

									For iIndex = 0 To UBound(arQtyFrom)
										iQtyFrom	= arQtyFrom(iIndex)
										If Ubound(arQtyTo) >= iIndex Then
											iQtyTo	= IIF(arQtyTo(iIndex) <> "", arQtyTo(iIndex), "")
										Else
											iQtyTo	= ""
										End If
										dQtyPrice	= DecimalPatch(arQtyPrice(iIndex))

										If Trim(arQtyFrom(iIndex)) <> "" And Trim(arQtyPrice(iIndex)) <> "" Then
											%>
											<tr>
												<td><input type="text" class="form-field" name="QtyFrom" value="<%= iQtyFrom %>" style="width: 100px" maxlength="10"/></td>
												<td><input type="text" class="form-field" name="QtyTo" value="<%= iQtyTo %>" style="width: 100px" maxlength="10"/></td>
												<td><input type="text" class="form-field" name="QtyPrice" value="<%= dQtyPrice %>" style="width: 130px" maxlength="15"/></td>
												<td><%
												If iIndex > 0 Then
													%><a href="#" class="del-price"><img src="images/grid-act-delete.png" alt=""/></a><%
												Else
													%>&nbsp;<%
												End If
												%></td>
											</tr>
											<%
											iiIndex = iiIndex + 1
										End If
									Next
									If iiIndex = 0 Then
										%>
										<tr>
											<td><input type="text" class="form-field" name="QtyFrom" value="" style="width: 100px" maxlength="10"/></td>
											<td><input type="text" class="form-field" name="QtyTo" value="" style="width: 100px" maxlength="10"/></td>
											<td><input type="text" class="form-field" name="QtyPrice" value="" style="width: 130px" maxlength="15"/></td>
											<td>&nbsp;</td>
										</tr>
										<%
									End If
								Else
									iIndex = 0
									Set oQuery = oConn.Execute("SELECT * FROM utb_ProductPrices WHERE ProductID = " & iID & " ORDER BY ProductPriceID")
									While Not oQuery.Eof
										%>
										<tr>
											<td><input type="text" class="form-field" name="QtyFrom" value="<%= oQuery("ProductPriceQtyFrom") %>" style="width: 100px" maxlength="10"/></td>
											<td><input type="text" class="form-field" name="QtyTo" value="<%= oQuery("ProductPriceQtyTo") %>" style="width: 100px" maxlength="10"/></td>
											<td><input type="text" class="form-field" name="QtyPrice" value="<%= DecimalFormat(oQuery("ProductPriceAmount"), 2) %>" style="width: 130px" maxlength="15"/></td>
											<td><%
											If iIndex > 0 Then
												%><a href="#" class="del-price"><img src="images/grid-act-delete.png" alt=""/></a><%
											Else
												%>&nbsp;<%
											End If
											%></td>
										</tr>
										<%
										iIndex = iIndex + 1
										oQuery.MoveNext
									Wend
									oQuery.Close
									Set oQuery = Nothing
								End If
								%>
							</table>
							<a href="#" class="act-add add-price" style="padding-left: 20px">Add more</a>
						</td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right"><label for="IsKit">Kit Item</label></td>
						<td colspan="2">
							<input type="checkbox" name="IsKit" id="IsKit" value="1"<%= IIF(IsKit = "1", " checked='checked'", "") %>/>
							<% If IsKit = "1" Then %>
							&nbsp; <a href="AssignKitList.asp?ProductID=<%= iID %>">Assign Kit Items (<%= GetValueFromTable(oConn, "COUNT(*)", "utb_Kits", "WHERE ParentID = '" & Quote(iID) & "'") %>)</a>
							<% End If %>
						</td>
					</tr>
					<%
					Dim i : i = 0
					sQuery = "SELECT f.*" &_
							 "	   , ISNULL(fp.FeedProductID, 0) AS FeedProductID" &_
							 "	FROM utb_Feeds AS f" &_
							 "		 LEFT JOIN utb_FeedProducts AS fp ON fp.FeedID = f.FeedID" &_
							 "										 AND fp.ProductID = '" & Quote(iID) & "'" &_
							 " WHERE f.FeedIsAllProducts = 0" &_
							 " ORDER BY f.FeedID"
					Set oQuery = oConn.Execute(sQuery)
					If Not oQuery.Eof Then
					%>
					<tr>
						<td style="text-align: right"><label>Network Feeds</label></td>
						<td colspan="2">
							<table>
								<tr>
								<% While Not oQuery.Eof %>
									<%= IIF(i <> 0 And i Mod 6 = 0, "</tr><tr>", "") %>
									<td>
										<input type="checkbox" name="CheckedID" id="CheckedID<%= oQuery("FeedID") %>" value="<%= oQuery("FeedID") %>" <%= IIF(oQuery("FeedProductID") > 0, "checked='checked'", "") %>/>
										<label for="CheckedID<%= oQuery("FeedID") %>"><%= oQuery("FeedNetworkName") %></label>
									</td>
									<% i = i + 1
									oQuery.MoveNext
								Wend %>
								</tr>
							</table>
						</td>
					</tr>
					<% End If %>
					<tr>
						<td style="text-align: right"><label for="Description">Description</label></td>
						<td colspan="2" style="padding: 5px 0 0 0"><%
						Set oEditor = New CKeditor
						oEditor.basePath = "../ckeditor/"
						oEditor.config("width") = 824
						oEditor.config("height") = 200
						oEditor.editor "Description", Description
					%></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="Specification">Specification</label></td>
						<td colspan="2"><%
						Set oEditor = New CKeditor
						oEditor.basePath = "../ckeditor/"
						oEditor.config("width") = 824
						oEditor.config("height") = 200
						oEditor.editor "Specification", Specification
					%></td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right"><label for="KeyFeature">Key Features</label></td>
						<td colspan="2"><textarea class="form-field limited limit_1000" name="KeyFeature" id="KeyFeature" cols="50" rows="5" style="width: 700px; height: 70px"><%= KeyFeature %></textarea></td>
					</tr>
					<tr style="display: none">
						<td style="text-align: right; white-space: nowrap"><label for="Includes">Product Includes</label></td>
						<td colspan="2"><textarea class="form-field limited limit_1000" name="Includes" id="Includes" cols="50" rows="5" style="width: 700px; height: 70px"><%= Includes %></textarea></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="MetaTitle">Meta Title</label></td>
						<td colspan="2"><input type="text" class="form-field" name="MetaTitle" id="MetaTitle" value="<%= MetaTitle %>" style="width: 800px" maxlength="500"/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="MetaDescription">Meta Description</label></td>
						<td colspan="2"><input type="text" class="form-field" name="MetaDescription" id="MetaDescription" value="<%= MetaDescription %>" style="width: 800px" maxlength="500"/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="MetaKey">Meta Key</label></td>
						<td colspan="2"><input type="text" class="form-field" name="MetaKey" id="MetaKey" value="<%= MetaKey %>" style="width: 800px" maxlength="500"/></td>
					</tr>
				</table>
				<br/>

				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr valign="top">
						<td style="text-align: right; width: 110px"><label>Information</label></td>
						<td>
							<table width="100%" border="0">
								<tr>
									<td style="padding-top: 0; padding-bottom: 0"><label for="InfoName1">Name</label></td>
									<td style="padding-top: 0; padding-bottom: 0"><label for="InfoValue1">Value</label></td>
								</tr>
								<tr>
									<td><input type="text" class="form-field" name="InfoName1" id="InfoName1" value="<%= InfoName1 %>" style="width: 200px" maxlength="100"/></td>
									<td><input type="text" class="form-field" name="InfoValue1" id="InfoValue1" value="<%= InfoValue1 %>" style="width: 200px" maxlength="100"/></td>
								</tr>
								<tr>
									<td><input type="text" class="form-field" name="InfoName2" id="InfoName2" value="<%= InfoName2 %>" style="width: 200px" maxlength="100"/></td>
									<td><input type="text" class="form-field" name="InfoValue2" id="InfoValue2" value="<%= InfoValue2 %>" style="width: 200px" maxlength="100"/></td>
								</tr>
								<tr>
									<td><input type="text" class="form-field" name="InfoName3" id="InfoName3" value="<%= InfoName3 %>" style="width: 200px" maxlength="100"/></td>
									<td><input type="text" class="form-field" name="InfoValue3" id="InfoValue3" value="<%= InfoValue3 %>" style="width: 200px" maxlength="100"/></td>
								</tr>
								<tr>
									<td><input type="text" class="form-field" name="InfoName4" id="InfoName4" value="<%= InfoName4 %>" style="width: 200px" maxlength="100"/></td>
									<td><input type="text" class="form-field" name="InfoValue4" id="InfoValue4" value="<%= InfoValue4 %>" style="width: 200px" maxlength="100"/></td>
								</tr>
								<tr>
									<td><input type="text" class="form-field" name="InfoName5" id="InfoName5" value="<%= InfoName5 %>" style="width: 200px" maxlength="100"/></td>
									<td><input type="text" class="form-field" name="InfoValue5" id="InfoValue5" value="<%= InfoValue5 %>" style="width: 200px" maxlength="100"/></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<br/>

				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<% If iID > 0 Then %>
					<tr>
						<td style="text-align: right; width: 110px">Current Rating</td>
						<td colspan="2"><strong><%= Rating %></strong>&nbsp;&nbsp;&nbsp;(<a href="ProductReviewList.asp?ProductID=<%= iID %>">View Reviews</a>)<input type="hidden" name="Rating" value="<%= Rating %>"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Created</td>
						<td colspan="2"><strong><%= CreateDate & IIF(CreateUser <> "", " (by " & CreateUser & ")", "") %></strong></td>
					</tr>
					<% If Updatedate <> "" Then %>
					<tr>
						<td style="text-align: right">Updated</td>
						<td colspan="2"><strong><%= Updatedate & IIF(UpdateUser <> "", " (by " & UpdateUser & ")", "") %></strong></td>
					</tr>
					<% End If %>
					<% End If %>
					<tr>
						<td>&nbsp;</td>
						<td colspan="2">
							<div style="float: left"><input type="submit" class="form-btn" value="Save"/></div>
							<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
							<% If iID > 0 Then %>
							<div style="float: left"><input type="button" class="form-btn" value="Delete" onclick="redirect('ProductDelete.asp?ID=<%= iID %>')"/></div>
							<% End If %>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">//<![CDATA[
		<% If iID > 0 Then %>
		var lastCatIds = new Array();
		var currentMainCategory = <%= categoryID %>;
		$('#CategoryID').change(function(){
			var selID = $(this).val();

			var inpObj = $('#CategoryID'+currentMainCategory);
			inpObj.attr({disabled: false, checked: false});
			inpObj.parent()
				.removeClass('disabled');

			var inpObj2 = $('#CategoryID'+selID);
			inpObj2.attr({disabled: true, checked: false});
			inpObj2.parent()
				.addClass('disabled')
				.removeClass('checked');

			currentMainCategory = selID;
			categoriesApply();
		});

		$('#ProductCategories [name="Apply"]').click(function(){
			categoriesApply();
			$('#ProductCategoriesIE7').hide();
			$.mask.close();
		});
		$('#CategoriesClose,#ProductCategories [name="Cancel"]').click(categoriesCancel);
		$('#ProductCategories ul li input:checkbox').click(function(){
			if ($(this).attr('checked')) {
				$(this).parent().addClass('checked');
			}
			else {
				$(this).parent().removeClass('checked');
			}
		});

		$('#ProductCategoriesCurrent a').live('click', function(){
			var clickedId = $(this).attr('id').replace('CategoryLink', '');
			lastCatIds = getCategoryCurrentIds();

			if (!$.browser.msie || ($.browser.msie && $.browser.version.substr(0, 1) > 7)) {
				$('#ProductCategoriesIE7').expose({
					loadSpeed: 'fast',
					closeOnClick: false,
					closeOnEsc: false,
					onBeforeLoad: function(){
						showPopup(clickedId);
					}
				});
			}
			else {
				showPopup(clickedId);
			}

			return false;
		});

		function getCategoryCurrentIds() {
			var ids = new Array();
			$('#ProductCategories ul li input:checkbox').each(function(){
				if ($(this).attr('checked')) {
					ids.push($(this).attr('id').replace('CategoryID', ''));
				}
			});
			return ids;
		}
		function categoriesApply() {
			lastCatIds = getCategoryCurrentIds();
			var newCurCats = '';
			$.each(lastCatIds, function(i, id){
				if (newCurCats != '') {
					newCurCats += ', ';
				}
				newCurCats += '<a href="#" id="CategoryLink'+id+'">'+$('#CategoryLabel'+id).text()+'</a>';
			});

			if (newCurCats == '') {
				newCurCats = '<a href="#" id="CategoryLink0">Click here to select categories</a>';
			}

			$('#ProductCategoriesCurrent').html(newCurCats);
		}
		function categoriesCancel() {
			$('#ProductCategories ul li').removeClass('checked');
			$('#ProductCategories ul li input:checkbox').attr('checked', false);
			$.each(lastCatIds, function(i, id){
				$('#CategoryID'+id).attr('checked', true);
				$('#CategoryID'+id).parent().addClass('checked');
			});
			$('#ProductCategoriesIE7').hide();
			$.mask.close();
		}
		function showPopup(clickedId) {
			$('#ProductCategoriesIE7').show();

			var maza = $('#ProductCategories ul');
			var scrollTopVal = 0;
			if (clickedId > 0) {
				scrollTopVal = maza.scrollTop() + $('#CategoryID'+clickedId).parent().position().top - 27;
			}
			maza.scrollTop(scrollTopVal);
		}
		function hidePopup() {
			if (!$.browser.msie || ($.browser.msie && $.browser.version.substr(0, 1) > 7)) {
				$.mask.close();
			}
			$('#ProductCategoriesIE7').hide();
		}
		<% End If %>

		$(function(){
			$('.add-price').click(function(){
				var html = $('.prices tr:eq(1)').clone();
				var lastVal = parseInt($('.prices tr:last-child td:eq(1) input').val());
				html.find('input').val('');
				html.find('td:last-child').html('<a href="#" class="del-price"><img src="images/grid-act-delete.png"/></a>');
				if (!isNaN(lastVal)) {
					html.find('td:first-child input').val(lastVal + 1);
				}
				$('.prices').append(html);
				if (!isNaN(lastVal)) {
					html.find('td:eq(1) input').focus();
				}
				else {
					html.find('td:first-child input').focus();
				}
				return false;
			});
			$('.del-price').live('click', function(){
				$(this).parent().parent().remove();
				return false;
			});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Model = Trim(Request("Model"))
		CategoryID = Trim(Request("CategoryID"))
		CategoryIDs = Trim(Request("CategoryIDs"))
		ManufacturerID = Trim(Request("ManufacturerID"))
		TypeID = Trim(Request("TypeID"))
		ConditionID = Trim(Request("ConditionID"))
		WarrantyID = Trim(Request("WarrantyID"))
		StatusID = Trim(Request("StatusID"))
		PolicyID = Trim(Request("PolicyID"))
		ShippingLevelID = Trim(Request("ShippingLevelID"))
		Quantity = Trim(Request("Quantity"))
		SortOrder = Trim(Request("SortOrder"))
		Description = Trim(Request("Description"))
		Specification = Trim(Request("Specification"))
		SKU = Trim(Request("SKU"))
		MPN = Trim(Request("MPN"))
		UPC = Trim(Request("UPC"))
		MSRP = Trim(Request("MSRP"))
		Cost = Trim(Request("Cost"))
		RealCost = Trim(Request("RealCost"))
		IsBestSeller = Trim(Request("IsBestSeller"))
		IsNew = Trim(Request("IsNew"))
		IsKit = Trim(Request("IsKit"))
		IsOnSale = Trim(Request("IsOnSale"))
		IsOther = Trim(Request("IsOther"))
		MetaTitle = Trim(Request("MetaTitle"))
		MetaDescription = Trim(Request("MetaDescription"))
		MetaKey = Trim(Request("MetaKey"))
		Rating = Trim(Request("Rating"))
		SaleFinishDate = Trim(Request("SaleFinishDate"))
		PriceBeforeSale = Trim(Request("PriceBeforeSale"))

		Color 		= Trim(Request("Color"))
		Location 	= Trim(Request("Location"))
		KeyFeature 	= Trim(Request("KeyFeature"))
		Includes 	= Trim(Request("Includes"))
		PunchLine 	= Trim(Request("PunchLine"))

		InfoName1 	= Trim(Request("InfoName1"))
		InfoName2 	= Trim(Request("InfoName2"))
		InfoName3 	= Trim(Request("InfoName3"))
		InfoName4 	= Trim(Request("InfoName4"))
		InfoName5 	= Trim(Request("InfoName5"))

		InfoValue1	= Trim(Request("InfoValue1"))
		InfoValue2	= Trim(Request("InfoValue2"))
		InfoValue3	= Trim(Request("InfoValue3"))
		InfoValue4	= Trim(Request("InfoValue4"))
		InfoValue5	= Trim(Request("InfoValue5"))
		Origin	= Trim(Request("Origin"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Model = "" Then
			AddError("Field <strong>Model</strong> is required.")
		End If
		If CategoryID = "" Then
			AddError("Field <strong>Main Category</strong> is required.")
		End If
		If ManufacturerID = "" Then
			AddError("Field <strong>Manufacturer</strong> is required.")
		End If
		If TypeID = "" Then
			AddError("Field <strong>Type</strong> is required.")
		End If
		If ConditionID = "" Then
			AddError("Field <strong>Condition</strong> is required.")
		End If
		If StatusID = "" Then
			AddError("Field <strong>Status</strong> is required.")
		End If
		'If PolicyID = "" Then
		'	AddError("Field <strong>Return Policy</strong> is required.")
		'End If
		If ShippingLevelID = "" Then
			AddError("Field <strong>Shipping Level</strong> is required.")
		End If
		If Quantity <> "" Then
			If Not ValidateInteger(Replace(Quantity, "-", "")) Then
				AddError("Field <strong>Quantity</strong> is invalid.")
			End If
		End If
		If Quantity <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Sort Order</strong> is invalid.")
			End If
		End If
		If SKU = "" Then
			AddError("Field <strong>SKU</strong> is required.")
		End If
		If MSRP <> "" Then
			If Not ValidateDecimal(MSRP) Then
				AddError("Field <strong>MSRP</strong> is invalid.")
			ElseIf CLng(MSRP) > 0 And CLng(MSRP) < CLng(Price) Then
				AddError("<strong>MSRP</strong> can not be less than <strong>Price</strong>.")
			End If
		End If
		If Cost <> "" Then
			If Not ValidateDecimal(Cost) Then
				AddError("Field <strong>Cost</strong> is invalid.")
			End If
		End If
		If RealCost <> "" Then
			If Not ValidateDecimal(RealCost) Then
				AddError("Field <strong>Real Cost</strong> is invalid.")
			End If
		End If
		If IsBestSeller <> "" Then
			If Not ValidateInteger(IsBestSeller) Then
				AddError("Field <strong>Best Seller</strong> is invalid.")
			End If
		End If
		If IsNew <> "" Then
			If Not ValidateInteger(IsNew) Then
				AddError("Field <strong>New</strong> is invalid.")
			End If
		End If
		If IsOnSale <> "" Then
			If Not ValidateInteger(IsOnSale) Then
				AddError("Field <strong>On Sale</strong> is invalid.")
			End If
		End If
		If IsOther <> "" Then
			If Not ValidateInteger(IsOther) Then
				AddError("Field <strong>Other</strong> is invalid.")
			End If
		End If
		If SaleFinishDate <> "" Then
			If Not ValidateDate(SaleFinishDate) Then
				AddError("Field <strong>Sale Finish Date</strong> is invalid.")
			End If
			If PriceBeforeSale = "" Then
				AddError("Field <strong>Price Before Sale</strong> is required.")
			End If
		End If
		If PriceBeforeSale <> "" Then
			If Not ValidateDecimal(PriceBeforeSale) Then
				AddError("Field <strong>Price Before Sale</strong> is invalid.")
			End If
		End If

		If Trim(Replace(Request("QtyFrom"), ",", "")) = "" Or Trim(Replace(Request("QtyPrice"), ",", "")) = "" Then
			AddError("Field <strong>Prices</strong> is required.")
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("ProductBackURL") = "", sDefaultURL, Session("ProductBackURL"))
	End Function

	Sub SetBackURL()
		Session("ProductFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub

	Sub SavePrices()
		Dim iQtyFrom, iQtyTo, dQtyPrice
		Dim arQtyFrom, arQtyTo, arQtyPrice
		arQtyFrom	= Split(Request("QtyFrom"), ", ")
		arQtyTo		= Split(Request("QtyTo"), ", ")
		arQtyPrice	= Split(Request("QtyPrice"), ", ")

		ReDim Preserve arQuery(-1)
		For iIndex = 0 To UBound(arQtyFrom)
			iQtyFrom	= arQtyFrom(iIndex)
			If Ubound(arQtyTo) >= iIndex Then
				iQtyTo	= IIF(arQtyTo(iIndex) <> "", arQtyTo(iIndex), "NULL")
			Else
				iQtyTo	= "NULL"
			End If
			dQtyPrice	= DecimalPatch(arQtyPrice(iIndex))

			If Trim(arQtyFrom(iIndex)) <> "" And Trim(arQtyPrice(iIndex)) <> "" Then
				ReDim Preserve arQuery(Ubound(arQuery) + 1)
				sQuery = "INSERT INTO utb_ProductPrices(ProductID, ProductPriceQtyFrom, ProductPriceQtyTo, ProductPriceAmount) " &_
						 "VALUES(" & iProductID & ", " & iQtyFrom & ", " & iQtyTo & ", '" & dQtyPrice & "')"
				arQuery(Ubound(arQuery)) = sQuery
			End If
		Next

		oConn.Execute("DELETE FROM utb_ProductPrices WHERE ProductID = " & iProductID)
		If UBound(arQuery) >= 0 Then
			oConn.Execute(Join(arQuery, vbNewLine))
		End If

		sQuery = " UPDATE utb_Products" &_
				 "	  SET ProductPrice = (" &_
				 "			SELECT MIN(ProductPriceAmount)" &_
				 "			  FROM utb_ProductPrices" &_
				 "			 WHERE ProductID = " & iProductID &_
				 "		  )" &_
				 "	WHERE ProductID = " & iProductID
		oConn.Execute(sQuery)
	End Sub
%>
