﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim sAction : sAction = Request("Action")
	Dim iType : iType = Request("Type")
	Dim sBackURL : sBackURL = "Default.asp"

	If GetIndex(iType, Array("1", "2", "3", "4")) = -1 Then 
		iType = 1
	End If

	If GetIndex(sAction, Array("", "Update", "Remove")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, sWhere, sField
	Select Case iType
		Case "1" 
			sTitle = "Best Sellers"
			sWhere = " WHERE p.ProductIsBestSeller > 0 "
			sField = "ProductIsBestSeller"
		Case "2"
			sTitle = "New Products"
			sWhere = " WHERE p.ProductIsNew > 0 "
			sField = "ProductIsNew"
		Case "3" 
			sTitle = "On Sale Products"
			sWhere = " WHERE p.ProductIsOnSale > 0 "
			sField = "ProductIsOnSale"
		Case "4" 
			sTitle = "Other Products"
			sWhere = " WHERE p.ProductIsOther > 0 "
			sField = "ProductIsOther"
	End Select

	Select Case sAction
		Case "Update"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = "UPDATE utb_Products" &_
					 "	 SET " & sField & " = 0" &_
					 "	   , ProductUpdateDate = GETDATE()" &_
					 "	   , ProductUpdateUser = '" & Quote(Session("UserNickName")) & "'" &_
					 " WHERE " & sField & " > 0" &_
					 IIF(Request("CheckedID") <> "", " AND ProductID NOT IN (" & Request("CheckedID") & ") ", "")
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Products have been updated.")
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
			End If
			Redirect("ProductListByType.asp?Type=" & iType)

		Case "Remove"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = "UPDATE utb_Products" &_
					 "	 SET " & sField & " = 0" &_
					 "	   , ProductUpdateDate = GETDATE()" &_
					 "	   , ProductUpdateUser = '" & Quote(Session("UserNickName")) & "'" &_
					 " WHERE " & sField & " > 0"
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Products have been removed.")
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
			End If
			Redirect("ProductListByType.asp?Type=" & iType)
	End Select

	Dim iOtherCnt : iOtherCnt	= GetValueFromTable(oConn, "COUNT(*)", "utb_Products", "WHERE ProductIsOther > 0")
	Dim iOnSaleCnt : iOnSaleCnt	= GetValueFromTable(oConn, "COUNT(*)", "utb_Products", "WHERE ProductIsOnSale > 0")
	Dim iNewCnt : iNewCnt		= GetValueFromTable(oConn, "COUNT(*)", "utb_Products", "WHERE ProductIsNew > 0")
	Dim iBestCnt : iBestCnt		= GetValueFromTable(oConn, "COUNT(*)", "utb_Products", "WHERE ProductIsBestSeller > 0")
	
	Dim sOrder, sArrow, sOrderBy, sOrderQuery
	sOrder = "6"
	sArrow = "2"
	If Request("Order") <> "" And Request("Arrow") <> "" Then
		sOrder = Request("Order")
		sArrow = Request("Arrow")
	End If
	sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")
	sOrderQuery = GetURLWithout("Order,Arrow")

	sQuery = "SELECT p.*" &_
			 "	   , ps.ProductStatusName" &_
			 "	   , (CASE WHEN ISNULL(ProductDescription, '') <> '' THEN 1 ELSE 0 END) AS _ProductDescription" &_
			 "	   , CONVERT(VARCHAR(10), p.ProductCreateDate, 101) AS _ProductCreateDate" &_
			 "	FROM utb_Products p" &_
			 "		 INNER JOIN utb_ProductStatuses ps ON ps.ProductStatusID = p.ProductStatusID" &_
			 " " & sWhere &_
			 " " & sOrderBy

	Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount, iCount
	iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
	iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
	Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
	iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Products</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<a class="head-link-right" href="ProductListByType.asp?Type=4"><%= IIF(iType = 4, "<strong>", "") %>Other Products (<%= iOtherCnt %>)<%= IIF(iType = 4, "</strong>", "") %></a>
			<a class="head-link-right" href="ProductListByType.asp?Type=3"><%= IIF(iType = 3, "<strong>", "") %>On Sale Products (<%= iOnSaleCnt %>)<%= IIF(iType = 3, "</strong>", "") %></a>
			<a class="head-link-right" href="ProductListByType.asp?Type=2"><%= IIF(iType = 2, "<strong>", "") %>New Products (<%= iNewCnt %>)<%= IIF(iType = 2, "</strong>", "") %></a>
			<a class="head-link-right" href="ProductListByType.asp?Type=1"><%= IIF(iType = 1, "<strong>", "") %>Best Sellers (<%= iBestCnt %>)<%= IIF(iType = 1, "</strong>", "") %></a>
			<h2><%= sTitle %></h2>
		</div>
		<form action="" method="post">
			<div style="display: none"><input type="hidden" name="Action" value="Update"/></div>
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
				<tr class="head-line">
					<td style="width: 40px"><input type="checkbox" id="check_all" onclick="$('.checkbox').attr('checked', $('#check_all').is(':checked'))"/></td>
					<td style="width: 120px"><%= GetURLForOrder("SKU", "1", sOrderQuery, sOrder, sArrow) %></td>
					<td><%= GetURLForOrder("Name", "2", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 70px"><%= GetURLForOrder("Quantity", "3", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 70px"><%= GetURLForOrder("Price", "4", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 79px"><%= GetURLForOrder("Status", "5", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 70px"><%= GetURLForOrder("Created", "6", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 150px">
						<%= GetURLForOrder("Best", "7", sOrderQuery, sOrder, sArrow) %> /
						<%= GetURLForOrder("New", "8", sOrderQuery, sOrder, sArrow) %> /
						<%= GetURLForOrder("Sale", "9", sOrderQuery, sOrder, sArrow) %> /
						<%= GetURLForOrder("Other", "10", sOrderQuery, sOrder, sArrow) %>
					</td>
				</tr>
				<%
				While Not oQuery.Eof 
					iCount = iCount + 1
					%>
					<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
						<td><input type="checkbox" class="checkbox" name="CheckedID" value="<%= oQuery("ProductID") %>"/></td>
						<td style="text-align: left"><a href="ProductForm.asp?Action=Edit&amp;ID=<%= oQuery("ProductID") %>"><%= oQuery("ProductSKU") %></a></td>
						<td style="text-align: left"><%= oQuery("ProductName") %></td>
						<td><%= oQuery("ProductQuantity") %></td>
						<td style="text-align: right"><%= CurrencyFormat(oQuery("ProductPrice"), 2) %></td>
						<td style="padding: 0"><%= oQuery("ProductStatusName") %></td>
						<td><%= oQuery("_ProductCreateDate") %></td>
						<td><%= oQuery("ProductIsBestSeller") & " / " & oQuery("ProductIsNew") & " / " & oQuery("ProductIsOnSale") & " / " & oQuery("ProductIsOther") %></td>
					</tr>
					<%
					oQuery.MoveNext
				Wend
				oQuery.Close
				Set oQuery = Nothing
				%>
			</table>
			<%
			If iRecordCount = 0 Then
				%><!--#include file="inc/NoRecords.asp"--><%
			Else
				%>
				<div style="margin-top: 15px">
					<div style="float: left"><input type="submit" class="form-btn" value="Update"/></div>
					<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
					<div style="float: left"><input type="button" class="form-btn" value="Remove All" onclick="if (areYouSure()) redirect('ProductListByType.asp?Type=<%= iType %>&amp;Action=Remove')"/></div>
				</div>
				<%
			End If
			%>
		</form>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub SetBackURL()
		Session("ProductBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub

	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "p.ProductSKU"

		Select Case sIndex
			Case "1" sColumn = "p.ProductSKU"
			Case "2" sColumn = "p.ProductName"
			Case "3" sColumn = "p.ProductQuantity"
			Case "4" sColumn = "p.ProductPrice"
			Case "5" sColumn = "ps.ProductStatusName"
			Case "6" sColumn = "p.ProductCreateDate"
			Case "7" sColumn = "p.ProductIsBestSeller"
			Case "8" sColumn = "p.ProductIsNew"
			Case "9" sColumn = "p.ProductIsOnSale"
			Case "10" sColumn = "p.ProductIsOther"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>