<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Upload.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	Dim oUploader
	Set oUploader = New FileUploader
	oUploader.Upload()

	iID = IIF(iID <> "", iID, oUploader.Form("ID"))
	sAction = IIF(sAction <> "", sAction, oUploader.Form("Action"))

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim Name
	Dim sProductName, sImageName, imgType

	Set oQuery = oConn.Execute("SELECT * FROM utb_Products WHERE ProductID = " & iID)
	If Not oQuery.Eof Then
		sProductName = oQuery("ProductName")
		sImageName = oQuery("ProductImage")
	End If
	oQuery.Close
	Set oQuery = Nothing

	Select Case sAction
		Case "Update"
			CommonValidation()
			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				Dim oFile : Set oFile = oUploader.Files.Item("File") 
				Dim sFileName : sFileName = iID & "." & GetFileExtension(oFile.FileName)

				sQuery = "UPDATE utb_Products" &_
						 "	 SET ProductImage = '" & Quote(sFileName) & "'" &_
						 "	   , ProductUpdateDate = GETDATE()" &_
						 "	   , ProductUpdateUser = '" & Quote(Session("UserNickName")) & "'" &_
						 " WHERE ProductID = " & iID
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					Select Case imgType
						Case "1"
							Call SaveBinaryData(Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & sFileName, oFile.FileData)
						Case "2"
							Call SaveBinaryData(Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & sFileName, oFile.FileData)
						Case "3"
							Call SaveBinaryData(Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & sFileName, oFile.FileData)
						Case "4"
							Call SaveBinaryData(Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & sFileName, oFile.FileData)
					End Select

					If Err.Number = 0 Then
						If sImageName <> sFileName Then
							Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & sImageName)
							Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & sImageName)
							Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & sImageName)
							Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & sImageName)
						End If

						oConn.CommitTrans
						Call SetAlertMessage("success", "Product main image has been uploaded.")
						Redirect("ProductMainImageForm.asp?ID=" & iID)
					Else
						oConn.RollbackTrans
						AddError(Err.Description)
					End If
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = "UPDATE utb_Products" &_
					 "	 SET ProductImage = NULL" &_
					 "	   , ProductUpdateDate = GETDATE()" &_
					 "	   , ProductUpdateUser = '" & Quote(Session("UserNickName")) & "'" &_
					 "  WHERE ProductID = " & iID
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				If sImageName <> "" Then
					Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & sImageName)
					Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & sImageName)
					Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & sImageName)
					Call DeleteFile(Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & sImageName)
				End If

				oConn.CommitTrans
				Call SetAlertMessage("success", "Product main image has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Products</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head"><h2>Main Image for <%= sProductName %></h2></div>
		<div class="box">
			<form action="ProductMainImageForm.asp" method="post" enctype="multipart/form-data">
				<input type="hidden" name="Action" id="Action" value="Update"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> File</td>
						<td><input type="file" name="File" style="width: 400px" /></td>
					</tr>
					<tr>
						<td style="text-align: right">Type</td>
						<td>
							<select name="imgType" id="imgType">
								<option value="4"<%= IIF(imgType = "4", " selected='selected'", "") %>>Mini</option>
								<option value="3"<%= IIF(imgType = "3", " selected='selected'", "") %>>Small</option>
								<option value="2"<%= IIF(imgType = "2", " selected='selected'", "") %>>Medium</option>
								<option value="1"<%= IIF(imgType = "1", " selected='selected'", "") %>>Large</option>
							</select>
							&nbsp;
							<span class="img-size"></span>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float: left"><input type="submit" class="form-btn" value="Upload"/></div>
							<% If sImageName <> "" Then %>
							<div style="float: left"><input type="button" class="form-btn" value="Delete All Images"
								onclick="if (areYouSure()) redirect('ProductMainImageForm.asp?Action=Delete&ID=<%= iID %>')"/></div>
							<% End If %>
						</td>
					</tr>
				</table>
				<%
				If sImageName <> "" Then
					Dim objFSO
					Set objFSO = CreateObject("Scripting.FileSystemObject")
					%>
					<br/>
					<table cellpadding="5" cellspacing="0" border="0" class="form-cells">
						<% If objFSO.FileExists(Server.MapPath(C_PRODUCT_IMAGE_MINI_PATH) & "/" & sImageName) Then %>
						<tr>
							<td>Mini:<br/><img src="<%= C_PRODUCT_IMAGE_MINI_PATH & "/" & sImageName %>" alt="" class="imgborder"/></td>
						</tr>
						<% End If %>
						<% If objFSO.FileExists(Server.MapPath(C_PRODUCT_IMAGE_SMALL_PATH) & "/" & sImageName) Then %>
						<tr>
							<td>Small:<br/><img src="<%= C_PRODUCT_IMAGE_SMALL_PATH & "/" & sImageName %>" alt="" class="imgborder"/></td>
						</tr>
						<% End If %>
						<% If objFSO.FileExists(Server.MapPath(C_PRODUCT_IMAGE_MEDIUM_PATH) & "/" & sImageName) Then %>
						<tr>
							<td>Medium:<br/><img src="<%= C_PRODUCT_IMAGE_MEDIUM_PATH & "/" & sImageName %>" alt="" class="imgborder"/></td>
						</tr>
						<% End If %>
						<% If objFSO.FileExists(Server.MapPath(C_PRODUCT_IMAGE_LARGE_PATH) & "/" & sImageName) Then %>
						<tr>
							<td>Large:<br/><img src="<%= C_PRODUCT_IMAGE_LARGE_PATH & "/" & sImageName %>" alt="" class="imgborder"/></td>
						</tr>
						<% End If %>
					</table>
					<%
				End If
				%>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script>
		$(function(){
			$('#imgType').change(function(){
				var size = '';
				switch ($(this).val()) {
					case '1':
						size = '<%= C_PRODUCT_IMAGE_LARGE_WIDTH %>x<%= C_PRODUCT_IMAGE_LARGE_HEIGHT %>';
						break;
					case '2':
						size = '<%= C_PRODUCT_IMAGE_MEDIUM_WIDTH %>x<%= C_PRODUCT_IMAGE_MEDIUM_HEIGHT %>';
						break;
					case '3':
						size = '<%= C_PRODUCT_IMAGE_SMALL_WIDTH %>x<%= C_PRODUCT_IMAGE_SMALL_HEIGHT %>';
						break;
					case '4':
						size = '<%= C_PRODUCT_IMAGE_MINI_WIDTH %>x<%= C_PRODUCT_IMAGE_MINI_HEIGHT %>';
						break;
				}
				$('.img-size').text('Size: ' + size + 'px');
			}).trigger('change');
		});
		</script>
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(oUploader.Form("Name"))
		imgType = Trim(oUploader.Form("imgType"))

		If imgType <> "1" And imgType <> "2" And imgType <> "3" And imgType <> "4" Then
			AddError("Field <strong>Type</strong> is required.")
		End If
		If oUploader.Files.Count = 0 Then
			AddError("Field <strong>File</strong> is required.")
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("ProductFormBackURL") = "", sDefaultURL, Session("ProductFormBackURL"))
	End Function
%>