<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("ProductReviewList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("Edit", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim SKU, Name, Content, Rating, IP, IsActive
	Dim iProductReviewID

	Select Case sAction
		Case "Edit"
			sTitle = "Edit Review Ref # " & iID
			sAction = "Update"

			sQuery = " SELECT pr.* " & _
					 "	  , p.ProductSKU " & _
					 "   FROM utb_ProductReviews pr " & _
					 "		INNER JOIN utb_Products p ON p.ProductID = pr.ProductID " & _
					 "  WHERE pr.ProductReviewID = '" & Quote(iID) & "' "

			Set oQuery = oConn.Execute(sQuery)
			If Not oQuery.Eof Then
				SKU = HTMLEncode(oQuery("ProductSKU"))
				Name = HTMLEncode(oQuery("ProductReviewName"))
				Content = HTMLEncode(oQuery("ProductReviewContent"))
				Rating = oQuery("ProductReviewRating")
				IP = HTMLEncode(oQuery("ProductReviewIP"))
				IsActive = oQuery("ProductReviewIsActive")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Update"
			sTitle = "Edit Review Ref # " & iID

			CommonValidation()

			If Not IsError() Then
				oConn.BeginTrans
			
				On Error Resume Next
			
				sQuery = " UPDATE utb_ProductReviews " & _
						 "	SET ProductReviewName = '" & Quote(Name) & "' " & _
						 "	  , ProductReviewContent = '" & Quote(Content) & "' " & _
						 "	  , ProductReviewRating = '" & Quote(Rating) & "' " & _
						 "	  , ProductReviewIP = '" & Quote(IP) & "' " & _
						 "	  , ProductReviewIsActive = '" & Quote(IsActive) & "' " & _
						 "  WHERE ProductReviewID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)
			
				iProductReviewID = iID
			
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Review has been updated.")
					Redirect("ProductReviewForm.asp?Action=Edit&ID=" & iProductReviewID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_ProductReviews " & _
					 "  WHERE ProductReviewID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Review has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Reviews</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="ProductReviewForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;">SKU</td>
				<td><strong><%= SKU %></strong><input type="hidden" name="SKU" value="<%= SKU %>" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Content</td>
				<td><textarea class="form-field limited limit_1000" name="Content" style="width:500px;height:100px;"><%= Content %></textarea></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Rating</td>
				<td>
					<select class="selector" name="Rating" style="width:40px;">
						<option value="1" <%= IIF(Rating = "1", "selected='selected'", "") %>>1</option>
						<option value="2" <%= IIF(Rating = "2", "selected='selected'", "") %>>2</option>
						<option value="3" <%= IIF(Rating = "3", "selected='selected'", "") %>>3</option>
						<option value="4" <%= IIF(Rating = "4", "selected='selected'", "") %>>4</option>
						<option value="5" <%= IIF(Rating = "5", "selected='selected'", "") %>>5</option>
					</select>
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">IP</td>
				<td><input type="text" class="form-field" name="IP" value="<%= IP %>" style="width: 102px" maxlength="15" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="IsActive">Active</label></td>
				<td>
					<input type="checkbox" name="IsActive" id="IsActive" value="1" <%= IIF(IsActive = "1", "checked='checked'", "") %> />
				</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		SKU = Trim(Request("SKU"))
		Name = Trim(Request("Name"))
		Content = Trim(Request("Content"))
		Rating = Trim(Request("Rating"))
		IP = Trim(Request("IP"))
		IsActive = Trim(Request("IsActive"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Content = "" Then
			AddError("Field <strong>Content</strong> is required.")
		End If
		If Rating = "" Then
			AddError("Field <strong>Rating</strong> is required.")
		End If
		If IP <> "" Then
			If Not ValidateIP(IP) Then
				AddError("Field <strong>IP</strong> is invalid.")
			End If
		End If
	End Sub
%>