﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Select Case sAction
		Case "Update"
			Dim iProductCount, ProductID, ProductSKU, ProductQuantity, ProductMSRP, ProductPrice, ProductCost, ProductStatus
			ProductID = Split(Request("_ID"), ", ")
			ProductSKU = Split(Request("_SKU"), ", ")
			ProductQuantity = Split(Request("_Quantity"), ", ")
			ProductMSRP = Split(Request("_MSRP"), ", ")
			ProductPrice = Split(Request("_Price"), ", ")
			ProductCost = Split(Request("_Cost"), ", ")
			ProductStatus = Split(Request("_StatusID"), ", ")

			Dim arQuery, ID, SKU, Quantity, MSRP, Price, Cost, StatusID
			ReDim arQuery(UBound(ProductID))

			For iProductCount = 0 To UBound(ProductID)
				ID = Trim(ProductID(iProductCount))
				SKU = Trim(ProductSKU(iProductCount))
				Quantity = Trim(ProductQuantity(iProductCount))
				MSRP = Trim(ProductMSRP(iProductCount))
				Price = Trim(ProductPrice(iProductCount))
				Cost = Trim(ProductCost(iProductCount))
				StatusID = Trim(ProductStatus(iProductCount))

				If Not ValidateInteger(Quantity) Then
					AddError("Field <strong>Quantity</strong> for item '" & SKU & "' is invalid.")
				End If
				If Not ValidateDecimal(MSRP) Then
					AddError("Field <strong>Retail</strong> for item '" & SKU & "' is invalid.")
				End If
				If Not ValidateDecimal(Price) Then
					AddError("Field <strong>Price</strong> for item '" & SKU & "' is invalid.")
				End If
				If Not ValidateDecimal(Cost) Then
					AddError("Field <strong>Cost</strong> for item '" & SKU & "' is invalid.")
				End If

				If Not IsError() Then
					sQuery = " UPDATE utb_Products" &_
							 "	  SET ProductQuantity = '" & IIF(Quantity = "", "0", Quote(Quantity)) & "'" &_
							 "		, ProductMSRP = '" & IIF(MSRP = "", "0", Quote(DecimalPatch(MSRP))) & "'" &_
							 "		, ProductPrice = '" & IIF(Price = "", "0", Quote(DecimalPatch(Price))) & "'" &_
							 "		, ProductCost = '" & IIF(Cost = "", "0", Quote(DecimalPatch(Cost))) & "'" &_
							 "		, ProductStatusID = " & StatusID &_
							 "	WHERE ProductID = " & ID
					arQuery(iProductCount) = sQuery
				End If
			Next

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				If UBound(arQuery) >= 0 Then
					oConn.Execute(Join(arQuery, vbNewLine))
				End If

				If Err.Number = 0 Then
					oConn.CommitTrans
					If iProductCount > 0 Then
						Call SetAlertMessage("success", "Products have been updated.")
					End If
					Redirect(sBackURL)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Search</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		Dim sSearchStr, sWhereSQL, sWhere, sProductListTitle, iGridMode
		sSearchStr = Left(Trim(Request("SearchString")), 50)
		sWhereSQL = GetProductSearchSQL(sSearchStr)
		If sWhereSQL <> "" Then
			sWhere = "WHERE " & sWhereSQL
		End If

		sProductListTitle = "Search Results for : " & sSearchStr
		iGridMode = 2
		%>
		<form action="" method="post">
			<input type="hidden" name="Action" value="Update"/>
			<!--#include file="inc/ProductGrid.asp"-->
			<br/>
			<div style="float: left"><input type="submit" class="form-btn" value="Update"/></div>
			<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
		</form>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("ProductBackURL") = "", sDefaultURL, Session("ProductBackURL"))
	End Function
%>