<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("ProductTypeList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name
	Dim iProductTypeID

	Select Case sAction
		Case "New"
			sTitle = "Add Product Type"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Product Type Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_ProductTypes WHERE ProductTypeID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("ProductTypeName"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Product Type"

			CommonValidation()

			If GetValueFromTable(oConn, "ProductTypeID", "utb_ProductTypes", "WHERE ProductTypeName = '" & Quote(Name) & "'") <> "" Then
				AddError("Product Type with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " INSERT INTO utb_ProductTypes (ProductTypeName) " & _
						 " VALUES ( " & _
						 "   '" & Quote(Name) & "' " & _
						 " ) "
				oConn.Execute(sQuery)

				iProductTypeID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product Type has been inserted.")
					Redirect("ProductTypeForm.asp?Action=Edit&ID=" & iProductTypeID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Product Type Ref # " & iID

			CommonValidation()

			If GetValueFromTable(oConn, "ProductTypeID", "utb_ProductTypes", "WHERE ProductTypeName = '" & Quote(Name) & "' AND ProductTypeID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Product Type with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_ProductTypes " & _
						 "	SET ProductTypeName = '" & Quote(Name) & "' " & _
						 "  WHERE ProductTypeID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iProductTypeID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Product Type has been updated.")
					Redirect("ProductTypeForm.asp?Action=Edit&ID=" & iProductTypeID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_ProductTypes " & _
					 "  WHERE ProductTypeID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Product Type has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Product Types</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="ProductTypeForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
	End Sub
%>