<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim Name, WarrantyID, PriceFrom, PriceTo
	sQuery = "SELECT p.ProductName" &_
			 "	   , ISNULL(pw.WarrantyID, 0) AS WarrantyID" &_
			 "	   , pw.ProductWarrantyFromPrice" &_
			 "	   , pw.ProductWarrantyToPrice" &_
			 "	FROM utb_Products p" &_
			 "		 LEFT JOIN utb_ProductWarranties pw ON pw.ProductID = p.ProductID" &_
			 " WHERE p.ProductID = '" & Quote(iID) & "'"

	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		Name		= oQuery("ProductName")
		WarrantyID	= oQuery("WarrantyID")
		If WarrantyID > 0 Then
			PriceFrom	= oQuery("ProductWarrantyFromPrice")
			PriceTo		= oQuery("ProductWarrantyToPrice")
		End If
	End If
	oQuery.Close
	Set oQuery = Nothing

	Dim iWarrantyID : iWarrantyID = Trim(Request("WarrantyID"))
	Dim dPriceFrom : dPriceFrom = Trim(Request("PriceFrom"))
	Dim dPriceTo : dPriceTo = Trim(Request("PriceTo"))
	If Request("Submit") <> "" Then
		If iWarrantyID = "" Then
			AddError("Field <strong>Warraty Type</strong> is required.")
		ElseIf Not ValidateInteger(iWarrantyID) Then
			AddError("Field <strong>Warraty Type</strong> is invalid.")
		End If

		If dPriceFrom = "" Then
			AddError("Field <strong>Price From</strong> is required.")
		Else
			If Not ValidateDecimal(dPriceFrom) Then
				AddError("Field <strong>Price From</strong> is invalid.")
			End If
		End If

		If dPriceTo = "" Then
			AddError("Field <strong>Price To</strong> is required.")
		Else
			If Not ValidateDecimal(dPriceTo) Then
				AddError("Field <strong>Price To</strong> is invalid.")
			End If
		End If
		
		If Not IsError() Then
			If CLng(dPriceTo) <= CLng(dPriceFrom) Then
				AddError("Field <strong>Price From</strong> should be less that field <strong>Price To</strong>")
			End If
		End If

		If Not IsError() Then
			Dim sMessage : sMessage = ""

			oConn.BeginTrans
			On Error Resume Next

			If WarrantyID > 0 Then
				sQuery = "UPDATE utb_ProductWarranties" &_
						 "	 SET WarrantyID = '" & Quote(iWarrantyID) & "'" &_
						 "	   , ProductWarrantyFromPrice = '" & Quote(DecimalPatch(dPriceFrom)) & "'" &_
						 "	   , ProductWarrantyToPrice = '" & Quote(DecimalPatch(dPriceTo)) & "'" &_
						 " WHERE ProductID = '" & Quote(iID) & "'"

				sMessage = "Changes has been saved"
			Else
				sQuery = "INSERT utb_ProductWarranties(" &_
						 "	ProductID" &_
						 ", WarrantyID" &_
						 ", ProductWarrantyFromPrice" &_
						 ", ProductWarrantyToPrice" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(iID) & "'" &_
						 ", '" & Quote(iWarrantyID) & "'" &_
						 ", '" & Quote(DecimalPatch(dPriceFrom)) & "'" &_
						 ", '" & Quote(DecimalPatch(dPriceTo)) & "'" &_
						 ")"

				sMessage = "Product has been set as warranty"
			End If

			oConn.Execute(sQuery)
			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", sMessage)
				Redirect("ProductWarrantyForm.asp?ID=" & iID)
			Else
				oConn.RollbackTrans
				AddError(Err.Description)
			End If
		Else
			WarrantyID	= iWarrantyID
			PriceFrom	= dPriceFrom
			PriceTo		= dPriceTo
		End If
	ElseIf Request("Action") = "Delete" Then
		oConn.BeginTrans
		On Error Resume Next

		oConn.Execute("DELETE FROM utb_ProductWarranties WHERE ProductID = '" & Quote(iID) & "'")
		If Err.Number = 0 Then
			oConn.CommitTrans
			Call SetAlertMessage("success", "Warranty has been deleted.")
		Else
			oConn.RollbackTrans
			Call SetAlertMessage("error", Err.Description)
		End If
		Redirect(sBackURL)
	End If

	Dim sTitle
	sTitle = "Product " & Name

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Product Warranty</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="ProductWarrantyForm.asp?ID=<%= iID %>" method="post">
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Warraty Type</td>
						<td>
							<select class="selector" name="WarrantyID" style="width:200px;">
								<option value="">Select One</option>
							<%
								Set oQuery = oConn.Execute("SELECT * FROM utb_Warranties ORDER BY WarrantyName")
								While Not oQuery.Eof
							%>
								<option value="<%= oQuery("WarrantyID") %>" <%= IIF(CStr(oQuery("WarrantyID")) = CStr(IIF(IsNull(WarrantyID), "", WarrantyID)), "selected='selected'", "") %>><%= oQuery("WarrantyName") %></option>
							<%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
							%>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Price From</td>
						<td><input type="text" class="form-field" name="PriceFrom" value="<%= PriceFrom %>" style="width:150px;" maxlength="15" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Price To</td>
						<td><input type="text" class="form-field" name="PriceTo" value="<%= PriceTo %>" style="width:150px;" maxlength="15" /></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" name="Submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="button" class="form-btn" value="Delete" onclick="if (areYouSure()) redirect('ProductWarrantyForm.asp?ID=<%= iID %>&amp;Action=Delete')" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("ProductFormBackURL") = "", sDefaultURL, Session("ProductFormBackURL"))
	End Function
%>