﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim sAction : sAction = Request("Action")
	Dim iPromoCodeID : iPromoCodeID = Request("PromoCodeID")
	Dim sBackURL : sBackURL = GetBackURL("Default.asp")

	If Not ValidateInteger(iPromoCodeID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("", "Update", "Assign")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim SearchString : SearchString = Request("SearchString") 

	Select Case sAction
		Case "Update"
			If Request("CheckedID") <> "" Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " DELETE " & _
						 "   FROM utb_PromoCodeProducts " & _
						 "  WHERE PromoCodeID = '" & Quote(iPromoCodeID) & "' " & _
						 "	AND ProductID IN (" & Request("CheckedID") & ")"
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Products have been removed.")
					Redirect("PromoCodeAssignProductList.asp?PromoCodeID=" & iPromoCodeID)
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
					Redirect("PromoCodeAssignProductList.asp?PromoCodeID=" & iPromoCodeID)
				End If
			End If

		Case "Assign"
			oConn.BeginTrans
			On Error Resume Next

			Dim iIndex, arCheckedID
			arCheckedID = Split(Request("CheckedID"), ", ")

			Dim arQuery
			ReDim arQuery(UBound(arCheckedID))

			For iIndex = 0 To UBound(arCheckedID)
				sQuery = " INSERT INTO utb_PromoCodeProducts (PromoCodeID, ProductID) " & _
						 " VALUES ( " & _
						 "   '" & Quote(iPromoCodeID) & "' " & _
						 " , '" & Quote(arCheckedID(iIndex)) & "' " & _
						 " ) "
				arQuery(iIndex) = sQuery
			Next

			If UBound(arQuery) >= 0 Then
				oConn.Execute(Join(arQuery, vbNewLine))
			End If

			If Err.Number = 0 Then
				oConn.CommitTrans
				If iIndex > 0 Then
					Call SetAlertMessage("success", "Products have been assigned.")
				End If
				Redirect("PromoCodeAssignProductList.asp?PromoCodeID=" & iPromoCodeID)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect("PromoCodeAssignProductList.asp?PromoCodeID=" & iPromoCodeID)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
		<% If SearchString <> "" Then %>
		<script type="text/javascript">
		//<![CDATA[
		$(document).ready(function(){
			redirect('#Result');
		});
		//]]>
		</script>
		<% End If %>
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Assign Products for <%= GetValueFromTable(oConn, "PromoCodeName", "utb_PromoCodes", "WHERE PromoCodeID = '" & Quote(iPromoCodeID) & "'") %></h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		sQuery = "SELECT p.*" &_
				 "	   , c.CategoryID" &_
				 "	   , c.CategoryName" &_
				 "	   , ps.ProductStatusName" &_
				 "	   , (CASE WHEN ISNULL(p.ProductDescription, '') <> '' THEN 1 ELSE 0 END) AS _ProductDescription" &_
				 "	FROM utb_PromoCodeProducts pp" &_
				 "		 INNER JOIN utb_Products p ON p.ProductID = pp.ProductID" &_
				 "		 INNER JOIN utb_ProductCategories AS pcat ON pcat.ProductID = p.ProductID AND pcat.ProductCategoryIsMain = 1" &_
				 "		 INNER JOIN utb_Categories AS c ON c.CategoryID = pcat.CategoryID" &_
				 "		 INNER JOIN utb_ProductStatuses ps ON ps.ProductStatusID = p.ProductStatusID" &_
				 " WHERE pp.PromoCodeID = '" & Quote(iPromoCodeID) & "'" &_
				 " ORDER BY c.CategoryID ASC" &_
				 "	   , p.ProductName ASC"

		Set oQuery = Server.CreateObject("ADODB.Recordset")
		oQuery.Open sQuery, oConn, 1, 3, 1

		If oQuery.RecordCount > 0 Then
			%>
			<div class="box-head">
				<h2>Assigned Products</h2>
			</div>
			<form action="" method="post">
				<input type="hidden" name="Action" value="Update"/>
				<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
					<%
					Dim iProductCount : iProductCount = 0
					Dim iOldCategoryID : iOldCategoryID = ""
					While Not oQuery.Eof
						iProductCount = iProductCount + 1
						If iOldCategoryID <> oQuery("CategoryID") Then
							%>
							<tr class="head-line">
								<td><input type="checkbox" id="check_all_<%= oQuery("CategoryID") %>" onclick="$('.checkbox_<%= oQuery("CategoryID") %>').attr('checked', $('#check_all_<%= oQuery("CategoryID") %>').is(':checked'));" /></td>
								<td style="text-align:left;" colspan="6"><label for="check_all_<%= oQuery("CategoryID") %>"><%= oQuery("CategoryName") %> (<%= oQuery("CategoryID") %>)</label></td>
							</tr>
							<%
							iOldCategoryID = oQuery("CategoryID")
						End If
						%>
						<tr class="<%= IIF(iProductCount Mod 2 = 0, "row-hl", "") %>">
							<td style="width:40px;"><input type="checkbox" class="checkbox_<%= oQuery("CategoryID") %>" name="CheckedID" value="<%= oQuery("ProductID") %>" /></td>
							<td style="width:120px;"><%= oQuery("ProductSKU") %></td>
							<td style="text-align:left;"><%= oQuery("ProductName") %></td>
							<td style="width:70px;"><%= CurrencyFormat(oQuery("ProductPrice"), 2) %></td>
							<td style="width:80px;"><%= oQuery("ProductStatusName") %></td>
							<td style="width:60px;"><%= IIF(oQuery("_ProductDescription") = 1, "Yes", "No") %></td>
							<td style="width:130px;"><%= oQuery("ProductIsBestSeller") %> / <%= oQuery("ProductIsNew") %> / <%= oQuery("ProductIsOnSale") %> / <%= oQuery("ProductIsOther") %></td>
						</tr>
						<%
						oQuery.MoveNext
					Wend
					%>
				</table>
				<br/>
				<div style="float:left;"><input type="submit" class="form-btn" value="Remove Selected"/></div>
				<div style="float:left;"><input type="reset" class="form-btn" value="Reset"/></div>
				<br/><br/><br/>
			</form>
			<%
		End If
		oQuery.Close
		Set oQuery = Nothing
		%>
		<a id="Result" name="Result"></a>
		<div class="box-head">	
			<h2>Assign Products</h2>
		</div>
		<form action="" method="get">
			<input type="hidden" name="PromoCodeID" value="<%= iPromoCodeID %>">
			<table cellpadding="2" cellspacing="0" border="0">
				<tr>
					<td><input type="text" class="form-field" id="SearchString" name="SearchString" value="<%= SearchString %>" style="width:250px;" /></td>
					<td><input type="submit" class="inline-btn" value="Search" /></td>
				</tr>
			</table>
		</form>
		<%
		If SearchString <> "" Then
			Dim sWhere, sProductListTitle, iGridMode
			sWhere = " WHERE p.ProductID NOT IN (SELECT ProductID FROM utb_PromoCodeProducts WHERE PromoCodeID = '" & Quote(iPromoCodeID) & "') " & _
					 "   AND " & GetProductSearchSQL(SearchString) & " "
			sProductListTitle = "Result"
			iGridMode = 1
		%>
		<form action="" method="post">
			<input type="hidden" name="Action" value="Assign">
			<!--#include file="inc/ProductGrid.asp"-->
			<br />
			<div style="float:left;"><input type="submit" class="form-btn" value="Assign" /></div>
			<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
		</form>
		<% End If %>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("PromoCodeFormBackURL") = "", sDefaultURL, Session("PromoCodeFormBackURL"))
	End Function
%>