<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("PromoCodeList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name, Description, StartDate, FinishDate, MinPrice, MaxPrice, OrderIsPercent, OrderDiscount, ShippingMethodID, ShippingDiscount
	Dim iPromoCodeID

	Select Case sAction
		Case "New"
			sTitle = "Add Promo Code"
			sAction = "Insert"

			'Name = GeneratePromoCode(oConn, 8)
			OrderIsPercent = "0"

		Case "Edit"
			sTitle = "Edit Promo Code Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_PromoCodes WHERE PromoCodeID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("PromoCodeName"))
				Description = HTMLEncode(oQuery("PromoCodeDescription"))
				StartDate = oQuery("PromoCodeStartDate")
				FinishDate = oQuery("PromoCodeFinishDate")
				MinPrice = DecimalFormat(oQuery("PromoCodeMinPrice"), 2)
				MaxPrice = DecimalFormat(oQuery("PromoCodeMaxPrice"), 2)
				OrderIsPercent = oQuery("PromoCodeOrderIsPercent")
				OrderDiscount = DecimalFormat(oQuery("PromoCodeOrderDiscount"), 2)
				ShippingMethodID = oQuery("ShippingMethodID")
				ShippingDiscount = oQuery("PromoCodeShippingDiscount")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Promo Code"
		
			CommonValidation()
		
			If GetValueFromTable(oConn, "PromoCodeID", "utb_PromoCodes", "WHERE PromoCodeName = '" & Quote(Name) & "'") <> "" Then
				AddError("Promo Code with code <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " INSERT INTO utb_PromoCodes (PromoCodeName, PromoCodeDescription, PromoCodeStartDate, PromoCodeFinishDate, PromoCodeMinPrice, PromoCodeMaxPrice, PromoCodeOrderIsPercent, PromoCodeOrderDiscount, ShippingMethodID, PromoCodeShippingDiscount) " & _
						 " VALUES ( " & _
						 "   '" & Quote(UCase(Name)) & "' " & _
						 " , " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") & " " & _
						 " , '" & Quote(StartDate) & "' " & _
						 " , '" & Quote(FinishDate) & "' " & _
						 " , '" & Quote(DecimalPatch(MinPrice)) & "' " & _
						 " , '" & Quote(DecimalPatch(MaxPrice)) & "' " & _
						 " , '" & Quote(OrderIsPercent) & "' " & _
						 " , '" & Quote(DecimalPatch(OrderDiscount)) & "' " & _
						 " , " & IIF(ShippingMethodID <> "", "'" & Quote(ShippingMethodID) & "'", "NULL") & " " & _
						 " , '" & Quote(ShippingDiscount) & "' " & _
						 " ) "
				oConn.Execute(sQuery)
		
				iPromoCodeID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Promo Code has been inserted.")
					Redirect("PromoCodeForm.asp?Action=Edit&ID=" & iPromoCodeID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Update"
			sTitle = "Edit Promo Code Ref # " & iID
		
			CommonValidation()

			If GetValueFromTable(oConn, "PromoCodeID", "utb_PromoCodes", "WHERE PromoCodeName = '" & Quote(Name) & "' AND PromoCodeID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Promo Code with code <strong>" & Name & "</strong> already exist in database.")
			End If
			
			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " UPDATE utb_PromoCodes " & _
						 "	SET PromoCodeName = '" & Quote(UCase(Name)) & "' " & _
						 "	  , PromoCodeDescription = " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") & " " & _
						 "	  , PromoCodeStartDate = '" & Quote(StartDate) & "' " & _
						 "	  , PromoCodeFinishDate = '" & Quote(FinishDate) & "' " & _
						 "	  , PromoCodeMinPrice = '" & Quote(DecimalPatch(MinPrice)) & "' " & _
						 "	  , PromoCodeMaxPrice = '" & Quote(DecimalPatch(MaxPrice)) & "' " & _
						 "	  , PromoCodeOrderIsPercent = '" & Quote(OrderIsPercent) & "' " & _
						 "	  , PromoCodeOrderDiscount = '" & Quote(DecimalPatch(OrderDiscount)) & "' " & _
						 "	  , ShippingMethodID = " & IIF(ShippingMethodID <> "", "'" & Quote(ShippingMethodID) & "'", "NULL") & " " & _
						 "	  , PromoCodeShippingDiscount = '" & Quote(ShippingDiscount) & "' " & _
						 "  WHERE PromoCodeID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)
		
				iPromoCodeID = iID
		
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Promo Code has been updated.")
					Redirect("PromoCodeForm.asp?Action=Edit&ID=" & iPromoCodeID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_PromoCodes " & _
					 "  WHERE PromoCodeID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Promo Code has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
	<script type="text/javascript">
	//<![CDATA[
	$(document).ready(function(){
		$('#StartDate,#FinishDate').datepicker({ dateFormat: 'm/d/yy' });
	});
	//]]>
	</script>
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Promo Codes</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<% If iID > 0 Then %>
			<a class="head-link-right" href="PromoCodeAssignProductList.asp?PromoCodeID=<%= iID %>">Assign Products (<%= GetValueFromTable(oConn, "COUNT(*)", "utb_PromoCodeProducts", "WHERE PromoCodeID = '" & Quote(iID) & "'") %>)</a>
	<% End If %>
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="PromoCodeForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Code</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:100px;" maxlength="8" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Description</td>
				<td><input type="text" class="form-field" name="Description" value="<%= Description %>" style="width:500px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Start Date</td>
				<td><input type="text" class="form-field" id="StartDate" name="StartDate" value="<%= StartDate %>" style="width:100px;" maxlength="10" readonly="readonly" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Finish Date</td>
				<td><input type="text" class="form-field" id="FinishDate" name="FinishDate" value="<%= FinishDate %>" style="width:100px;" maxlength="10" readonly="readonly" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Min Price</td>
				<td><input type="text" class="form-field" name="MinPrice" value="<%= MinPrice %>" style="width:60px;" maxlength="15" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Max Price</td>
				<td><input type="text" class="form-field" name="MaxPrice" value="<%= MaxPrice %>" style="width:60px;" maxlength="15" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Type</td>
				<td>
					<select class="selector" name="OrderIsPercent" style="width:80px;">
						<option value="0" <%= IIF(OrderIsPercent = "0", "selected='selected'", "") %>>Dollar</option>
						<option value="1" <%= IIF(OrderIsPercent = "1", "selected='selected'", "") %>>Percent</option>
					</select>
				</td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Discount</td>
				<td><input type="text" class="form-field" name="OrderDiscount" value="<%= OrderDiscount %>" style="width:60px;" maxlength="15" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Shipping Method</td>
				<td>
					<select class="selector" name="ShippingMethodID" style="width: auto">
						<option value="">Select One</option>
					<%
						Set oQuery = oConn.Execute(" SELECT * FROM utb_ShippingMethods ORDER BY ShippingMethodID ")
						While Not oQuery.Eof 
					%>
						<option value="<%= oQuery("ShippingMethodID") %>" <%= IIF(CStr(oQuery("ShippingMethodID")) = CStr(IIF(IsNull(ShippingMethodID), "", ShippingMethodID)), "selected='selected'", "") %>><%= oQuery("ShippingMethodName") %></option>
					<%
							oQuery.MoveNext
						Wend
						oQuery.Close
						Set oQuery = Nothing
					%>
					</select>
				</td>
			</tr>
			<tr>
				<td style="text-align:right;">Shipping Discount</td>
				<td><input type="text" class="form-field" name="ShippingDiscount" value="<%= ShippingDiscount %>" style="width:60px;" maxlength="10" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Description = Trim(Request("Description"))
		StartDate = Trim(Request("StartDate"))
		FinishDate = Trim(Request("FinishDate"))
		MinPrice = Trim(Request("MinPrice"))
		MaxPrice = Trim(Request("MaxPrice"))
		OrderIsPercent = Trim(Request("OrderIsPercent"))
		OrderDiscount = Trim(Request("OrderDiscount"))
		ShippingMethodID = Trim(Request("ShippingMethodID"))
		ShippingDiscount = Trim(Request("ShippingDiscount"))

		If Name = "" Then
			AddError("Field <strong>Code</strong> is required.")
		Else
			If Not ValidatePromoCode(Name) Then
				AddError("Field <strong>Code</strong> is invalid.")
			End If
		End If
		If StartDate = "" Then
			AddError("Field <strong>Start Date</strong> is required.")
		Else
			If Not ValidateDate(StartDate) Then
				AddError("Field <strong>Start Date</strong> is invalid.")
			End If
		End If
		If FinishDate = "" Then
			AddError("Field <strong>Finish Date</strong> is required.")
		Else
			If Not ValidateDate(FinishDate) Then
				AddError("Field <strong>Finish Date</strong> is invalid.")
			End If
		End If
		If StartDate <> "" And FinishDate <> "" Then
			If ValidateDate(StartDate) And ValidateDate(FinishDate) Then
				If DateValue(StartDate) > DateValue(FinishDate) Then
					AddError("<strong>Start Date</strong> can not be greater than the <strong>Finish Date</strong>.")
				End If
			End If
		End If
		If MinPrice = "" Then
			AddError("Field <strong>Min Price</strong> is required.")
		Else
			If Not ValidateDecimal(MinPrice) Then
				AddError("Field <strong>Min Price</strong> is invalid.")
			End If
		End If
		If MaxPrice = "" Then
			AddError("Field <strong>Max Price</strong> is required.")
		Else
			If Not ValidateDecimal(MaxPrice) Then
				AddError("Field <strong>Max Price</strong> is invalid.")
			End If
		End If
		If MinPrice <> "" And MaxPrice <> "" Then
			If ValidateDecimal(MinPrice) And ValidateDecimal(MaxPrice) Then
				If CLng(MinPrice) > CLng(MaxPrice) Then
					AddError("<strong>Min Price</strong> can not be greater than the <strong>Max Price</strong>.")
				End If
			End If
		End If
		If OrderIsPercent = "" Then
			AddError("Field <strong>Type</strong> is required.")
		End If
		If OrderDiscount = "" Then
			AddError("Field <strong>Discount</strong> is required.")
		Else
			If Not ValidateDecimal(OrderDiscount) Then
				AddError("Field <strong>Discount</strong> is invalid.")
			End If
		End If
		If ShippingMethodID <> "" Then
			If ShippingDiscount = "" Then
				AddError("Field <strong>Shipping Discount</strong> is required.")
			Else
				If Not ValidateInteger(ShippingDiscount) Then
					AddError("Field <strong>Shipping Discount</strong> is invalid.")
				Else
					If (ShippingDiscount < 1 Or ShippingDiscount > 100) Then
						AddError("Field <strong>Shipping Discount</strong> must be between 1 and 100.")
					End If
				End If
			End If
		End If
	End Sub

	Sub SetBackURL()
		Session("PromoCodeFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>