<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("PromoList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Text, Url, IsActive, SortOrder
	Dim iPromoID

	Select Case sAction
		Case "New"
			sTitle = "Add Promo"
			sAction = "Insert"

			SortOrder = "0"
			IsActive = "0"

		Case "Edit"
			sTitle = "Edit Promo Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Promos WHERE PromoID = " & iID)
			If Not oQuery.Eof Then
				Text		= HTMLEncode(oQuery("PromoText"))
				Url			= HTMLEncode(oQuery("PromoUrl"))
				IsActive	= oQuery("PromoIsActive")
				SortOrder	= oQuery("PromoSortOrder")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Promo"

			CommonValidation()
			If GetValueFromTable(oConn, "PromoID", "utb_Promos", "WHERE PromoText = '" & Quote(Text) & "'") <> "" Then
				AddError("Promo <strong>" & Text & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Promos(" &_
						 "	PromoText" &_
						 ", PromoUrl" &_
						 ", PromoIsActive" &_
						 ", PromoSortOrder" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(Text) & "' " & _
						 ",  " & IIF(Url <> "", "'" & Quote(Url) & "'", "NULL") &_
						 ",  " & IsActive &_
						 ",  " & SortOrder &_
						 ") "
				oConn.Execute(sQuery)

				iPromoID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Promo has been inserted.")
					Redirect("PromoForm.asp?Action=Edit&ID=" & iPromoID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Promo Ref # " & iID

			CommonValidation()
			If GetValueFromTable(oConn, "PromoID", "utb_Promos", "WHERE PromoText = '" & Quote(Text) & "' AND PromoID <> " & iID) <> "" Then
				AddError("Promo <strong>" & Text & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " UPDATE utb_Promos" &_
						 "	  SET PromoText = '" & Quote(Text) & "'" &_
						 "		, PromoUrl = " & IIF(Url <> "", "'" & Quote(Url) & "'", "NULL") &_
						 "		, PromoIsActive = " & IsActive &_
						 "		, PromoSortOrder = " & SortOrder &_
						 "	WHERE PromoID = " & iID
				oConn.Execute(sQuery)

				iPromoID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Promo has been updated.")
					Redirect("PromoForm.asp?Action=Edit&ID=" & iPromoID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = "DELETE FROM utb_Promos WHERE PromoID = " & iID
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Promo has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select

%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Promos</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head"><h2><%= sTitle %></h2></div>
		<div class="box">
			<form action="PromoForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> Text</td>
						<td><input type="text" class="form-field" name="Text" value="<%= Text %>" style="width: 500px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Url</td>
						<td><input type="text" class="form-field" name="Url" value="<%= Url %>" style="width: 500px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Sort Order</td>
						<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width: 60px" maxlength="10"/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsActive">Active</label></td>
						<td>
							<input type="checkbox" name="IsActive" id="IsActive" value="1"<%= IIF(IsActive = "1", " checked='checked'", "") %>/>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float: left"><input type="submit" class="form-btn" value="Save"/></div>
							<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Text = Trim(Request("Text"))
		Url = Trim(Request("Url"))
		IsActive = IIF(Trim(Request("IsActive")) = "1", "1", "0")
		SortOrder = Trim(Request("SortOrder"))

		If Text = "" Then
			AddError("Field <strong>Text</strong> is required.")
		End If
		If Not ValidateInteger(SortOrder) Then
			AddError("Field <strong>SortOrder</strong> is invalid.")
		End If
	End Sub

	Sub SetBackURL()
		Session("PromoFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>