<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim SearchStartDate : SearchStartDate = Request("SearchStartDate")
	Dim SearchFinishDate : SearchFinishDate = Request("SearchFinishDate")
	Dim SearchReferral : SearchReferral = Trim(Request("SearchReferral"))

	Dim isShowReport : isShowReport = False
	If Request("submit") <> "" Then
		If SearchStartDate = "" And SearchFinishDate = "" Then
			AddError("<strong>Date From</strong> or <strong>Date To</strong> is required.")
		End If
		If Not IsError() Then
			isShowReport = True
		End If
	End If

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Referral Tracking</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		If isShowReport Then
			Dim sWhere : sWhere = ""
			Dim sDelimiter : sDelimiter = ""

			If SearchReferral <> "" Then
				sWhere = sWhere & sDelimiter & " ReferralTrackingRef = '" & SearchReferral & "' "
				sDelimiter = " AND "
			End If

			If SearchStartDate <> "" Or SearchFinishDate <> "" Then
				If SearchStartDate <> "" Then
					sWhere = sWhere & sDelimiter & " ReferralTrackingDate >= '" & SearchStartDate & " 00:00:00' "
					sDelimiter = " AND "
				End If
				If SearchFinishDate <> "" Then
					sWhere = sWhere & sDelimiter & " ReferralTrackingDate <= '" & SearchFinishDate & " 23:59:59' "
					sDelimiter = " AND "
				End If
			End If

			Dim sOrder, sArrow, sOrderBy
			sOrder = "3"
			sArrow = "2"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

			sQuery = "SELECT ReferralTrackingRef" &_
					 "	   , ReferralTrackingDate" &_
					 "	   , ReferralTrackingCount" &_
					 "  FROM utb_ReferralTracking" &_
					 IIF(sWhere <> "", " WHERE " & sWhere, "") &_
					 sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		End If
		%>
		<div class="box-head">
			<div>
				<% If isShowReport Then %>
				<div style="float: right; padding-top: 7px">
					<!--#include file="inc/PagerBackend.asp"-->
				</div>
				<% End If %>
				<form action="" method="get">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchStartDate">Date From:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchStartDate" name="SearchStartDate" value="<%= SearchStartDate %>" style="width: 65px" maxlength="10" readonly="readonly" />
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchFinishDate">Date To:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchFinishDate" name="SearchFinishDate" value="<%= SearchFinishDate %>" style="width: 65px" maxlength="10" readonly="readonly" />
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchReferral">Referral:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchReferral" name="SearchReferral" value="<%= SearchReferral %>" style="width: 300px" />
							</td>
							<td><input type="submit" class="inline-btn" name="submit" value="Search"/></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('ReferralTracking.asp')"/></td>
						</tr>
					</table>
				</form>
				<div style="clear: both"></div>
			</div>
		</div>

		<% If isShowReport Then %>
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
				<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
				<tr class="head-line">
					<td style="text-align: left"><%= GetURLForOrder("Referral", "1", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 70px"><%= GetURLForOrder("Date", "2", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 70px"><%= GetURLForOrder("Count", "3", sOrderQuery, sOrder, sArrow) %></td>
				</tr>
				<%
				Dim iCount : iCount = 0
				While Not oQuery.Eof
					iCount = iCount + 1
					%>
					<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
						<td style="text-align: left"><%= oQuery("ReferralTrackingRef") %></a></td>
						<td><%= oQuery("ReferralTrackingDate") %></td>
						<td style="text-align: right"><%= FormatNumber(oQuery("ReferralTrackingCount"), 0) %>&nbsp;</td>
					</tr>
					<%
					oQuery.MoveNext
				Wend
				%>
			</table>
			<% If iRecordCount = 0 Then %>
				<!--#include file="inc/NoRecords.asp"-->
			<%
			End If
			oQuery.Close
			Set oQuery = Nothing
		End If
		%>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			$('#SearchStartDate,#SearchFinishDate').datepicker({dateFormat: 'm/d/yy', maxDate: '+0', changeMonth: true, changeYear: true});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "ReferralTrackingCount"

		Select Case sIndex
			Case "1" sColumn = "ReferralTrackingRef"
			Case "2" sColumn = "ReferralTrackingDate"
			Case "3" sColumn = "ReferralTrackingCount"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>