<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim SearchOrderStatusID : SearchOrderStatusID = Request("SearchOrderStatusID")
	Dim SearchStartDate : SearchStartDate = Request("SearchStartDate")
	Dim SearchFinishDate : SearchFinishDate = Request("SearchFinishDate")


	Dim isShowReport : isShowReport = False
	If Request("submit") <> "" Then
		If SearchOrderStatusID = "" Then
			AddError("<strong>Order Status</strong> is required.")
		End If
		If Not IsError() Then
			isShowReport = True
		End If
	End If

	Dim sStatusesHtml, sStatusSel
	Set oQuery = oConn.Execute("SELECT * FROM utb_OrderStatuses WHERE OrderStatusIsActive = 1 ORDER BY OrderStatusName")
	While Not oQuery.Eof
		sStatusSel = IIF(CStr(SearchOrderStatusID) = CStr(oQuery("OrderStatusID")), " selected='selected'", "")
		sStatusesHtml = sStatusesHtml &_
			"<option value='" & oQuery("OrderStatusID") & "'" & sStatusSel & ">" & oQuery("OrderStatusName") & "</option>"

		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Allocation Report</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		If isShowReport Then
			Dim sWhere : sWhere = ""
			Dim sDelimiter : sDelimiter = ""

			If SearchOrderStatusID <> "" Then
				If SearchOrderStatusID = 0 Then
					sWhere = sWhere & sDelimiter & " os.OrderStatusIsCommitted = 1 "
				Else
					sWhere = sWhere & sDelimiter & " o.OrderStatusID = '" & SearchOrderStatusID & "' "
				End If
				sDelimiter = " AND "
			End If

			If SearchStartDate <> "" Or SearchFinishDate <> "" Then
				If SearchStartDate <> "" Then
					sWhere = sWhere & sDelimiter & " o.OrderCreateDate >= '" & SearchStartDate & " 00:00:00' "
					sDelimiter = " AND "
				End If
				If SearchFinishDate <> "" Then
					sWhere = sWhere & sDelimiter & " o.OrderCreateDate <= '" & SearchFinishDate & " 23:59:59' "
					sDelimiter = " AND "
				End If
			End If

			Dim sOrder, sArrow, sOrderBy
			sOrder = "1"
			sArrow = "2"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

			sQuery = "SELECT od.ProductSKU AS Sku" &_
					 "	   , SUM(od.OrderDetailProductQuantity) AS Qty" &_
					 "  FROM utb_Orders o" &_
					 "		 INNER JOIN utb_OrderDetails od ON od.OrderID = o.OrderID" &_
					 "		 INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
					 IIF(sWhere <> "", " WHERE " & sWhere, "") &_
					 " GROUP BY od.ProductSKU " &_
					 sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		End If
		%>
		<div class="box-head">
			<div>
				<% If isShowReport Then %>
				<div style="float: right; padding-top: 7px">
					<!--#include file="inc/PagerBackend.asp"-->
				</div>
				<% End If %>
				<form action="" method="get">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchField">Order Status/Committed:</label></div>
								</div>
								<select class="selector" id="SearchOrderStatusID" name="SearchOrderStatusID" style="width: 150px">
									<option value="">Select One</option>
									<option value="0"<%= IIF(CStr(SearchOrderStatusID) = "0", " selected=""selected""", "") %>>Committed</option>
									<%= sStatusesHtml %>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchString">Date From:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchStartDate" name="SearchStartDate" value="<%= SearchStartDate %>" style="width:65px;" maxlength="10" readonly="readonly" />
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchString">Date To:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchFinishDate" name="SearchFinishDate" value="<%= SearchFinishDate %>" style="width:65px;" maxlength="10" readonly="readonly" />
							</td>
							<td><input type="submit" class="inline-btn" name="submit" value="Search"/></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('ReportAllocation.asp')"/></td>
						</tr>
					</table>
				</form>
				<div style="clear: both"></div>
			</div>
		</div>

		<% If isShowReport Then %>
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
				<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
				<tr class="head-line">
					<td width="200"><%= GetURLForOrder("SKU", "1", sOrderQuery, sOrder, sArrow) %></td>
					<td width="50"><%= GetURLForOrder("Qty", "2", sOrderQuery, sOrder, sArrow) %></td>
					<td>&nbsp;</td>
				</tr>
				<%
					Dim iCount : iCount = 0
					Dim sListLink
					While Not oQuery.Eof
						iCount = iCount + 1
						sListLink = "OrderList.asp?SearchField=8" &_
							"&amp;SearchString=" & oQuery("Sku") &_
							"&amp;SearchStartDate=" & SearchStartDate &_
							"&amp;SearchFinishDate=" & SearchFinishDate &_
							"&amp;SearchOrderStatusID=" & SearchOrderStatusID
						%>
						<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
							<td style="text-align: left"><a href="<%= sListLink %>"><%= oQuery("Sku") %></a></td>
							<td style="text-align: right"><%= oQuery("Qty") %>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
						<%
						oQuery.MoveNext
					Wend
				%>
			</table>
			<% If iRecordCount = 0 Then %>
				<!--#include file="inc/NoRecords.asp"-->
			<%
			End If
			oQuery.Close
			Set oQuery = Nothing
		End If
		%>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			$('#SearchStartDate,#SearchFinishDate').datepicker({dateFormat: 'm/d/yy'});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "od.ProductSKU"

		Select Case sIndex
			Case "1" sColumn = "od.ProductSKU"
			Case "2" sColumn = "SUM(od.OrderDetailProductQuantity)"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>