<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery, oQuery2
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
	Dim sDefaultDate : sDefaultDate = PrependChar(Month(Date), 2, "0") & "/" & PrependChar(Day(Date), 2, "0") & "/" & Year(Date)
	Dim SearchDateFrom : SearchDateFrom = IIF(Request("SearchDateFrom") <> "", Request("SearchDateFrom"), sDefaultDate)
	Dim SearchDateTo : SearchDateTo = IIF(Request("SearchDateTo") <> "", Request("SearchDateTo"), sDefaultDate)
	Dim SearchStatus : SearchStatus = Request("SearchStatus")
	Dim SearchType : SearchType = Request("SearchType")
	Dim SearchUserID : SearchUserID = IIF(ValidateInteger(Request("SearchUserID")), Request("SearchUserID"), 0)
	Dim isShowReport : isShowReport = (Request("submit") <> "")
	If SearchStatus <> "Approved" And SearchStatus <> "Declined" And SearchStatus <> "Error" Then
		SearchStatus = ""
	End If
	If SearchType <> "Summary" And SearchType <> "Detail" Then
		SearchType = "Summary"
	End If
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Credit Cards Daily Summary Charges Report</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		If isShowReport Then
			Dim fPaymentTotal : fPaymentTotal = 0
			Dim fOrderTotal : fOrderTotal = 0
			Dim fOrderCost : fOrderCost = 0
			Dim sOrder, sArrow, sOrderBy
			sOrder = IIF(SearchType = "Summary", "2", "1")
			sArrow = IIF(SearchType = "Summary", "1", "2")
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")
			If SearchType = "Summary" Then
				sQuery = " SELECT pt.PaymentTypeName" &_
						 "		, SUM(p.PaymentTotal) AS TotalPayment" &_
						 "		, SUM(o.OrderTotalAmount" &_
						 "			+ o.OrderDeliveryPrice" &_
						 "			+ o.OrderTaxAmount" &_
						 "			+ o.OrderHandlingInsurance" &_
						 "			+ o.OrderPromoAmount) AS TotalOrder" &_
						 "		, SUM(o.OrderCostAmount" &_
						 "			+ o.OrderDeliveryCost) AS TotalCost" &_
						 "		, p.PaymentStatusText" &_
						 "	 FROM utb_Orders o" &_
						 "		  INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
						 "		  INNER JOIN utb_Payments p ON p.OrderID = o.OrderID" &_
						 "		  INNER JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = p.PaymentTypeID" &_
						 "		   LEFT JOIN utb_Users u ON u.UserID = o.SalesmanUserID" &_
						 "	WHERE p.CreateDate BETWEEN '" & SearchDateFrom & " 00:00:00'" &_
						 "						   AND '" & SearchDateTo & " 23:59:59'" &_
						 "	" & IIF(SearchStatus <> "", "AND p.PaymentStatusText = '" & SearchStatus & "'", "") &_
						 "	" & IIF(SearchUserID > 0, "AND o.SalesmanUserID = '" & SearchUserID & "'", "") &_
						 "	GROUP BY pt.PaymentTypeName" &_
						 "		, p.PaymentStatusText"
			Else
				sQuery = " SELECT o.OrderID" &_
						 "		, pt.PaymentTypeName" &_
						 "		, p.PaymentCard4Digits" &_
						 "		, p.PaymentStatusText" &_
						 "		, p.PaymentTotal AS TotalPayment" &_
						 "		, (   o.OrderTotalAmount" &_
						 "			+ o.OrderDeliveryPrice" &_
						 "			+ o.OrderTaxAmount" &_
						 "			+ o.OrderHandlingInsurance" &_
						 "			+ o.OrderPromoAmount) AS TotalOrder" &_
						 "		, (   o.OrderCostAmount" &_
						 "			+ o.OrderDeliveryCost) AS TotalCost" &_
						 "		, u.UserNickName" &_
						 "		, p.CreateUser" &_
						 "		, 	CONVERT(VARCHAR(10), p.CreateDate, 101) + '&nbsp;'" &_
						 "		  + RIGHT(CONVERT(VARCHAR(20), p.CreateDate, 109), 8) + '&nbsp;'" &_
						 "		  + RIGHT(CONVERT(VARCHAR(26), p.CreateDate, 100), 2) AS _CreateDate" &_
						 "		, os.OrderStatusName" &_
						 "		, os.OrderStatusColor" &_
						 "	 FROM utb_Orders o" &_
						 "		  INNER JOIN utb_OrderStatuses os ON os.OrderStatusID = o.OrderStatusID" &_
						 "		  INNER JOIN utb_Payments p ON p.OrderID = o.OrderID" &_
						 "		  INNER JOIN utb_PaymentTypes pt ON pt.PaymentTypeID = p.PaymentTypeID" &_
						 "		   LEFT JOIN utb_Users u ON u.UserID = o.SalesmanUserID" &_
						 "	WHERE p.CreateDate BETWEEN '" & SearchDateFrom & " 00:00:00'" &_
						 "						   AND '" & SearchDateTo & " 23:59:59'" &_
						 "	" & IIF(SearchStatus <> "", "AND p.PaymentStatusText = '" & SearchStatus & "'", "") &_
						 "	" & IIF(SearchUserID > 0, "AND o.SalesmanUserID = '" & SearchUserID & "'", "")
			End If
			Set oQuery = oConn.Execute(sQuery & sOrderBy)
		End If
		%>
		<div class="box-head">
			<div>
				<form action="" method="get">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchDateFrom">Date From:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchDateFrom" name="SearchDateFrom" value="<%= SearchDateFrom %>" style="width: 65px" maxlength="10" readonly="readonly"/>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchDateTo">Date To:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchDateTo" name="SearchDateTo" value="<%= SearchDateTo %>" style="width: 65px" maxlength="10" readonly="readonly"/>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchStatus">Payment Status:</label></div>
								</div>
								<select class="selector" id="SearchStatus" name="SearchStatus" style="width: 90px">
									<option value="">Select One</option>
									<option value="Approved"<%= IIF(CStr(SearchStatus) = "Approved", " selected=""selected""", "") %>>Approved</option>
									<option value="Declined"<%= IIF(CStr(SearchStatus) = "Declined", " selected=""selected""", "") %>>Declined</option>
									<option value="Error"<%= IIF(CStr(SearchStatus) = "Error", " selected=""selected""", "") %>>Error</option>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchType">Report Type:</label></div>
								</div>
								<select class="selector" id="SearchType" name="SearchType" style="width: 90px">
									<option value="Summary"<%= IIF(CStr(SearchType) = "Summary", " selected=""selected""", "") %>>Summary</option>
									<option value="Detail"<%= IIF(CStr(SearchType) = "Detail", " selected=""selected""", "") %>>Detail</option>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchType">Salesman:</label></div>
								</div>
								<select class="selector" id="SearchUserID" name="SearchUserID" style="width: auto">
									<option value="">Select One</option>
									<%
									Set oQuery2 = oConn.Execute("SELECT UserID, UserNickName FROM utb_Users WHERE UserIsActive = 1 ORDER BY 2")
									While Not oQuery2.Eof 
										%><option value="<%= oQuery2("UserID") %>"<%= IIF(CStr(oQuery2("UserID")) = CStr(SearchUserID), " selected='selected'", "") %>><%= oQuery2("UserNickName") %></option><%
									oQuery2.MoveNext
									Wend
									oQuery2.Close
									Set oQuery2 = Nothing
									%>
								</select>
							</td>
							<td><input type="submit" class="inline-btn" name="submit" value="Search"/></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('ReportCCDailySummaryCharges.asp')"/></td>
						</tr>
					</table>
				</form>
				<div style="clear: both"></div>
			</div>
		</div>
		<% If isShowReport Then %>
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
				<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
				<tr class="head-line">
					<% If SearchType <> "Summary" Then %>
					<td width="70">Order #</td>
					<td width="70">Order Status</td>
					<td width="100">Payment Type</td>
					<td width="80">CC Last 4 #</td>
					<td width="110">Payment Status</td>
					<td width="100">Total Payment</td>
					<td width="100">Total Order</td>
					<td width="100">Total Cost</td>
					<td width="100">Salesman</td>
					<td width="100">Charge User</td>
					<td width="130">Charge Date/Time</td>
					<% Else %>
					<td width="100"><%= GetURLForOrder("Payment Type", "2", sOrderQuery, sOrder, sArrow) %></td>
					<td width="110"><%= GetURLForOrder("Payment Status", "3", sOrderQuery, sOrder, sArrow) %></td>
					<td width="100"><%= GetURLForOrder("Total Payment", "4", sOrderQuery, sOrder, sArrow) %></td>
					<td width="100"><%= GetURLForOrder("Total Order", "5", sOrderQuery, sOrder, sArrow) %></td>
					<td width="100"><%= GetURLForOrder("Total Cost", "6", sOrderQuery, sOrder, sArrow) %></td>
					<td>&nbsp;</td>
					<% End If %>
				</tr>
				<%
				Dim iCount : iCount = 0
				Dim iCurrentID : iCurrentID = 0
				While Not oQuery.Eof
					iCount = iCount + 1
					%>
					<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>"<%= IIF(CLng(oQuery("TotalPayment")) <> CLng(oQuery("TotalOrder")), " style='background-color: #ffdfdf'", "") %>>
						<% If SearchType <> "Summary" Then %>
						<td><a href="OrderForm.asp?OrderID=<%= oQuery("OrderID") %>"><%= oQuery("OrderID") %></a></td>
						<td style="color: #<%= oQuery("OrderStatusColor") %>"><%= oQuery("OrderStatusName") %></td>
						<td><%= oQuery("PaymentTypeName") %></td>
						<td><%= oQuery("PaymentCard4Digits") %></td>
						<td><%= oQuery("PaymentStatusText") %></td>
						<td style="text-align: right"><%= CurrencyFormat(oQuery("TotalPayment"), 2) %></td>
						<td style="text-align: right"><%= IIF(iCurrentID <> oQuery("OrderID"), CurrencyFormat(oQuery("TotalOrder"), 2), "&nbsp;") %></td>
						<td style="text-align: right"><%= IIF(iCurrentID <> oQuery("OrderID"), CurrencyFormat(oQuery("TotalCost"), 2), "&nbsp;") %></td>
						<td style="text-align: left"><%= oQuery("UserNickName") %></td>
						<td style="text-align: left"><%= oQuery("CreateUser") %></td>
						<td><%= oQuery("_CreateDate") %></td>
						<% Else %>
						<td><%= oQuery("PaymentTypeName") %></td>
						<td><%= oQuery("PaymentStatusText") %></td>
						<td style="text-align: right"><%= CurrencyFormat(oQuery("TotalPayment"), 2) %></td>
						<td style="text-align: right"><%= CurrencyFormat(oQuery("TotalOrder"), 2) %></td>
						<td style="text-align: right"><%= CurrencyFormat(oQuery("TotalCost"), 2) %></td>
						<td>&nbsp;</td>
						<% End If %>
					</tr>
					<%
					fPaymentTotal = fPaymentTotal + CCur(oQuery("TotalPayment"))
					If SearchType <> "Summary" Then
						If iCurrentID <> oQuery("OrderID") Then
							fOrderTotal = fOrderTotal + CCur(oQuery("TotalOrder"))
							fOrderCost = fOrderCost + CCur(oQuery("TotalCost"))
						End If
						iCurrentID = oQuery("OrderID")
					Else
						fOrderTotal = fOrderTotal + CCur(oQuery("TotalOrder"))
						fOrderCost = fOrderCost + CCur(oQuery("TotalCost"))
					End If
					oQuery.MoveNext
				Wend
				If iCount > 0 Then
					%>
					<tr class="head-line">
						<td colspan="<%= IIF(SearchType = "Summary", "2", "5") %>" style="text-align: right">Grand Total:&nbsp;</td>
						<td style="text-align: right"><%= CurrencyFormat(fPaymentTotal, 2) %></td>
						<td style="text-align: right"><%= CurrencyFormat(fOrderTotal, 2) %></td>
						<td style="text-align: right"><%= CurrencyFormat(fOrderCost, 2) %></td>
						<td colspan="<%= IIF(SearchType = "Summary", "2", "3") %>">&nbsp;</td>
					</tr>
				<% End If %>
			</table>
			<% If iCount = 0 Then %>
				<!--#include file="inc/NoRecords.asp"-->
			<%
			End If
			oQuery.Close
			Set oQuery = Nothing
		End If
		%>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			$('#SearchDateFrom,#SearchDateTo').datepicker({dateFormat: 'mm/dd/yy'});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "o.OrderID"
		Select Case sIndex
			Case "1" sColumn = "o.OrderID"
			Case "2" sColumn = "pt.PaymentTypeName"
			Case "3" sColumn = "p.PaymentStatusText"
			Case "4" sColumn = IIF(SearchType = "Summary", "2", "5")
			Case "5" sColumn = IIF(SearchType = "Summary", "3", "6")
			Case "6" sColumn = IIF(SearchType = "Summary", "4", "7")
		End Select
		GetColumnByIndex = sColumn
	End Function
%>