﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim SearchStatus : SearchStatus = Request("SearchStatus")
	Dim SearchCategoryID : SearchCategoryID = Request("SearchCategoryID")
	Dim SearchReportType : SearchReportType = Request("SearchReportType")

	Dim isShowReport : isShowReport = False
	If Request("submit") <> "" Then
		If SearchStatus = "" Then
			AddError("<strong>Product Status</strong> is required.")
		End If
		If SearchReportType = "" Or Not ValidateInteger(SearchReportType) Then
			AddError("<strong>Report Type</strong> is required.")
		End If
		If Not IsError() Then
			isShowReport = True
		End If
	End If

	Dim sCatsHtml, sCatSel
	Set oQuery = oConn.Execute("EXEC usp_CategoriesGet")
	While Not oQuery.Eof
		sCatSel = IIF(CStr(SearchCategoryID) = CStr(oQuery("CategoryID")), " selected='selected'", "")
		sCatsHtml = sCatsHtml &_
			"<option value='" & oQuery("CategoryID") & "'" & sCatSel & ">" & TreeLevelOffset(oQuery("Indent"), 6, "&nbsp;") & oQuery("CategoryName") & " (" & oQuery("CategoryID") & ") </option>"

		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Missing Compatible Products Report</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<div style="margin-bottom: 20px">
				<form action="" method="get">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchStatus">Product Status:</label></div>
								</div>
								<select class="selector" id="SearchStatus" name="SearchStatus" style="width: 110px">
									<option value="">Select One</option>
									<option value="0"<%= IIF(SearchStatus = "0", " selected='selected'", "") %>>Not Active Only</option>
									<option value="1,2,3,4"<%= IIF(SearchStatus = "1,2,3,4", " selected='selected'", "") %>>Active Only</option>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchCategoryID">Category:</label></div>
								</div>
								<select class="selector" name="SearchCategoryID" id="SearchCategoryID" style="width: auto">
									<option value="">All Categories</option>
									<%= sCatsHtml %>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchString">Report Type:</label></div>
								</div>
								<select class="selector" id="SearchReportType" name="SearchReportType" style="width: 145px">
									<option value="">Select One</option>
									<option value="1"<%= IIF(SearchReportType = "1", " selected='selected'", "") %>>Missing Accessories</option>
									<option value="2"<%= IIF(SearchReportType = "2", " selected='selected'", "") %>>Missing Warranty</option>
									<option value="3"<%= IIF(SearchReportType = "3", " selected='selected'", "") %>>Missing Kits</option>
									<option value="4"<%= IIF(SearchReportType = "4", " selected='selected'", "") %>>Missing Free Gift</option>
									<option value="5"<%= IIF(SearchReportType = "5", " selected='selected'", "") %>>Missing Images</option>
								</select>
							</td>
							<td><input type="submit" class="inline-btn" name="submit" value="Search"/></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('ReportMissingCompatible.asp')"/></td>
						</tr>
					</table>
				</form>
			</div>
			<%
			If isShowReport Then
				Dim sOrder, sArrow, sOrderBy
				sOrder = "1"
				sArrow = "1"
				If Request("Order") <> "" And Request("Arrow") <> "" Then
					sOrder = Request("Order")
					sArrow = Request("Arrow")
				End If
				sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

				Dim sWhere
				If SearchStatus = "0" Then
					sWhere = " WHERE p.ProductStatusID = 0"
				Else
					sWhere = " WHERE p.ProductStatusID IN(1,2,3,4)"
				End If

				If ValidateInteger(SearchCategoryID) Then
					sWhere = sWhere & " AND p.ProductID IN(SELECT ProductID FROM utb_ProductCategories WHERE CategoryID = " & Quote(SearchCategoryID) & ")"
				End If

				Select Case CInt(SearchReportType)
					'Missing Accessories
					Case 1
						sWhere = sWhere & " AND (p.ProductIsKit = 0 AND (SELECT COUNT(*) FROM utb_Compatibilities WHERE CompatibilityParentID = p.ProductID) = 0)"

					'Missing Warranty
					Case 2
						sWhere = sWhere & " AND (p.WarrantyID IS NULL OR p.WarrantyID = 0)"

					'Missing Kits
					Case 3
						sWhere = sWhere & " AND (p.ProductIsKit = 1 AND (SELECT COUNT(*) FROM utb_Kits WHERE ParentID = p.ProductID) = 0)"

					'Missing Free Gift
					Case 4
						sWhere = sWhere & " AND (SELECT COUNT(*) FROM utb_Gifts WHERE ParentID = p.ProductID) = 0"

					'Missing Images
					Case 5
						sWhere = sWhere & " AND p.ProductImage IS NULL"
				End Select

				sQuery = "SELECT p.*" &_
						 "	   , pt.ProductTypeName" &_
						 "	   , ps.ProductStatusName" &_
						 "	   , (CASE WHEN ISNULL(p.ProductDescription, '') <> '' THEN 1 ELSE 0 END) AS _ProductDescription" &_
						 "	FROM utb_Products p" &_
						 "		 INNER JOIN utb_ProductStatuses ps ON ps.ProductStatusID = p.ProductStatusID" &_
						 "		 INNER JOIN utb_ProductTypes pt ON pt.ProductTypeID = p.ProductTypeID" &_
						 sWhere &_
						 sOrderBy

				Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount, iProductCount
				iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
				iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
				Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
				iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
				%>
				<div style="position: relative"><div style="position: absolute; top: -16px; right: 2px"><!--#include file="inc/PagerBackend.asp"--></div></div>
				<%
			End If
			%>
		</div>
		<%
		If isShowReport Then
			If iRecordCount > 0 Then
				Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow")
				%>
				<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
					<tr class="head-line">
						<td style="width: 120px"><%= GetURLForOrder("SKU", "1", sOrderQuery, sOrder, sArrow) %></td>
						<td><%= GetURLForOrder("Name", "2", sOrderQuery, sOrder, sArrow) %></td>
						<td style="width: 70px"><%= GetURLForOrder("Price", "3", sOrderQuery, sOrder, sArrow) %></td>
						<td style="width: 80px"><%= GetURLForOrder("Status", "4", sOrderQuery, sOrder, sArrow) %></td>
						<td style="width: 60px"><%= GetURLForOrder("Desc", "6", sOrderQuery, sOrder, sArrow) %></td>
						<td style="width: 130px">Best Sellers / New / On Sale / Other</td>
					</tr>
					<%
					While Not oQuery.Eof
						iProductCount = iProductCount + 1
						%>
						<tr class="<%= IIF(iProductCount Mod 2 = 0, "row-hl", "") %>">
							<td style="width: 120px"><%= oQuery("ProductSKU") %></td>
							<td style="text-align: left"><a href="ProductForm.asp?Action=Edit&amp;ID=<%= oQuery("ProductID") %>"><%= oQuery("ProductName") %></a></td>
							<td style="width: 70px"><%= CurrencyFormat(oQuery("ProductPrice"), 2) %></td>
							<td style="width: 80px"><%= oQuery("ProductStatusName") %></td>
							<td style="width: 60px"><%= IIF(oQuery("_ProductDescription") = 1, "Yes", "No") %></td>
							<td style="width: 130px"><%= oQuery("ProductIsBestSeller") %> / <%= oQuery("ProductIsNew") %> / <%= oQuery("ProductIsOnSale") %> / <%= oQuery("ProductIsOther") %></td>
						</tr>
						<%
						oQuery.MoveNext
					Wend
					%>
				</table>
				<%
			Else
				%>
				<div style="border-bottom: 1px solid #bcbcbc;"></div>
				<!--#include file="inc/NoRecords.asp"-->
				<%
			End If

			oQuery.Close
			Set oQuery = Nothing
		End If
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "p.ProductSKU"

		Select Case sIndex
			Case "1" sColumn = "p.ProductSKU"
			Case "2" sColumn = "p.ProductName"
			Case "3" sColumn = "p.ProductPrice"
			Case "4" sColumn = "ps.ProductStatusName"
			Case "5" sColumn = "p.ProductQuantity"
			Case "6" sColumn = "(CASE WHEN ISNULL(p.ProductDescription, '') <> '' THEN 1 ELSE 0 END)"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>