﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim SearchOrderStatusID : SearchOrderStatusID = Request("SearchOrderStatusID")
	Dim SearchStartDate : SearchStartDate = Request("SearchStartDate")
	Dim SearchFinishDate : SearchFinishDate = Request("SearchFinishDate")
	Dim SearchReferral : SearchReferral = Trim(Request("SearchReferral"))

	Dim isShowReport : isShowReport = False
	If Request("submit") <> "" Then
		If SearchOrderStatusID = "" And SearchOrderStatusID <> "" Then
			AddError("<strong>Order Status</strong> is required.")
		End If
		If SearchStartDate = "" And SearchFinishDate = "" Then
			AddError("<strong>Start Date</strong> or <strong>Finish Date</strong> is required.")
		End If
		If Not IsError() Then
			isShowReport = True
		End If
	End If

	Dim sStatusesHtml, sStatusSel
	Set oQuery = oConn.Execute("SELECT * FROM utb_OrderStatuses WHERE OrderStatusIsActive = 1 ORDER BY OrderStatusName")
	While Not oQuery.Eof
		sStatusSel = IIF(CStr(SearchOrderStatusID) = CStr(oQuery("OrderStatusID")), " selected='selected'", "")
		sStatusesHtml = sStatusesHtml &_
			"<option value='" & oQuery("OrderStatusID") & "'" & sStatusSel & ">" & oQuery("OrderStatusName") & "</option>"

		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Referral Report</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		If isShowReport Then
			Dim sWhere : sWhere = ""
			Dim sDelimiter : sDelimiter = ""

			If SearchOrderStatusID <> "" Then
				sWhere = sWhere & sDelimiter & " o.OrderStatusID = '" & SearchOrderStatusID & "' "
				sDelimiter = " AND "
			End If

			If SearchReferral <> "" Then
				sWhere = sWhere & sDelimiter & " o.OrderReferralCode = '" & SearchReferral & "' "
				sDelimiter = " AND "
			End If

			If SearchStartDate <> "" Or SearchFinishDate <> "" Then
				If SearchStartDate <> "" Then
					sWhere = sWhere & sDelimiter & " o.OrderCreateDate >= '" & SearchStartDate & " 00:00:00' "
					sDelimiter = " AND "
				End If
				If SearchFinishDate <> "" Then
					sWhere = sWhere & sDelimiter & " o.OrderCreateDate <= '" & SearchFinishDate & " 23:59:59' "
					sDelimiter = " AND "
				End If
			End If

			Dim sOrder, sArrow, sOrderBy
			sOrder = "1"
			sArrow = "2"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

			sQuery = " SELECT o.OrderID" &_
					 "		, CONVERT(VARCHAR(10), o.OrderCreateDate, 101) + '&nbsp;'" &_
					 "		+ CONVERT(VARCHAR(5), o.OrderCreateDate, 114) AS _OrderCreateDate" &_
					 "		, CONVERT(VARCHAR(10), o.OrderShippedDate, 101) + '&nbsp;'" &_
					 "		+ CONVERT(VARCHAR(5), o.OrderShippedDate, 114) AS _OrderShippedDate" &_
					 "		, (ISNULL(OrderTotalAmount, 0) + ISNULL(OrderDeliveryPrice, 0) + ISNULL(OrderPromoAmount, 0) + ISNULL(OrderHandlingInsurance, 0)) AS Total" &_
					 "		, (ISNULL(OrderCostAmount, 0) + ISNULL(OrderDeliveryCost, 0)) AS Cost" &_
					 "		, (   (ISNULL(OrderTotalAmount, 0) + ISNULL(OrderDeliveryPrice, 0) + ISNULL(OrderPromoAmount, 0) + ISNULL(OrderHandlingInsurance, 0))" &_
					 "			- (ISNULL(OrderCostAmount, 0) + ISNULL(OrderDeliveryCost, 0))" &_
					 "		) AS PNL" &_
					 "		, u.UserNickName AS OrderSalesman" &_
					 "  FROM utb_Orders o" &_
					 "		 LEFT JOIN utb_Users u ON u.UserID = o.SalesmanUserID" &_
					 IIF(sWhere <> "", " WHERE " & sWhere, "") &_
					 sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		End If
		%>
		<div class="box-head">
			<div>
				<% If isShowReport Then %>
				<div style="float: right; padding-top: 7px">
					<!--#include file="inc/PagerBackend.asp"-->
				</div>
				<% End If %>
				<form action="" method="get">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchField">Order Status:</label></div>
								</div>
								<select class="selector" id="SearchOrderStatusID" name="SearchOrderStatusID" style="width: 120px">
									<option value="">Select One</option>
									<%= sStatusesHtml %>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchStartDate">Date From:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchStartDate" name="SearchStartDate" value="<%= SearchStartDate %>" style="width: 65px" maxlength="10" readonly="readonly" />
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchFinishDate">Date To:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchFinishDate" name="SearchFinishDate" value="<%= SearchFinishDate %>" style="width: 65px" maxlength="10" readonly="readonly" />
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchReferral">Referral:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchReferral" name="SearchReferral" value="<%= SearchReferral %>" style="width: 147px" />
							</td>
							<td><input type="submit" class="inline-btn" name="submit" value="Search"/></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('ReportReferral.asp')"/></td>
						</tr>
					</table>
				</form>
				<div style="clear: both"></div>
			</div>
		</div>

		<%
		If isShowReport Then
			%>
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
				<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
				<tr class="head-line">
					<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 100px"><%= GetURLForOrder("Date", "2", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 100px"><%= GetURLForOrder("Shipped Date", "3", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 80px"><%= GetURLForOrder("Total", "4", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 80px"><%= GetURLForOrder("Cost", "5", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 80px"><%= GetURLForOrder("PNL", "6", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 150px"><%= GetURLForOrder("Salesman", "7", sOrderQuery, sOrder, sArrow) %></td>
					<td>&nbsp;</td>
				</tr>
				<%
					Dim iCount : iCount = 0
					Dim iTotal : iTotal = 0
					Dim iCost : iCost = 0
					Dim iPNL : iPNL = 0
					While Not oQuery.Eof
						iCount = iCount + 1
						%>
						<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
							<td style="text-align: right"><a href="OrderForm.asp?OrderID=<%= oQuery("OrderID") %>"><%= oQuery("OrderID") %></a></td>
							<td><%= oQuery("_OrderCreateDate") %></td>
							<td><%= oQuery("_OrderShippedDate") %></td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("Total"), 2) %>&nbsp;</td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("Cost"), 2) %>&nbsp;</td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("PNL"), 2) %>&nbsp;</td>
							<td style="text-align: left"><%= oQuery("OrderSalesman") %>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
						<%
						iTotal = iTotal + CCur(oQuery("Total"))
						iCost = iCost + CCur(oQuery("Cost"))
						iPNL = iPNL + CCur(oQuery("PNL"))
						oQuery.MoveNext
					Wend
					oQuery.Close
					Set oQuery = Nothing

					iCount = iCount + 1
					
					Dim sQuery2, oTotalQuery
					sQuery2 = "SELECT SUM( (ISNULL(OrderTotalAmount, 0) + ISNULL(OrderDeliveryPrice, 0) + ISNULL(OrderPromoAmount, 0) + ISNULL(OrderHandlingInsurance, 0)) ) AS Total" &_
							 "		, SUM( (ISNULL(OrderCostAmount, 0) + ISNULL(OrderDeliveryCost, 0)) ) AS Cost" &_
							 "		, SUM( (   (ISNULL(OrderTotalAmount, 0) + ISNULL(OrderDeliveryPrice, 0) + ISNULL(OrderPromoAmount, 0) + ISNULL(OrderHandlingInsurance, 0))" &_
							 "	   	   		 - (ISNULL(OrderCostAmount, 0) + ISNULL(OrderDeliveryCost, 0))" &_
							 "	   	 ) ) AS PNL" &_
							 "  FROM utb_Orders o" &_
							 IIF(sWhere <> "", " WHERE " & sWhere, "")
					Set oTotalQuery = oConn.Execute(sQuery2)
				%>
				<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
					<td style="text-align: right" colspan="3"><strong>Total:&nbsp;</strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(oTotalQuery("Total"), 2) %>&nbsp;</strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(oTotalQuery("Cost"), 2) %>&nbsp;</strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(oTotalQuery("PNL"), 2) %>&nbsp;</strong></td>
					<td colspan="2">&nbsp;</td>
				</tr>
				<%
					oTotalQuery.Close
					Set oTotalQuery = Nothing
				%>
			</table>
			<%
			If iRecordCount = 0 Then
				%><!--#include file="inc/NoRecords.asp"--><%
			End If
		End If
		%>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			$('#SearchStartDate,#SearchFinishDate').datepicker({dateFormat: 'm/d/yy'});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "od.ProductSKU"

		Select Case sIndex
			Case "1" sColumn = "o.OrderID"
			Case "2" sColumn = "o.OrderCreateDate"
			Case "3" sColumn = "o.OrderShippedDate"
			Case "4" sColumn = "(ISNULL(OrderTotalAmount, 0) + ISNULL(OrderDeliveryPrice, 0) + ISNULL(OrderPromoAmount, 0) + ISNULL(OrderHandlingInsurance, 0))"
			Case "5" sColumn = "(ISNULL(OrderCostAmount, 0) + ISNULL(OrderDeliveryCost, 0))"
			Case "6" sColumn = "((ISNULL(OrderTotalAmount, 0) + ISNULL(OrderDeliveryPrice, 0) + ISNULL(OrderPromoAmount, 0) + ISNULL(OrderHandlingInsurance, 0)) - (ISNULL(OrderCostAmount, 0) + ISNULL(OrderDeliveryCost, 0)))"
			Case "7" sColumn = "u.UserNickName"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>