<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim SearchMonth : SearchMonth = IIF(Request("SearchMonth") <> "", Request("SearchMonth"), Month(Now))
	If Not ValidateInteger(SearchMonth) Then
		AddError("Month is invalid.")
		Redirect("ReportSalesTax.asp")
	End If

	Dim SearchYear : SearchYear = IIF(Request("SearchYear") <> "", Request("SearchYear"), Year(Now))
	If Not ValidateInteger(SearchYear) Then
		AddError("Year is invalid.")
		Redirect("ReportSalesTax.asp")
	End If

	Dim oConn, sQuery, oQuery, i
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sCompanyTaxState : sCompanyTaxState = GetSetting(oConn, "CompanyTaxState")
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Sales Tax Report For <%= sCompanyTaxState %></h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		Dim sWhere : sWhere = "OrderStatusID = 10" &_
						"  AND OrderShippingState = '" & Quote(sCompanyTaxState) & "'"
		If SearchMonth <> "" Then
			sWhere = sWhere & " AND MONTH(OrderShippedDate) = '" & SearchMonth & "' "
		End If
		If SearchYear <> "" Then
			sWhere = sWhere & " AND YEAR(OrderShippedDate) = '" & SearchYear & "' "
		End If

		Dim sOrder, sArrow
		sOrder = "1"
		sArrow = "2"
		If Request("Order") <> "" And Request("Arrow") <> "" Then
			sOrder = Request("Order")
			sArrow = Request("Arrow")
		End If

		sQuery = "SELECT OrderID" &_
				 "	   , CONVERT(VARCHAR(10), OrderShippedDate, 101) AS DateShipped" &_
				 "	   , (SELECT SUM(OrderDetailProductQuantity) FROM utb_OrderDetails WHERE OrderID = o.OrderID) AS ProductsTotal" &_
				 "	   , (SELECT SUM(ProductPrice * OrderDetailProductQuantity) FROM utb_OrderDetails WHERE OrderID = o.OrderID) AS CostTotal" &_
				 "	   , ISNULL(OrderDeliveryPrice, 0) AS ShippingPrice" &_
				 "	   , ISNULL(OrderPromoAmount, 0) AS PromoAmount" &_
				 "	   , ISNULL(OrderTaxAmount, 0) AS Tax" &_
				 "	   , ( (SELECT SUM(ProductPrice * OrderDetailProductQuantity) FROM utb_OrderDetails WHERE OrderID = o.OrderID)" &_
				 "		  + ISNULL(OrderDeliveryPrice, 0)" &_
				 "		  + ISNULL(OrderPromoAmount, 0)" &_
				 "		  + ISNULL(OrderTaxAmount, 0)" &_
				 "	   	 ) AS OrderTotal" &_
				 "	FROM utb_Orders AS o" &_
				 " WHERE " & sWhere &_
				 " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

		Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
		iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
		iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
		Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
		iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<div>
				<form action="" method="get">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchMonth">Month:</label></div>
								</div>
								<select class="selector" name="SearchMonth" id="SearchMonth" style="width:130px;">
								<% For i = 1 to Ubound(arMonth) %>
									<option value="<%= i %>" <%= IIF(CStr(i) = CStr(SearchMonth), "selected='selected'", "") %>><%= arMonth(i) %></option>
								<% Next %>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchYear">Year:</label></div>
								</div>
								<select class="selector" name="SearchYear" id="SearchYear" style="width:130px;">
								<% Dim sYearBuffer : sYearBuffer = "" %>
								<% For i = Year(Now) - 10 to Year(Now) %>
									<% sYearBuffer = "<option value=""" & i & """" & IIF(CStr(i) = CStr(SearchYear), " selected='selected'", "") & ">" & i & "</option>" & sYearBuffer %>
								<% Next %>
								<%= sYearBuffer %>
								</select>
							</td>
							<td><input type="submit" class="inline-btn" value="Search" /></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('ReportSalesTax.asp')" /></td>
						</tr>
					</table>
				</form>
			</div>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<% Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow") %>
			<tr class="head-line">
				<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 110px"><%= GetURLForOrder("Date Shipped", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 110px"><%= GetURLForOrder("Quantity", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 110px"><%= GetURLForOrder("Products Total", "4", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 110px"><%= GetURLForOrder("Shipping Price", "5", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 110px"><%= GetURLForOrder("Promo Amount", "7", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Tax", "8", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 110px"><%= GetURLForOrder("Grand Total", "9", sOrderQuery, sOrder, sArrow) %></td>
			</tr>
			<%
			i = 1
			While Not oQuery.Eof
				%>
				<tr class="<%= IIF(i Mod 2 = 0, "row-hl", "") %>">
					<td><a href="OrderForm.asp?OrderID=<%= oQuery("OrderID") %>"><%= oQuery("OrderID") %></a></td>
					<td><%= oQuery("DateShipped") %></td>
					<td style="text-align: right"><%= oQuery("ProductsTotal") %></td>
					<td style="text-align: right"><%= CurrencyFormat(oQuery("CostTotal"), 2) %></td>
					<td style="text-align: right"><%= CurrencyFormat(oQuery("ShippingPrice"), 2) %></td>
					<td style="text-align: right"><%= CurrencyFormat(oQuery("PromoAmount"), 2) %></td>
					<td style="text-align: right"><%= CurrencyFormat(oQuery("Tax"), 2) %></td>
					<td style="text-align: right"><%= CurrencyFormat(oQuery("OrderTotal"), 2) %></td>
				</tr>
				<%
				i = i + 1
				oQuery.MoveNext
			Wend
			oQuery.Close
			Set oQuery = Nothing

			If iRecordCount > 0 Then
				Dim RecordsTotal, ShippingPrice, PromoAmount, Tax

				sQuery = "SELECT COUNT(*) AS RecordsTotal" &_
						 "	   , SUM(OrderDeliveryPrice) AS ShippingPrice" &_
						 "	   , SUM(OrderPromoAmount) AS PromoAmount" &_
						 "	   , SUM(OrderTaxAmount) AS Tax" &_
						 "	FROM utb_Orders" &_
						 " WHERE " & sWhere
				Set oQuery = oConn.Execute(sQuery)
					RecordsTotal	= oQuery("RecordsTotal")
					ShippingPrice	= oQuery("ShippingPrice")
					PromoAmount		= oQuery("PromoAmount")
					Tax				= oQuery("Tax")
					oQuery.Close
				Set oQuery = Nothing

				Dim ProductsTotal, CostTotal
				sQuery = "SELECT SUM(od.OrderDetailProductQuantity) AS ProductsTotal" &_
						 "	   , SUM(ProductPrice * OrderDetailProductQuantity) AS CostTotal" &_
						 "	FROM utb_Orders AS o" &_
						 "		 INNER JOIN utb_OrderDetails od ON od.OrderID = o.OrderID" &_
						 " WHERE " & sWhere
				Set oQuery = oConn.Execute(sQuery)
					ProductsTotal	= oQuery("ProductsTotal")
					CostTotal		= oQuery("CostTotal")
					oQuery.Close
				Set oQuery = Nothing

				Dim OrderTotal
				OrderTotal = CCur(CostTotal) + CCur(ShippingPrice) + CCur(PromoAmount) + CCur(Tax)
				%>
				<tr class="head-line">
					<td><strong><%= FormatNumber(RecordsTotal, 0) %></strong></td>
					<td>&nbsp;</td>
					<td style="text-align: right"><strong><%= FormatNumber(ProductsTotal, 0) %></strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(CostTotal, 2) %></strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(ShippingPrice, 2) %></strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(PromoAmount, 2) %></strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(Tax, 2) %></strong></td>
					<td style="text-align: right"><strong><%= CurrencyFormat(OrderTotal, 2) %></strong></td>
				</tr>
				<%
			End If
			%>
		</table>
		<% If iRecordCount = 0 Then %>
			<!--#include file="inc/NoRecords.asp"-->
		<% End If %>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "OrderID"

		Select Case sIndex
			Case "1" sColumn = "OrderID"
			Case "2" sColumn = "OrderShippedDate"
			Case "3" sColumn = "(SELECT SUM(OrderDetailProductQuantity) FROM utb_OrderDetails WHERE OrderID = o.OrderID)"
			Case "4" sColumn = "(SELECT SUM(ProductPrice * OrderDetailProductQuantity) FROM utb_OrderDetails WHERE OrderID = o.OrderID)"
			Case "5" sColumn = "ISNULL(OrderDeliveryPrice, 0)"
			Case "7" sColumn = "ISNULL(OrderPromoAmount, 0)"
			Case "8" sColumn = "ISNULL(OrderTaxAmount, 0)"
			Case "9" sColumn = "((SELECT SUM(ProductPrice * OrderDetailProductQuantity) FROM utb_OrderDetails WHERE OrderID = o.OrderID) + ISNULL(OrderDeliveryPrice, 0) + ISNULL(OrderPromoAmount, 0) + ISNULL(OrderTaxAmount, 0))"
		End Select

		GetColumnByIndex = sColumn
	End Function

	Sub SetBackURL()
		Session("OrderBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>