﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim oConn, sQuery, oQuery, oQuery2
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim SearchUserID : SearchUserID = Request("SearchUserID")
	Dim SearchStartDate : SearchStartDate = Request("SearchStartDate")
	Dim SearchFinishDate : SearchFinishDate = Request("SearchFinishDate")

	If Not CheckUserPermission(6) Then
		SearchUserID = Session("UserID")
	End If

	Dim isShowReport : isShowReport = False
	If Request("submit") <> "" Then
		If SearchUserID = "" Then
			AddError("<strong>Salesman</strong> is required.")
		End If
		If SearchStartDate = "" And SearchFinishDate = "" Then
			AddError("<strong>Start Date</strong> or <strong>Finish Date</strong> is required.")
		End If
		If Not IsError() Then
			isShowReport = True
		End If
	End If

	Dim sUsersHtml, sUserSel
	Set oQuery = oConn.Execute("SELECT UserID, UserNickName FROM utb_Users WHERE UserIsActive = 1 ORDER BY 2")
	While Not oQuery.Eof
		sUserSel = IIF(CStr(SearchUserID) = CStr(oQuery("UserID")), " selected='selected'", "")
		sUsersHtml = sUsersHtml &_
			"<option value='" & oQuery("UserID") & "'" & sUserSel & ">" & oQuery("UserNickName") & "</option>"

		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="SiteMap.asp"> &laquo; Back</a>
			<h1>Salesman Commission Report</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		If isShowReport Then
			Dim sWhere : sWhere = ""
			Dim sDelimiter : sDelimiter = ""

			If SearchUserID <> "" Then
				sWhere = sWhere & sDelimiter & " o.SalesmanUserID = '" & SearchUserID & "' "
				sDelimiter = " AND "
			End If

			If SearchStartDate <> "" Or SearchFinishDate <> "" Then
				If SearchStartDate <> "" Then
					sWhere = sWhere & sDelimiter & " o.OrderShippedDate >= '" & SearchStartDate & " 00:00:00' "
					sDelimiter = " AND "
				End If
				If SearchFinishDate <> "" Then
					sWhere = sWhere & sDelimiter & " o.OrderShippedDate <= '" & SearchFinishDate & " 23:59:59' "
					sDelimiter = " AND "
				End If
			End If

			Dim iMerchantFee : iMerchantFee = GetValueFromTable(oConn, "TOP 1 CompanyMerchantFeeNumber", "utb_Settings", "")

			Dim sTotalFields, sCostFields, sPRFields, sCommFields
			sTotalFields= "(	ISNULL(o.OrderTotalAmount, 0)" &_
						   "  + ISNULL(o.OrderDeliveryPrice, 0)" &_
						   "  + ISNULL(o.OrderPromoAmount, 0)" &_
						   "  + ISNULL(o.OrderHandlingInsurance, 0)" &_
						   ")"
			sCostFields	= "(	ISNULL(o.OrderCostAmount, 0)" &_
						   "  + ISNULL(o.OrderDeliveryCost, 0)" &_
						   "  + (" & sTotalFields & " / 100 * " & iMerchantFee & ")" &_
						   ")"
			sPRFields	= "(" & sTotalFields & " - " & sCostFields & ")"
			sCommFields	= "(" & sPRFields & " / 100 * u.UserCommission)"

			Dim sOrder, sArrow, sOrderBy
			sOrder = "1"
			sArrow = "2"
			If Request("Order") <> "" And Request("Arrow") <> "" Then
				sOrder = Request("Order")
				sArrow = Request("Arrow")
			End If
			sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

			sQuery = " SELECT o.OrderID" &_
					 "		, CONVERT(VARCHAR(10), o.OrderShippedDate, 101) + '&nbsp;' + CONVERT(VARCHAR(5), o.OrderShippedDate, 114) AS _OrderShippedDate" &_
					 "		, " & sTotalFields & " AS Total" &_
					 "		, " & sCostFields & " AS Cost" &_
					 "		, " & sPRFields & " AS PR" &_
					 "		, " & sCommFields & " AS Commission" &_
					 "  FROM utb_Orders o" &_
					 "		 INNER JOIN utb_Users AS u ON u.UserID = o.SalesmanUserID" &_
					 IIF(sWhere <> "", " WHERE " & sWhere, "") &_
					 sOrderBy

			Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
			iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
			iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
			Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
			iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
		End If

		Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow")
		%>
		<div class="box-head">
			<div>
				<% If isShowReport Then %>
				<div style="float: right; padding-top: 7px">
					<!--#include file="inc/PagerBackend.asp"-->
				</div>
				<% End If %>
				<form action="" method="get">
					<table cellpadding="2" cellspacing="0" border="0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchUserID">Salesman:</label></div>
								</div>
								<% If CheckUserPermission(6) Then %>
								<select class="selector" id="SearchUserID" name="SearchUserID" style="width: auto">
									<option value="">Select One</option>
									<%= sUsersHtml %>
								<% Else %>
								<select class="selector" id="SearchUserID" name="SearchUserID" style="width: auto" disabled="disabled">
									<option value="<%= Session("UserID") %>"><%= Session("UserNickName") %></option>
								<% End If %>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchStartDate">Date From:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchStartDate" name="SearchStartDate" value="<%= SearchStartDate %>" style="width: 65px" maxlength="10" readonly="readonly"/>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="SearchFinishDate">Date To:</label></div>
								</div>
								<input type="text" class="form-field" id="SearchFinishDate" name="SearchFinishDate" value="<%= SearchFinishDate %>" style="width: 65px" maxlength="10" readonly="readonly"/>
							</td>
							<td><input type="submit" class="inline-btn" name="submit" value="Search"/></td>
							<td><input type="button" class="inline-btn" value="Reset" onclick="redirect('ReportSalesmanCommission.asp')"/></td>
						</tr>
					</table>
				</form>
				<div style="clear: both"></div>
			</div>
		</div>

		<% If isShowReport Then %>
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
				<tr class="head-line">
					<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 100px"><%= GetURLForOrder("Date Shipped", "2", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 80px"><%= GetURLForOrder("Order Total", "3", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 80px"><%= GetURLForOrder("Total Cost", "4", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 80px"><%= GetURLForOrder("PR", "5", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 90px"><%= GetURLForOrder("Commission", "6", sOrderQuery, sOrder, sArrow) %></td>
					<td>&nbsp;</td>
				</tr>
				<%
				If iRecordCount > 0 Then
					Dim iCount : iCount = 0
					While Not oQuery.Eof
						iCount = iCount + 1
						%>
						<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
							<td style="text-align: right"><a href="OrderForm.asp?OrderID=<%= oQuery("OrderID") %>"><%= oQuery("OrderID") %></a></td>
							<td><%= oQuery("_OrderShippedDate") %></td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("Total"), 2) %>&nbsp;</td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("Cost"), 2) %>&nbsp;</td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("PR"), 2) %>&nbsp;</td>
							<td style="text-align: right"><%= CurrencyFormat(oQuery("Commission"), 2) %>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
						<%
						oQuery.MoveNext
					Wend
					oQuery.Close
					Set oQuery = Nothing

					iCount = iCount + 1

					Dim sQuery2, oTotalQuery
					sQuery2 = "SELECT SUM(" & sTotalFields & ") AS Total" &_
							  "		, SUM(" & sCostFields & ") AS Cost" &_
							  "		, SUM(" & sPRFields & ") AS PR" &_
							  "		, SUM(" & sCommFields & ") AS Commission" &_
							  "	 FROM utb_Orders o" &_
							  "		  INNER JOIN utb_Users AS u ON u.UserID = o.SalesmanUserID" &_
							 IIF(sWhere <> "", " WHERE " & sWhere, "")
					Set oTotalQuery = oConn.Execute(sQuery2)
					%>
					<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
						<td style="text-align: right" colspan="2"><strong>Total:&nbsp;</strong></td>
						<td style="text-align: right"><strong><%= CurrencyFormat(oTotalQuery("Total"), 2) %>&nbsp;</strong></td>
						<td style="text-align: right"><strong><%= CurrencyFormat(oTotalQuery("Cost"), 2) %>&nbsp;</strong></td>
						<td style="text-align: right"><strong><%= CurrencyFormat(oTotalQuery("PR"), 2) %>&nbsp;</strong></td>
						<td style="text-align: right"><strong><%= CurrencyFormat(oTotalQuery("Commission"), 2) %>&nbsp;</strong></td>
						<td>&nbsp;</td>
					</tr>
					<%
					oTotalQuery.Close
					Set oTotalQuery = Nothing
				End If
				%>
			</table>
			<% If iRecordCount = 0 Then %>
				<!--#include file="inc/NoRecords.asp"-->
			<%
			End If
		End If
		%>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			$('#SearchStartDate,#SearchFinishDate').datepicker({dateFormat: 'm/d/yy'});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "od.ProductSKU"

		Select Case sIndex
			Case "1" sColumn = "o.OrderID"
			Case "2" sColumn = "o.OrderShippedDate"
			Case "3" sColumn = sTotalFields
			Case "4" sColumn = sCostFields
			Case "5" sColumn = sPRFields
			Case "6" sColumn = sCommFields
		End Select

		GetColumnByIndex = sColumn
	End Function
%>