<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("RmaStatusList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, oEditor
	Dim Name, EmailSubject, EmailBody, Color, IsSystem, IsSendEmail
	Dim iRmaStatusID

	Select Case sAction
		Case "New"
			sTitle = "Add RMA Status"
			sAction = "Insert"

			Color = "000000"
			IsSystem = "0"
			IsSendEmail = "0"

		Case "Edit"
			sTitle = "Edit RMA Status Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_RmaStatuses WHERE RmaStatusID = " & iID)
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("RmaStatusName"))
				EmailSubject = HTMLEncode(oQuery("RmaStatusEmailSubject"))
				EmailBody = oQuery("RmaStatusEmailBody")
				Color = HTMLEncode(oQuery("RmaStatusColor"))
				IsSystem = oQuery("RmaStatusIsSystem")
				IsSendEmail = oQuery("RmaStatusIsSendEmail")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add RMA Status"

			CommonValidation()
			If GetValueFromTable(oConn, "RmaStatusID", "utb_RmaStatuses", "WHERE RmaStatusName = '" & Quote(Name) & "'") <> "" Then
				AddError("RMA Status with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_RmaStatuses(" &_
						 "	RmaStatusName" &_
						 ", RmaStatusEmailSubject" &_
						 ", RmaStatusEmailBody" &_
						 ", RmaStatusColor" &_
						 ", RmaStatusIsSystem" &_
						 ", RmaStatusIsSendEmail" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(Name) & "'" &_
						 ", '" & Quote(EmailSubject) & "'" &_
						 ",  " & IIF(EmailBody <> "", "'" & Quote(EmailBody) & "'", "NULL") &_
						 ", '" & Quote(Color) & "'" &_
						 ", '" & Quote(IsSystem) & "'" &_
						 ", '" & Quote(IsSendEmail) & "'" &_
						 ")"
				oConn.Execute(sQuery)

				iRmaStatusID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "RMA Status has been created.")
					Redirect("RmaStatusForm.asp?Action=Edit&ID=" & iRmaStatusID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit RMA Status Ref # " & iID

			CommonValidation()
			If GetValueFromTable(oConn, "RmaStatusID", "utb_RmaStatuses", "WHERE RmaStatusName = '" & Quote(Name) & "' AND RmaStatusID <> '" & Quote(iID) & "'") <> "" Then
				AddError("RMA Status with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " UPDATE utb_RmaStatuses" &_
						 "	  SET RmaStatusName = '" & Quote(Name) & "'" &_
						 "		, RmaStatusEmailSubject = '" & Quote(EmailSubject) & "'" &_
						 "		, RmaStatusEmailBody = " & IIF(EmailBody <> "", "'" & Quote(EmailBody) & "'", "NULL") &_
						 "		, RmaStatusColor = '" & Quote(Color) & "'" &_
						 "		, RmaStatusIsSendEmail = '" & Quote(IsSendEmail) & "'" &_
						 "	WHERE RmaStatusID = " & iID
				oConn.Execute(sQuery)

				iRmaStatusID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "RMA Status has been updated.")
					Redirect("RmaStatusForm.asp?Action=Edit&ID=" & iRmaStatusID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = " DELETE " &_
					 "	 FROM utb_RmaStatuses" &_
					 "	WHERE RmaStatusID = '" & Quote(iID) & "'" &_
					 "	  AND RmaStatusIsSystem = 0"
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "RMA Status has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
		<link rel="stylesheet" type="text/css" href="styles/colorpicker.css"/>
		<script type="text/javascript" src="js/colorpicker.js"></script>
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>RMA Statuses</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<!--#include file="../ckeditor/ckeditor.asp"-->
			<form action="RmaStatusForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right"><% If IsSystem <> "1" Then %><span class="asterisk">*</span><% End If %> Name</td>
						<td>
							<% If IsSystem = "1" Then %>
							<strong><%= Name %></strong><input type="hidden" name="Name" value="<%= Name %>"/>
							<% Else %>
							<input type="text" class="form-field" name="Name" value="<%= Name %>" style="width: 300px" maxlength="255"/>
							<% End If %>
							<input type="hidden" name="IsSystem" value="<%= IsSystem %>"/>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> E-mail Subject</td>
						<td><input type="text" class="form-field" name="EmailSubject" value="<%= EmailSubject %>" style="width: 806px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right">E-mail Body</td>
						<td>
				<%
					Set oEditor = New CKeditor
					oEditor.basePath = "../ckeditor/"
					oEditor.config("width") = 850
					oEditor.config("height") = 400
					oEditor.editor "EmailBody", EmailBody
				%>
						</td>
					</tr>
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> Color</td>
						<td><input type="text" class="form-field" id="Color" name="Color" value="<%= Color %>" style="width:60px;" maxlength="6" readonly="readonly" /></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsSendEmail">Send E-mail</label></td>
						<td><input type="checkbox" name="IsSendEmail" id="IsSendEmail" value="1" <%= IIF(IsSendEmail = "1", "checked='checked'", "") %>/></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float: left"><input type="submit" class="form-btn" value="Save"/></div>
							<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(document).ready(function(){
			$('#Color').ColorPicker({
				color: '#00ff00',
				onBeforeShow: function(){
					$(this).ColorPickerSetColor(this.value);
				},
				onShow: function (colpkr){
					$(colpkr).slideDown(300);
					return false;
				},
				onSubmit: function(hsb, hex, rgb, el){
					$(el).val(hex.toUpperCase());
					$(el).ColorPickerHide();
				}
			});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		EmailSubject = Trim(Request("EmailSubject"))
		EmailBody = Trim(Request("EmailBody"))
		Color = Trim(Request("Color"))
		IsSystem = Trim(Request("IsSystem"))
		IsSendEmail = Trim(Request("IsSendEmail"))

		If EmailSubject = "" Then
			AddError("Field <strong>E-mail Subject</strong> is required.")
		End If
		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Color = "" Then
			AddError("Field <strong>Color</strong> is required.")
		ElseIf Not ValidateColor(Color) Then
			AddError("Field <strong>Color</strong> is invalid.")
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("RmaStatusBackURL") = "", sDefaultURL, Session("RmaStatusBackURL"))
	End Function

	Sub SetBackURL()
		Session("RmaStatusFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>