<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>RMA Statuses</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<%
		Dim sOrder, sArrow, sOrderBy
		sOrder = "1"
		sArrow = "1"
		If Request("Order") <> "" And Request("Arrow") <> "" Then
			sOrder = Request("Order")
			sArrow = Request("Arrow")
		End If
		sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

		sQuery = " SELECT *" &_
				 "		, (SELECT COUNT(*) FROM utb_Rma WHERE RmaStatusID = rs.RmaStatusID) AS RmaStatusRmaCount" &_
				 "	 FROM utb_RmaStatuses rs" &_
				 sOrderBy

		Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
		iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
		iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
		Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
		iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)

		Dim iCount : iCount = 0
		Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow")
		%>
		<div class="box-head">
			<!--#include file="inc/PagerBackend.asp"-->
			<a class="head-link-right icon-add" href="RmaStatusForm.asp?Action=New&amp;ID=0">Add RMA Status</a>
			<h2>RMA Statuses</h2>
		</div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
			<tr class="head-line">
				<td style="width: 50px"><%= GetURLForOrder("#", "1", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Name", "2", sOrderQuery, sOrder, sArrow) %></td>
				<td><%= GetURLForOrder("Email Subject", "3", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 60px"><%= GetURLForOrder("Color", "4", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 60px"><%= GetURLForOrder("Type", "5", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 80px"><%= GetURLForOrder("Send Email", "6", sOrderQuery, sOrder, sArrow) %></td>
				<td style="width: 50px">&nbsp;</td>
			</tr>
			<%
			While Not oQuery.Eof
				iCount = iCount + 1
				%>
				<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
					<td><%= oQuery("RmaStatusID") %></td>
					<td style="text-align: left"><%= oQuery("RmaStatusName") %></td>
					<td style="text-align: left"><%= oQuery("RmaStatusEmailSubject") %></td>
					<td style="background: #<%= oQuery("RmaStatusColor") %>">&nbsp;</td>
					<td><%= IIF(oQuery("RmaStatusIsSystem") = 1, "<span style='color: #e20000'>System</span>", "<span style='color: #159600'>User</span>") %></td>
					<td><%= IIF(oQuery("RmaStatusIsSendEmail") = 1, "Yes", "No") %></td>
					<td>
						<a href="RmaStatusForm.asp?Action=Edit&amp;ID=<%= oQuery("RmaStatusID") %>"><img src="images/grid-act-edit.png" alt="" title="Edit" width="16" height="16"/></a>
						&nbsp;
						<% If oQuery("RmaStatusRmaCount") = 0 _
						  And oQuery("RmaStatusIsSystem") = 0 Then %>
						<a href="RmaStatusForm.asp?Action=Delete&amp;ID=<%= oQuery("RmaStatusID") %>" onclick="return areYouSure();"><img src="images/grid-act-delete.png" alt="" title="Delete" width="16" height="16"/></a>
						<% Else %>
						<img src="images/grid-act-delete-gray.png" alt="" width="16" height="16"/>
						<% End If %>
					</td>
				</tr>
				<%
				oQuery.MoveNext
			Wend
			%>
		</table>
		<%
		If iRecordCount = 0 Then
			%><!--#include file="inc/NoRecords.asp"--><%
		End If
		oQuery.Close
		Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "RmaStatusID"

		Select Case sIndex
			Case "1" sColumn = "RmaStatusID"
			Case "2" sColumn = "RmaStatusName"
			Case "3" sColumn = "RmaStatusEmailSubject"
			Case "4" sColumn = "RmaStatusColor"
			Case "5" sColumn = "RmaStatusIsSystem"
			Case "6" sColumn = "RmaStatusIsSendEmail"
		End Select

		GetColumnByIndex = sColumn
	End Function

	Sub SetBackURL()
		Session("RmaStatusBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>
