﻿<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("UserList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("Edit", "Update")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim IP, TaxState, TaxRate, EmailForOrder, EmailForSite, IsCheckQuantity, IsOrderSetStatusWhenPrint, MerchantFeeNumber
	Dim PackingSlipsPrintNum

	Select Case sAction
		Case "Edit"
			Set oQuery = oConn.Execute("SELECT * FROM utb_Settings WHERE CompanyID = " & iID)
			If Not oQuery.Eof Then
				IP = HTMLEncode(oQuery("CompanyIP"))
				TaxState = HTMLEncode(oQuery("CompanyTaxState"))
				TaxRate = DecimalFormat(oQuery("CompanyTaxRate"), 3)
				EmailForOrder = HTMLEncode(oQuery("CompanyEmailForOrder"))
				EmailForSite = HTMLEncode(oQuery("CompanyEmailForSite"))
				IsCheckQuantity = oQuery("CompanyIsCheckQuantity")
				IsOrderSetStatusWhenPrint = oQuery("CompanyIsOrderSetStatusWhenPrint")
				MerchantFeeNumber = DecimalFormat(oQuery("CompanyMerchantFeeNumber"), 3)
				PackingSlipsPrintNum = oQuery("CompanyPackingSlipsPrintNum")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Update"
			CommonValidation()
			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "UPDATE utb_Settings" &_
						 "	 SET CompanyIP = " & IIF(IP <> "", "'" & Quote(IP) & "'", "NULL") & _
						 "	   , CompanyTaxState = " & IIF(TaxState <> "", "'" & Quote(TaxState) & "'", "NULL") &_
						 "	   , CompanyTaxRate = " & IIF(TaxRate <> "", "'" & Quote(DecimalPatch(TaxRate)) & "'", "NULL") &_
						 "	   , CompanyEmailForOrder = " & IIF(EmailForOrder <> "", "'" & Quote(EmailForOrder) & "'", "NULL") &_
						 "	   , CompanyEmailForSite = " & IIF(EmailForSite <> "", "'" & Quote(EmailForSite) & "'", "NULL") &_
						 "	   , CompanyIsCheckQuantity = '" & Quote(IsCheckQuantity) & "'" &_
						 "	   , CompanyIsOrderSetStatusWhenPrint = '" & Quote(IsOrderSetStatusWhenPrint) & "'" &_
						 "	   , CompanyMerchantFeeNumber = " & IIF(MerchantFeeNumber <> "", "'" & Quote(DecimalPatch(MerchantFeeNumber)) & "'", "NULL") &_
						 "	   , CompanyPackingSlipsPrintNum = " & PackingSlipsPrintNum &_
						 " WHERE CompanyID = '" & Quote(iID) & "'"
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Settings has been updated.")
					Redirect("SettingForm.asp?Action=Edit&ID=" & iID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Settings</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head"><h2>Edit Settings</h2></div>
		<div class="box">
			<form action="SettingForm.asp" method="post">
				<input type="hidden" name="Action" value="Update"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right">Company IP</td>
						<td>
							<input type="text" class="form-field" name="IP" value="<%= IP %>" style="width: 150px" maxlength="15"/>
							&nbsp;&nbsp;&nbsp;
							<span style="color: #999">Your Current IP: <%= Request.ServerVariables("REMOTE_ADDR") %></span>
						</td>
					</tr>
					<tr>
						<td style="text-align: right">Company Tax State</td>
						<td>
							<select class="selector" name="TaxState" style="width: auto">
								<option value="">Select One</option>
								<%
								Set oQuery = oConn.Execute("SELECT * FROM utb_States WHERE CountryCode = '" & Quote(C_DEFAULT_COUNTRY_CODE) & "' ORDER BY StateName")
								While Not oQuery.Eof 
									%><option value="<%= oQuery("StateCode") %>"<%= IIF(CStr(oQuery("StateCode")) = CStr(IIF(IsNull(TaxState), "", TaxState)), " selected='selected'", "") %>><%= oQuery("StateName") %></option><%
									oQuery.MoveNext
								Wend
								oQuery.Close
								Set oQuery = Nothing
								%>
							</select>
						</td>
					</tr>
					<tr>
						<td style="text-align: right">Company Tax Rate</td>
						<td><input type="text" class="form-field" name="TaxRate" value="<%= TaxRate %>" style="width: 100px" maxlength="8"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Company Email For Order</td>
						<td><input type="text" class="form-field" name="EmailForOrder" value="<%= EmailForOrder %>" style="width: 200px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Company Email For Site</td>
						<td><input type="text" class="form-field" name="EmailForSite" value="<%= EmailForSite %>" style="width: 200px" maxlength="255"/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsCheckQuantity">Check Quantity in Basket</label></td>
						<td><input type="checkbox" name="IsCheckQuantity" id="IsCheckQuantity" value="1"<%= IIF(IsCheckQuantity = "1", " checked='checked'", "") %>/></td>
					</tr>
					<tr>
						<td style="text-align: right"><label for="IsOrderSetStatusWhenPrint">Update Order Status When Printed</label></td>
						<td>
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td style="padding: 0"><input type="checkbox" name="IsOrderSetStatusWhenPrint" id="IsOrderSetStatusWhenPrint" value="1"<%= IIF(IsOrderSetStatusWhenPrint = "1", " checked='checked'", "") %>/></td>
									<td style="padding: 0 0 2px 15px"><span style="color: #999">Will change to: <strong>Ready To Ship</strong></span></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td style="text-align: right">Merchant Fee Number</td>
						<td><input type="text" class="form-field" name="MerchantFeeNumber" value="<%= MerchantFeeNumber %>" style="width: 100px" maxlength="8"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Number Of Packing Slips To Print</td>
						<td><input type="text" class="form-field" name="PackingSlipsPrintNum" value="<%= PackingSlipsPrintNum %>" style="width: 100px" maxlength="2"/></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float: left"><input type="submit" class="form-btn" value="Save"/></div>
							<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		IP = Trim(Request("IP"))
		TaxState = UCase(Trim(Request("TaxState")))
		TaxRate = Trim(Request("TaxRate"))
		EmailForOrder = Trim(Request("EmailForOrder"))
		EmailForSite = Trim(Request("EmailForSite"))
		IsCheckQuantity = Trim(Request("IsCheckQuantity"))
		IsOrderSetStatusWhenPrint = Trim(Request("IsOrderSetStatusWhenPrint"))
		MerchantFeeNumber = Trim(Request("MerchantFeeNumber"))
		PackingSlipsPrintNum = Trim(Request("PackingSlipsPrintNum"))

		If IP <> "" Then
			If Not ValidateIP(IP) Then
				AddError("Field <strong>Company IP</strong> is invalid.")
			End If
		End If
		If TaxState <> "" Then
			If Not ValidateCode(TaxState) Then
				AddError("Field <strong>Company Tax State</strong> is invalid.")
			ElseIf GetValueFromTable(oConn, "COUNT(*)", "utb_States", "WHERE StateCode = '" & TaxState & "'") = 0 Then
				AddError("Field <strong>Company Tax State</strong> is invalid.")
			End If
		End If
		If TaxRate <> "" Then
			If Not ValidateDecimal(TaxRate) Then
				AddError("Field <strong>Company Tax Rate</strong> is invalid.")
			End If
		End If
		If EmailForOrder = "" Then
			AddError("Field <strong>Company Email For Order</strong> is required.")
		End If
		If EmailForSite = "" Then
			AddError("Field <strong>Company Email For Site</strong> is required.")
		End If
		If MerchantFeeNumber <> "" Then
			If Not ValidateDecimal(MerchantFeeNumber) Then
				AddError("Field <strong>Merchant Fee Number</strong> is invalid.")
			End If
		End If
		If Not ValidateInteger(PackingSlipsPrintNum) Or CLng(PackingSlipsPrintNum) < 1 Then
			AddError("Field <strong>Number Of Packing Slips To Print</strong> is invalid.")
		End If
	End Sub
%>