<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("ShippingLevelList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name, Priority
	Dim iShippingLevelID

	Select Case sAction
		Case "New"
			sTitle = "Add Shipping Level"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Shipping Level Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_ShippingLevels WHERE ShippingLevelID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("ShippingLevelName"))
				Priority = HTMLEncode(oQuery("ShippingLevelPriority"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Shipping Level"

			CommonValidation()
			If Not IsError() Then
				If GetValueFromTable(oConn, "ShippingLevelID", "utb_ShippingLevels", "WHERE ShippingLevelName = '" & Quote(Name) & "'") <> "" Then
					AddError("Shipping Level with name <strong>" & Name & "</strong> already exist in database.")
				End If

				If GetValueFromTable(oConn, "ShippingLevelID", "utb_ShippingLevels", "WHERE ShippingLevelPriority = '" & Quote(Priority) & "'") <> "" Then
					AddError("Shipping Level Priority <strong>" & Priority & "</strong> already exist in database.")
				End If
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = "INSERT INTO utb_ShippingLevels(ShippingLevelName, ShippingLevelPriority) " & _
						 "VALUES('" & Quote(Name) & "', '" & Quote(Priority) & "')"
				oConn.Execute(sQuery)

				iShippingLevelID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Shipping Level has been inserted.")
					Redirect("ShippingLevelForm.asp?Action=Edit&ID=" & iShippingLevelID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Shipping Level Ref # " & iID

			CommonValidation()
			If Not IsError() Then
				If GetValueFromTable(oConn, "ShippingLevelID", "utb_ShippingLevels", "WHERE ShippingLevelName = '" & Quote(Name) & "' AND ShippingLevelID <> '" & Quote(iID) & "'") <> "" Then
					AddError("Shipping Level with name <strong>" & Name & "</strong> already exist in database.")
				End If

				If GetValueFromTable(oConn, "ShippingLevelID", "utb_ShippingLevels", "WHERE ShippingLevelPriority = '" & Quote(Priority) & "' AND ShippingLevelID <> '" & Quote(iID) & "'") <> "" Then
					AddError("Shipping Level Priority <strong>" & Priority & "</strong> already exist in database.")
				End If
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_ShippingLevels " & _
						 "	SET ShippingLevelName = '" & Quote(Name) & "' " & _
						 "	  , ShippingLevelPriority = '" & Quote(Priority) & "' " & _
						 "  WHERE ShippingLevelID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iShippingLevelID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Shipping Level has been updated.")
					Redirect("ShippingLevelForm.asp?Action=Edit&ID=" & iShippingLevelID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_ShippingLevels " & _
					 "  WHERE ShippingLevelID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Shipping Level has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Shipping Levels</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="ShippingLevelForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
				<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> Priority</td>
				<td><input type="text" class="form-field" name="Priority" value="<%= Priority %>" style="width:43px;" maxlength="5" /></td>
			</tr>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Priority = Trim(Request("Priority"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Priority = "" Then
			AddError("Field <strong>Priority</strong> is required.")
		ElseIf Not ValidateInteger(Priority) Then
			AddError("Field <strong>Priority</strong> is invalid.")
		End If
	End Sub
%>