<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("ShippingMethodList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Name, Description, SortOrder, ByUSPS, ByUPS, ByFedex
	Dim iShippingMethodID
	Dim iIndex, arCheckedID

	Select Case sAction
		Case "New"
			sTitle = "Add Shipping Method"
			sAction = "Insert"

			SortOrder = "0"

		Case "Edit"
			sTitle = "Edit Shipping Method Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_ShippingMethods WHERE ShippingMethodID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("ShippingMethodName"))
				Description = HTMLEncode(oQuery("ShippingMethodDescription"))
				SortOrder = oQuery("ShippingMethodSortOrder")
				ByUSPS	= HTMLEncode(oQuery("ShippingMethodByUSPS"))
				ByUPS	= HTMLEncode(oQuery("ShippingMethodByUPS"))
				ByFedex	= HTMLEncode(oQuery("ShippingMethodByFedex"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Shipping Method"

			CommonValidation()

			If GetValueFromTable(oConn, "ShippingMethodID", "utb_ShippingMethods", "WHERE ShippingMethodName = '" & Quote(Name) & "'") <> "" Then
				AddError("Shipping Method with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = "INSERT INTO utb_ShippingMethods(" &_
						 "	ShippingMethodName" &_
						 ", ShippingMethodDescription" &_
						 ", ShippingMethodSortOrder" &_
						 ", ShippingMethodByUSPS" &_
						 ", ShippingMethodByUPS" &_
						 ", ShippingMethodByFedex" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(Name) & "'" &_
						 ",  " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") &_
						 ", '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "'" &_
						 ",  " & IIF(ByUSPS <> "", "'" & Quote(ByUSPS) & "'", "NULL") &_
						 ",  " & IIF(ByUPS <> "", "'" & Quote(ByUPS) & "'", "NULL") &_
						 ",  " & IIF(ByFedex <> "", "'" & Quote(ByFedex) & "'", "NULL") &_
						 ")"
				oConn.Execute(sQuery)

				iShippingMethodID = GetLastID(oConn)

				arCheckedID = Split(Request("CheckedID"), ", ")
				ReDim arQuery(UBound(arCheckedID))

				For iIndex = 0 To UBound(arCheckedID)
					sQuery = " INSERT INTO utb_ShippingMethodCountries (ShippingMethodID, CountryCode) " & _
							 " VALUES ('" & Quote(iShippingMethodID) & "', '" & Quote(arCheckedID(iIndex)) & "') "
					arQuery(iIndex) = sQuery
				Next

				If UBound(arQuery) >= 0 Then
					oConn.Execute(Join(arQuery, vbNewLine))
				End If
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Shipping Method has been inserted.")
					Redirect("ShippingMethodForm.asp?Action=Edit&ID=" & iShippingMethodID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Shipping Method Ref # " & iID

			CommonValidation()

			If GetValueFromTable(oConn, "ShippingMethodID", "utb_ShippingMethods", "WHERE ShippingMethodName = '" & Quote(Name) & "' AND ShippingMethodID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Shipping Method with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans

				On Error Resume Next

				sQuery = " UPDATE utb_ShippingMethods " & _
						 "	SET ShippingMethodName = '" & Quote(Name) & "' " & _
						 "	  , ShippingMethodDescription = " & IIF(Description <> "", "'" & Quote(Description) & "'", "NULL") & " " & _
						 "	  , ShippingMethodSortOrder = '" & IIF(SortOrder = "", "0", Quote(SortOrder)) & "' " & _
						 "	  , ShippingMethodByUSPS = " & IIF(ByUSPS <> "", "'" & Quote(ByUSPS) & "'", "NULL") & " " & _
						 "	  , ShippingMethodByUPS = " & IIF(ByUPS <> "", "'" & Quote(ByUPS) & "'", "NULL") & " " & _
						 "	  , ShippingMethodByFedex = " & IIF(ByFedex <> "", "'" & Quote(ByFedex) & "'", "NULL") & " " & _
						 "  WHERE ShippingMethodID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)

				iShippingMethodID = iID

				oConn.Execute("DELETE FROM utb_ShippingMethodCountries WHERE ShippingMethodID = '" & Quote(iShippingMethodID) & "'")

				arCheckedID = Split(Request("CheckedID"), ", ")
				ReDim arQuery(UBound(arCheckedID))

				For iIndex = 0 To UBound(arCheckedID)
					sQuery = " INSERT INTO utb_ShippingMethodCountries (ShippingMethodID, CountryCode) " & _
							 " VALUES ('" & Quote(iShippingMethodID) & "', '" & Quote(arCheckedID(iIndex)) & "') "
					arQuery(iIndex) = sQuery
				Next

				If UBound(arQuery) >= 0 Then
					oConn.Execute(Join(arQuery, vbNewLine))
				End If

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Shipping Method has been updated.")
					Redirect("ShippingMethodForm.asp?Action=Edit&ID=" & iShippingMethodID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_ShippingMethods " & _
					 "  WHERE ShippingMethodID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Shipping Method has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><%= sPageTitle %></title>
	<meta name="Description" content="<%= sPageDescription %>" />
	<meta name="Keywords" content="<%= sPageKeywords %>" />
	<!--#include file="inc/HeaderBackend.asp"-->
</head>
<body>
<!--#include file="inc/TopBackend.asp"-->
<div class="box-head">
	<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
	<h1>Shipping Methods</h1>
	&nbsp;
</div>
<!--#include file="../inc/Alert.asp"-->
<div class="box-head">
	<h2><%= sTitle %></h2>
</div>
<div class="box">
	<form action="ShippingMethodForm.asp" method="post">
		<input type="hidden" name="Action" value="<%= sAction %>" />
		<input type="hidden" name="ID" value="<%= iID %>" />
		<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
			<tr>
				<td style="text-align:right;"><span class="asterisk">*</span> <label for="Name">Name</label></td>
				<td><input type="text" class="form-field" name="Name" id="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="ByUSPS">Description</label></td>
				<td><textarea class="form-field limited limit_500" name="Description" id="Description" style="width:500px;height:100px;"><%= Description %></textarea></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="ByUSPS">USPS Value</label></td>
				<td><input type="text" class="form-field" name="ByUSPS" id="ByUSPS" value="<%= ByUSPS %>" style="width:300px;" maxlength="100" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="ByUPS">UPS Value</label></td>
				<td><input type="text" class="form-field" name="ByUPS" id="ByUPS" value="<%= ByUPS %>" style="width:300px;" maxlength="100" /></td>
			</tr>
			<tr>
				<td style="text-align:right;"><label for="ByFedex">Fedex Value</label></td>
				<td><input type="text" class="form-field" name="ByFedex" id="ByFedex" value="<%= ByFedex %>" style="width:300px;" maxlength="100" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Sort Order</td>
				<td><input type="text" class="form-field" name="SortOrder" value="<%= SortOrder %>" style="width:60px;" maxlength="10" /></td>
			</tr>
		<%
			sQuery = " SELECT c.* " & _
					 "	  , ISNULL(sc.ShippingMethodCountryID, 0) AS ShippingMethodCountryID " & _
					 "   FROM utb_Countries AS c " & _
					 "		LEFT JOIN utb_ShippingMethodCountries AS sc ON sc.CountryCode = c.CountryCode " & _
					 "												   AND sc.ShippingMethodID = '" & Quote(iID) & "' " & _
					 "  WHERE c.CountryIsActiveShipping = 1 " & _
					 "  ORDER BY c.CountryName "
			Set oQuery = oConn.Execute(sQuery)
			
			If Not oQuery.Eof Then
		%>
			<tr>
				<td style="text-align:right;">Countries</td>
				<td colspan="2">
					<table>
						<tr>
						<%  
							Dim i : i = 0
							While Not oQuery.Eof 
						%>
								<%= IIF(i Mod 6 = 0, "</tr><tr>", "") %>
								<td>
									<input type="checkbox" name="CheckedID" id="CheckedID<%= oQuery("CountryCode") %>" value="<%= oQuery("CountryCode") %>" <%= IIF(oQuery("ShippingMethodCountryID") > 0, "checked='checked'", "") %> />
									<label for="CheckedID<%= oQuery("CountryCode") %>"><%= oQuery("CountryName") %></label>
								</td>
						<% 
								i = i + 1
								oQuery.MoveNext
							Wend 
						%>
						</tr>
					</table>
				</td>
			</tr>
		<% 
			End If 
		%>
			<tr>
				<td>&nbsp;</td>
				<td>
					<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
					<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
				</td>
			</tr>
		</table>
	</form>
</div>
<!--#include file="inc/BottomBackend.asp"-->
</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Description = Trim(Request("Description"))
		SortOrder = Trim(Request("SortOrder"))
		ByUSPS = Trim(Request("ByUSPS"))
		ByUPS = Trim(Request("ByUPS"))
		ByFedex = Trim(Request("ByFedex"))

		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If SortOrder <> "" Then
			If Not ValidateInteger(SortOrder) Then
				AddError("Field <strong>Sort Order</strong> is invalid.")
			End If
		End If
	End Sub
%>