<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
			$(document).ready(function(){
				var max_h = 0;
				var last_el;
				$('.map-row').each(function(n, el) {
					var w_left = ($(el).parent().innerWidth() + $(el).parent().position().left) - ($(el).position().left + $(el).width());
					if (max_h) {
						if ( w_left < 0 || $(el).position().top > max_h ) {
							$(el).before('<br clear="all" />');
							max_h = $(el).position().top;
						}
					} else {
						max_h = $(el).position().top;
					}
					last_el = el;
				});
				$(last_el).after('<br clear="all"/>');
				$(last_el).parent().css('height', '100%');
			});
		//]]>
		</script>
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Site Map</h1>
			&nbsp;
		</div>
		<div class="box" id="coming-soon">
			<ul class="map-row">
				<li><h3>Catalog</h3></li>
				<li><a href="ProductList.asp">Products</a></li>
				<li><a href="ManufacturerList.asp">Manufacturers</a></li>
				<li><a href="CategoryList.asp">Categories</a></li>
				<li><a href="ProductTypeList.asp">Product Types</a></li>
				<li><a href="PromoCodeList.asp">Promo Codes</a></li>
				<li><a href="ProductReviewList.asp">Reviews</a></li>
			</ul>

			<ul class="map-row">
				<li><h3>Content</h3></li>
				<li><a href="InfoPageList.asp">Info Pages</a></li>
				<li><a href="InfoSectionList.asp">Info Sections</a></li>
				<li><a href="FaqList.asp">FAQ</a></li>
				<li><a href="PromoList.asp">Promos</a></li>
			</ul>

			<ul class="map-row">
				<li><h3>Orders</h3></li>
				<li><a href="OrderList.asp">Orders</a></li>
				<li><a href="OrderFormCreate.asp?Type=1">Create an Order</a></li>
				<li><a href="OrderStatusList.asp">Order Statuses</a></li>
				<li><a href="PaymentTypeList.asp">Payment Types</a></li>
				<li><a href="PaymentGatewayList.asp">Payment Gateways</a></li>
				<li><a href="DeliveryCarrierList.asp">Delivery Carriers</a></li>
				<li><a href="TrackingList.asp">Tracking</a></li>
			</ul>

			<ul class="map-row">
				<li><h3>Customers</h3></li>
				<li><a href="CustomerList.asp">Customers</a></li>
				<li><a href="CustomerBasket.asp">Customer Basket</a></li>
			</ul>

			<% If CheckUserPermission(1) Then %>
			<ul class="map-row">
				<li><h3>Users</h3></li>
				<li><a href="UserList.asp">Users</a></li>
				<li><a href="RoleList.asp">Roles</a></li>
				<li><a href="PermissionList.asp">Permissions</a></li>
			</ul>
			<% End If %>

			<ul class="map-row">
				<li><h3>Newsletter</h3></li>
				<li><a href="NewsletterList.asp">Newsletters</a></li>
				<li><a href="NewsletterTypeList.asp">Newsletter Types</a></li>
				<li><a href="NewsletterReport.asp">Emails added for last 7 days</a></li>
				<li><a href="EmailTemplateList.asp">Email Templates</a></li>
			</ul>

			<ul class="map-row">
				<li><h3>Other</h3></li>
				<li><a href="SettingList.asp">Settings</a></li>
				<li><a href="FeedList.asp">Data Feeds</a></li>
				<li><a href="PolicyList.asp">Return Policies</a></li>
				<li><a href="AssignTrackingNumbers.asp">Assign tracking numbers</a></li>
				<li><a href="EndOfDay.asp">End Of Day</a></li>
				<li><a href="ProductConditionList.asp">Product Conditions</a></li>
				<li><a href="WarrantyList.asp">Warranties</a></li>
				<li><a href="PrintTemplateList.asp">Print Templates</a></li>
				<li><a href="SitemapList.asp">Site Map</a></li>
				<li><a href="NewsletterBlastList.asp">Newsletter Blast</a></li>
				<li><a href="ReferralTracking.asp">Referral Tracking</a></li>
				<li><a href="ChangePassword.asp">Change Password</a></li>
				<li><a href="TermList.asp">Terms</a></li>
				<li><a href="VendorList.asp">Vendors</a></li>
				<li><a href="BannerSmallList.asp">Small Banners</a></li>
				<li><a href="BannerBigList.asp">Big Banners</a></li>
			</ul>

			<ul class="map-row">
				<li><h3>Shipping</h3></li>
				<li><a href="TrackingList.asp">Pending Tracking Numbers</a></li>
				<li><a href="DeliveryCarrierList.asp">Delivery Carriers</a></li>
				<li><a href="CountryList.asp">Countries/States</a></li>
				<li><a href="ShippingList.asp">Shipping</a></li>
				<li><a href="ShippingLevelList.asp">Shipping Levels</a></li>
				<li><a href="ShippingMethodList.asp">Shipping Methods</a></li>
			</ul>

			<ul class="map-row">
				<li><h3>Reports</h3></li>
				<li><a href="ProductListByType.asp?Type=1">Best Sellers</a></li>
				<li><a href="ProductListByType.asp?Type=2">New Products</a></li>
				<li><a href="ProductListByType.asp?Type=3">On Sale</a></li>
				<li><a href="ProductListByType.asp?Type=4">Other Products</a></li>
				<li><a href="ReportSalesTax.asp">Sales Tax</a></li>
				<li><a href="ReportAllocation.asp">Allocation</a></li>
				<li><a href="ReportReferral.asp">Referral</a></li>
				<li><a href="ReportMissingCompatible.asp">Missing Compatible Products</a></li>
				<li><a href="ReportShippedNotBilled.asp">Orders Shipped Not Billed</a></li>
				<li><a href="ReportSalesmanCommission.asp">Salesman Commission</a></li>
				<li><a href="ReportCCDailySummaryCharges.asp">Credit Cards Daily Summary Charges</a></li>
			</ul>

			<ul class="map-row">
				<li><h3>RMA</h3></li>
				<li><a href="RmaList.asp">RMA</a></li>
				<li><a href="RmaStatusList.asp">RMA Statuses</a></li>
				<li><a href="RmaReturnReasonsList.asp">RMA Return Reasons</a></li>
			</ul>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>