<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sCountryID : sCountryID = Request("CountryID")
	Dim sBackURL : sBackURL = GetBackURL("StateList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If Not ValidateCode(sCountryID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim Code, Name, Markup
	Dim iStateID

	Select Case sAction
		Case "New"
			sTitle = "Add State"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit State Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_States WHERE StateID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				Code = HTMLEncode(oQuery("StateCode"))
				Name = HTMLEncode(oQuery("StateName"))
				Markup = DecimalFormat(oQuery("StateMarkup"), 2)
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add State"
		
			CommonValidation()
		
			If GetValueFromTable(oConn, "StateID", "utb_States", "WHERE StateCode = '" & Quote(Code) & "' AND CountryCode = '" & Quote(sCountryID) & "'") <> "" Then
				AddError("State with code <strong>" & Code & "</strong> already exist in database.")
			End If

			If GetValueFromTable(oConn, "StateID", "utb_States", "WHERE StateName = '" & Quote(Name) & "' AND CountryCode = '" & Quote(sCountryID) & "'") <> "" Then
				AddError("State with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " INSERT INTO utb_States (StateCode, StateName, StateMarkup, CountryCode) " & _
						 " VALUES ( " & _
						 "   '" & Quote(Code) & "' " & _
						 " , '" & Quote(Name) & "' " & _
						 " , '" & IIF(Markup = "", "0", Quote(DecimalPatch(Markup))) & "' " & _
						 " , '" & Quote(sCountryID) & "' " & _
						 " ) "
				oConn.Execute(sQuery)
		
				iStateID = GetLastID(oConn)
				
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "State has been inserted.")
					Redirect("StateForm.asp?Action=Edit&ID=" & iStateID & "&CountryID=" & sCountryID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Update"
			sTitle = "Edit State Ref # " & iID
		
			CommonValidation()

			If GetValueFromTable(oConn, "StateID", "utb_States", "WHERE StateCode = '" & Quote(Code) & "' AND StateID <> '" & Quote(iID) & "' AND CountryCode = '" & Quote(sCountryID) & "'") <> "" Then
				AddError("State with code <strong>" & Code & "</strong> already exist in database.")
			End If

			If GetValueFromTable(oConn, "StateID", "utb_States", "WHERE StateName = '" & Quote(Name) & "' AND StateID <> '" & Quote(iID) & "' AND CountryCode = '" & Quote(sCountryID) & "'") <> "" Then
				AddError("State with name <strong>" & Name & "</strong> already exist in database.")
			End If
			
			If Not IsError() Then
				oConn.BeginTrans
		
				On Error Resume Next
		
				sQuery = " UPDATE utb_States " & _
						 "	SET StateCode = '" & Quote(Code) & "' " & _
						 "	  , StateName = '" & Quote(Name) & "' " & _
						 "	  , StateMarkup = '" & IIF(Markup = "", "0", Quote(DecimalPatch(Markup))) & "' " & _
						 "  WHERE StateID = '" & Quote(iID) & "' "
				oConn.Execute(sQuery)
		
				iStateID = iID
		
				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "State has been updated.")
					Redirect("StateForm.asp?Action=Edit&ID=" & iStateID & "&CountryID=" & sCountryID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
		
		Case "Delete"
			oConn.BeginTrans

			On Error Resume Next

			sQuery = " DELETE " & _
					 "   FROM utb_States " & _
					 "  WHERE StateID = '" & Quote(iID) & "' "
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "State has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If

	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>States</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="StateForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>" />
				<input type="hidden" name="ID" value="<%= iID %>" />
				<input type="hidden" name="CountryID" value="<%= sCountryID %>" />
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Code</td>
						<td><input type="text" class="form-field" name="Code" value="<%= Code %>" style="width:60px;" maxlength="2" /></td>
					</tr>
					<tr>
						<td style="text-align:right;"><span class="asterisk">*</span> Name</td>
						<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width:300px;" maxlength="255" /></td>
					</tr>
					<tr>
						<td style="text-align:right;">Markup</td>
						<td><input type="text" class="form-field" name="Markup" value="<%= Markup %>" style="width:60px;" maxlength="15" /></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float:left;"><input type="submit" class="form-btn" value="Save" /></div>
							<div style="float:left;"><input type="reset" class="form-btn" value="Reset" /></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Code = Trim(Request("Code"))
		Name = Trim(Request("Name"))
		Markup = Trim(Request("Markup"))

		If Code = "" Then
			AddError("Field <strong>Code</strong> is required.")
		Else
			If Not ValidateCode(Code) Then
				AddError("Field <strong>Code</strong> is invalid.")
			End If
		End If
		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Markup <> "" Then
			If Not ValidateDecimal(Markup) Then
				AddError("Field <strong>Markup</strong> is invalid.")
			End If
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("StateBackURL") = "", sDefaultURL, Session("StateBackURL"))
	End Function
%>