<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("TermList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	SetBackURL()

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle, Name, Value, iTermID

	Select Case sAction
		Case "New"
			sTitle = "Add Terms"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Terms Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_Terms WHERE TermID = " & iID)
			If Not oQuery.Eof Then
				Name = HTMLEncode(oQuery("TermName"))
				Value = oQuery("TermValue")
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Terms"

			CommonValidation()
			If GetValueFromTable(oConn, "TermID", "utb_Terms", "WHERE TermName = '" & Quote(Name) & "'") <> "" Then
				AddError("Terms with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Terms(TermName, TermValue) " &_
						 "VALUES('" & Quote(Name) & "', " & Value & ")"
				oConn.Execute(sQuery)

				iTermID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Terms has been created.")
					Redirect("TermForm.asp?Action=Edit&ID=" & iTermID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Terms Ref # " & iID

			CommonValidation()
			If GetValueFromTable(oConn, "TermID", "utb_Terms", "WHERE TermName = '" & Quote(Name) & "' AND TermID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Terms with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " UPDATE utb_Terms" &_
						 "	  SET TermName = '" & Quote(Name) & "'" &_
						 "		, TermValue = " & Value &_
						 "	WHERE TermID = " & iID
				oConn.Execute(sQuery)

				iTermID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Terms has been updated.")
					Redirect("TermForm.asp?Action=Edit&ID=" & iTermID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = " DELETE " &_
					 "	 FROM utb_Terms" &_
					 "	WHERE TermID = '" & Quote(iID) & "'"
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Terms has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select

%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Terms</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head">
			<h2><%= sTitle %></h2>
		</div>
		<div class="box">
			<form action="TermForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
					<tr>
						<td style="text-align: right"><span class="asterisk">*</span> Name</td>
						<td><input type="text" class="form-field" name="Name" value="<%= Name %>" style="width: 300px" maxlength="50"/></td>
					</tr>
					<tr>
						<td style="text-align: right">Value</td>
						<td><input type="text" class="form-field" name="Value" value="<%= Value %>" style="width: 100px" maxlength="9"/></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<div style="float: left"><input type="submit" class="form-btn" value="Save"/></div>
							<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
	</body>
</html>
<%
	Sub CommonValidation()
		Name = Trim(Request("Name"))
		Value = Trim(Request("Value"))
		If Name = "" Then
			AddError("Field <strong>Name</strong> is required.")
		End If
		If Value <> "" And Not ValidateInteger(Value) Then
			AddError("Field <strong>Value</strong> is invalid.")
		End If
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("TermBackURL") = "", sDefaultURL, Session("TermBackURL"))
	End Function

	Sub SetBackURL()
		Session("TermFormBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub
%>