<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<%
	SetBackURL()

	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("TrackingList.asp")

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim i
	Select Case sAction
		Case "AddTrack"
			Dim OrderID : OrderID = Trim(Request("OrderID"))
			Dim CarrierID : CarrierID = Trim(Request("CarrierID"))
			Dim CarrierMethod : CarrierMethod = Trim(Request("CarrierMethod"))
			Dim TrackingNumber : TrackingNumber = Trim(Request("TrackingNumber"))
			Dim Cost : Cost = Trim(Request("Cost"))

			If CarrierID = "" Then
				AddError("Field <strong>Carrier</strong> is required.")
			ElseIf Not ValidateInteger(CarrierID) Then
				AddError("Field <strong>Carrier</strong> is invalid.")
			ElseIf GetValueFromTable(oConn, "COUNT(*)", "utb_OrderDeliveryCarriers", "WHERE OrderDeliveryCarrierID = '" & Quote(CarrierID) & "' AND OrderDeliveryCarrierIsActive = 1") <> 1 Then
				AddError("Carrier ID <strong>" & Quote(OrderID) & "</strong> doesn't exists.")
			End If

			If OrderID = "" Then
				AddError("Field <strong>Order ID</strong> is required.")
			ElseIf Not ValidateInteger(OrderID) Then
				AddError("Field <strong>Order ID</strong> is invalid.")
			Else
				Dim OrderStatusID : OrderStatusID = GetValueFromTable(oConn, "OrderStatusID", "utb_Orders", "WHERE OrderID = '" & Quote(OrderID) & "'")
				If OrderStatusID = "" Then
					AddError("Order ID <strong>" & Quote(OrderID) & "</strong> doesn't exists.")
				ElseIf OrderStatusID <> "9" Then
					AddError("Order <strong>" & Quote(OrderID) & "</strong> should have status 'Ready To Ship'.")
				End If
			End If

			If TrackingNumber = "" Then
				AddError("Field <strong>Tracking Number</strong> is required.")
			End If

			If Cost <> "" Then
				If Not ValidateDecimal(Cost) Then
					AddError("Field <strong>Cost</strong> is invalid.")
				End If
			Else
				Cost = 0
			End If

			If Not IsError() Then
				If GetValueFromTable(oConn, "COUNT(*)", "utb_Tracking", "WHERE OrderID = '" & Quote(OrderID) & "'") > 0 Then
					AddError("Trackicng with Order ID <strong>" & Quote(OrderID) & "</strong> already exists in database.")
				End If
				If GetValueFromTable(oConn, "COUNT(*)", "utb_Tracking", "WHERE TrackingNumber = '" & Quote(TrackingNumber) & "'") > 0 Then
					AddError("Trackicng with Tracking Number <strong>" & Quote(TrackingNumber) & "</strong> already exists in database.")
				End If
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Tracking(" &_
						 "	OrderID" &_
						 ", TrackingNumber" &_
						 ", TrackingCost" &_
						 ", CarrierID" &_
						 ", CarrierMethod" &_
						 ", TrackingCreateDate" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(OrderID) & "'" &_
						 ", '" & Quote(TrackingNumber) & "'" &_
						 ", '" & Quote(DecimalPatch(Cost)) & "'" &_
						 ", '" & Quote(CarrierID) & "'" &_
						 ", '" & Quote(CarrierMethod) & "'" &_
						 ", GETDATE()" &_
						 ") "
				oConn.Execute(sQuery)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Tracking has been added.")
					Redirect("TrackingList.asp")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If

		Case "Delete"
			If Request("CheckedID") <> "" Then
				oConn.BeginTrans
				On Error Resume Next

				oConn.Execute("DELETE FROM utb_Tracking WHERE TrackingID IN(" & Request("CheckedID") & ")")

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Records has been deleted.")
					Redirect("TrackingList.asp")
				Else
					oConn.RollbackTrans
					Call SetAlertMessage("error", Err.Description)
				End If
			End If
	End Select
	
	Dim SearchType : SearchType = Quote(Trim(Request("SearchType")))
	Dim SearchValue : SearchValue = Quote(Trim(Request("SearchValue")))

	' Where
	Dim sWhere
	Select Case SearchType
		Case "Order"
			sWhere = " WHERE t.OrderID LIKE '%" & SearchValue & "%' "

		Case "Tracking"
			sWhere = " WHERE t.TrackingNumber LIKE '%" & SearchValue & "%' "

		Case Else
			sWhere = ""
	End Select

	' Order By
	Dim sOrder, sArrow, sOrderBy
	sOrder = "5"
	sArrow = "2"
	If Request("Order") <> "" And Request("Arrow") <> "" Then
		sOrder = Request("Order")
		sArrow = Request("Arrow")
	End If
	sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")

	' Query
	sQuery = "SELECT t.*" &_
			 "	   , os.OrderStatusName" &_
			 "	   , c.OrderDeliveryCarrierName" &_
			 "	FROM utb_Tracking AS t" &_
			 "		 LEFT JOIN utb_OrderDeliveryCarriers AS c ON c.OrderDeliveryCarrierID = t.CarrierID" &_
			 "		 LEFT JOIN utb_Orders AS o ON CAST(o.OrderID AS VARCHAR(50)) = t.OrderID" &_
			 "		 LEFT JOIN utb_OrderStatuses AS os ON os.OrderStatusID = o.OrderStatusID" &_
			 sWhere &_
			 sOrderBy

	' Pager
	Dim iCount : iCount = 0
	Dim sOrderQuery : sOrderQuery = GetURLWithout("Order,Arrow")
	Dim i_OrderID
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>" />
		<meta name="Keywords" content="<%= sPageKeywords %>" />
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="Default.asp"> &laquo; Back</a>
			<h1>Tracking</h1>
			&nbsp;
		</div>
		<span id="alert"><!--#include file="../inc/Alert.asp"--></span>
		<div style="padding: 5px 0; height: 25px">
			<a class="head-link-left" href="#" onclick="return showSearch(this)" style="background: url(images/magnifier.png) 0 50% no-repeat<%= IIF(Request("Action") <> "AddTrack", "; display: none", "") %>">Search</a>
			<a class="head-link-right icon-add" href="#" onclick="return addNew(this)"<%= IIF(Request("Action") = "AddTrack", " style='display: none'", "") %>>Add Tracking</a>
			<div id="add-track" style="float: right<%= IIF(Request("Action") <> "AddTrack", "; display: none", "") %>">
				<form action="TrackingList.asp?Action=AddTrack" method="post">
					<table cellpadding="2" cellspacing="0" class="no-border" style="border: 0">
						<tr>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="CarrierID">Carrier:</label></div>
								</div>
								<select class="selector" name="CarrierID" id="CarrierID" style="width:90px;">
									<option value="">Select One</option>
								<%
								Dim oCarrier
								Set oCarrier = oConn.Execute("SELECT * FROM utb_OrderDeliveryCarriers WHERE OrderDeliveryCarrierIsActive = 1 ORDER BY OrderDeliveryCarrierSortOrder")
								While Not oCarrier.Eof
									%>
									<option value="<%= oCarrier("OrderDeliveryCarrierID") %>"<%= IIF(CStr(oCarrier("OrderDeliveryCarrierID")) = CStr(Request("CarrierID")), " selected='selected'", "") %>><%= oCarrier("OrderDeliveryCarrierName") %></option>
									<%
									oCarrier.MoveNext
								Wend
								oCarrier.Close
								Set oCarrier = Nothing
								%>
								</select>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="CarrierMethod">Carrier Method:</label></div>
								</div>
								<input type="text" name="CarrierMethod" id="CarrierMethod" value="<%= Request("CarrierMethod") %>" maxlength="100" style="width: 120px" class="form-field"/>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="OrderID">Order #:</label></div>
								</div>
								<input type="text" name="OrderID" id="OrderID" value="<%= Request("OrderID") %>" maxlength="50" style="width: 60px" class="form-field"/>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="TrackingNumber">Tracking #:</label></div>
								</div>
								<input type="text" name="TrackingNumber" id="TrackingNumber" value="<%= Request("TrackingNumber") %>" maxlength="50" style="width: 250px" class="form-field"/>
							</td>
							<td>
								<div style="position: relative">
									<div style="position: absolute; top: -15px; left: 4px"><label for="TrackingNumber">Cost:</label></div>
								</div>
								<input type="text" name="Cost" value="<%= Request("Cost") %>" maxlength="15" style="width: 40px" class="form-field"/>
							</td>
							<td><input type="submit" value="Add" class="inline-btn" /></td>
						</tr>
					</table>
				</form>
			</div>
			<div id="search-track" style="float: left<%= IIF(Request("Action") = "AddTrack", "; display: none", "") %>">
				<form action="" method="get">
					<table class="no-border" style="border: 0">
						<tr>
							<td>
								<select class="selector" name="SearchType" style="width: 90px">
									<option value="Order"<%= IIF(Request("SearchType") = "Order", " selected='selected'", "") %>>Order #</option>
									<option value="Tracking"<%= IIF(Request("SearchType") = "Tracking", " selected='selected'", "") %>>Tracking #</option>
								</select>
							</td>
							<td style="width: 10px">&nbsp;</td>
							<td><input type="text" name="SearchValue" value="<%= Request("SearchValue") %>" maxlength="50" style="width: 250px" class="form-field" /></td>
							<td style="width: 10px">&nbsp;</td>
							<td>
								<input type="submit" class="inline-btn" value="Search"/>
								<input type="button" class="inline-btn" value="Reset" onclick="redirect('TrackingList.asp')"/>
							</td>
						</tr>
					</table>
				</form>
			</div>
			<div style="clear: both"></div>
		</div>
		<div style="padding: 5px 0" class="grid-prehead">
			<table width="100%" cellpadding="0" cellspacing="0" border="0">
				<tr>
					<td style="height: 23px">
						<div class="grid-actions" style="display: none">
							<input type="hidden" name="Action" value="Delete"/>
							<input type="button" value="Delete" class="inline-btn deleted-sel"/>
						</div>
					</td>
					<%
					Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount
					iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
					iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
					Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
					iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
					%>
					<td><!--#include file="inc/PagerBackend.asp"--></td>
				</tr>
			</table>
		</div>

		<form action="#" method="post" id="tracking-list">
			<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid grid-list">
				<tr class="head-line">
					<td style="width: 25px"><input type="checkbox" id="check-all" onclick="$('.checkbox').attr('checked', $(this).attr('checked'))"/></td>
					<td style="width: 120px"><%= GetURLForOrder("Order ID", "1", sOrderQuery, sOrder, sArrow) %></td>
					<td><%= GetURLForOrder("Order Status", "2", sOrderQuery, sOrder, sArrow) %></td>
					<td><%= GetURLForOrder("Tracking Number", "3", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 120px"><%= GetURLForOrder("Cost", "4", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 120px"><%= GetURLForOrder("Created", "5", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 120px"><%= GetURLForOrder("Carrier Name", "6", sOrderQuery, sOrder, sArrow) %></td>
					<td style="width: 120px"><%= GetURLForOrder("Carrier Method", "7", sOrderQuery, sOrder, sArrow) %></td>
				</tr>
				<%
				While Not oQuery.Eof
					i_OrderID = IIF(IsNull(oQuery("OrderID")), "", oQuery("OrderID"))
					iCount = iCount + 1
					%>
					<tr<%= IIF(ValidateInteger(i_OrderID), IIF(iCount Mod 2 = 0, " class='row-hl'", ""), " class='row-invalid'") %>>
						<td><input type="checkbox" class="checkbox" name="CheckedID" value="<%= oQuery("TrackingID") %>"/></td>
						<td<%= IIF(Not ValidateInteger(i_OrderID), " class='col-invalid'", "") %>><%= i_OrderID %></td>
						<td><%= oQuery("OrderStatusName") %></td>
						<td><%= oQuery("TrackingNumber") %></td>
						<td><%= CurrencyFormat(oQuery("TrackingCost"), 2) %></td>
						<td><%= oQuery("TrackingCreateDate") %></td>
						<td><%= oQuery("OrderDeliveryCarrierName") %></td>
						<td><%= oQuery("CarrierMethod") %></td>
					</tr>
					<%
					oQuery.MoveNext
				Wend
				%>
			</table>
			<% If iRecordCount = 0 Then %><!--#include file="inc/NoRecords.asp"--><% End If %>
		</form>
		<%
			oQuery.Close
			Set oQuery = Nothing
		%>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		$(function(){
			if ($('.grid-list tr').length > 1) {
				$('.grid-list').after($('.grid-prehead').clone());
				checkBoxes();
			}
			$('.checkbox,#check-all').click(checkBoxes);
			
			$('.deleted-sel').click(function(){
				if (!areYouSure()) {
					return;
				}
				$('#tracking-list').submit();
			});
		});
		function addNew(linkObj) {
			$(linkObj).hide();
			$('#search-track').hide();
			$('#add-track').fadeIn(function(){
				$('.head-link-left').fadeIn();
			});
			return false;
		}
		function showSearch(linkObj) {
			$(linkObj).hide();
			$('#add-track').hide();
			$('#search-track').fadeIn(function(){
				$('.head-link-right').fadeIn();
			});
			return false;
		}
		function checkBoxes() {
			var checkedCnt = 0;
			var allChecked = true;
			$('.checkbox').each(function(){
				if (!$(this).attr('checked')) {
					if (allChecked == true) {
						allChecked = false;
					}
				}
				else {
					checkedCnt++;
				}
			});
			$('#check-all').attr('checked', allChecked);
			if (checkedCnt > 0) {
				$('.deleted-sel').val('Delete ('+checkedCnt+')');
				$('.grid-actions').show();
			}
			else {
				$('.grid-actions').hide();
				$('.GridAction').trigger('change');
			}
		}
		//]]>
		</script>
	</body>
</html>
<%
	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "t.OrderID"

		Select Case sIndex
			Case "1" sColumn = "t.OrderID"
			Case "2" sColumn = "OrderStatusName"
			Case "3" sColumn = "t.TrackingNumber"
			Case "4" sColumn = "t.TrackingCost"
			Case "5" sColumn = "t.TrackingCreateDate"
			Case "6" sColumn = "c.OrderDeliveryCarrierName"
			Case "6" sColumn = "t.CarrierMethod"
		End Select

		GetColumnByIndex = sColumn
	End Function
%>