<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("UserList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim NickName, FirstName, LastName, Email, Password, ConfirmPassword, IsActive, IsFromOffice, Commission
	Dim Note, Role, Permissions, CreateDate, VisitDate
	Dim iUserID

	Select Case sAction
		Case "New"
			sTitle = "Add User"
			sAction = "Insert"

			IsActive = "1"
			IsFromOffice = "0"

		Case "Edit"
			sTitle = "Edit User Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute(" SELECT * FROM utb_Users WHERE UserID = '" & Quote(iID) & "' ")
			If Not oQuery.Eof Then
				NickName		= HTMLEncode(oQuery("UserNickName"))
				FirstName		= HTMLEncode(oQuery("UserFirstName"))
				LastName		= HTMLEncode(oQuery("UserLastName"))
				Email			= HTMLEncode(oQuery("UserEmail"))
				Password		= HTMLEncode(Decode(oQuery("UserPassword")))
				ConfirmPassword	= Password
				IsActive		= oQuery("UserIsActive")
				IsFromOffice	= oQuery("UserIsFromOffice")
				Commission		= DecimalFormat(oQuery("UserCommission"), 3)
				Note			= HTMLEncode(oQuery("UserNote"))
				CreateDate		= oQuery("UserCreateDate")
				VisitDate		= oQuery("UserVisitDate")
			End If
			oQuery.Close
			Set oQuery = Nothing

			Set oQuery = oConn.Execute("SELECT RoleID FROM utb_UserRoles WHERE UserID = " & iID)
			While Not oQuery.Eof
				Role = Role & IIF(Len(Role) > 0, ", ", "") & oQuery("RoleID")
				oQuery.MoveNext
			Wend
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add User"

			CommonValidation()
			If GetValueFromTable(oConn, "UserID", "utb_Users", "WHERE UserEmail = '" & Quote(Email) & "'") <> "" Then
				AddError("User with email <strong>" & Email & "</strong> already exist in database.")
			End If
			If GetValueFromTable(oConn, "UserID", "utb_Users", "WHERE UserNickName = '" & Quote(NickName) & "'") <> "" Then
				AddError("User with NickName <strong>" & NickName & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Users(" &_
						 "	UserNickName" &_
						 ", UserFirstName" &_
						 ", UserLastName" &_
						 ", UserEmail" &_
						 ", UserPassword" &_
						 ", UserIsActive" &_
						 ", UserIsFromOffice" &_
						 ", UserCommission" &_
						 ", UserNote" &_
						 ") " &_
						 "VALUES(" &_
						 "	'" & Quote(NickName) & "'" &_
						 ", '" & Quote(FirstName) & "'" &_
						 ", '" & Quote(LastName) & "'" &_
						 ", '" & Quote(Email) & "'" &_
						 ", '" & Quote(Encode(Password)) & "'" &_
						 ", '" & Quote(IsActive) & "'" &_
						 ", '" & Quote(IsFromOffice) & "'" &_
						 ", '" & IIF(Commission = "", "0", Quote(DecimalPatch(Commission))) & "' " &_
						 ",  " & IIF(Note <> "", "'" & Quote(Note) & "'", "NULL") &_
						 ")"
				oConn.Execute(sQuery)

				iUserID = GetLastID(oConn)
				SaveRoles()
				SavePermissions()

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "User has been inserted.")
					Redirect("UserForm.asp?Action=Edit&ID=" & iUserID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit User Ref # " & iID

			CommonValidation()
			If GetValueFromTable(oConn, "UserID", "utb_Users", "WHERE UserEmail = '" & Quote(Email) & "' AND UserID <> " & iID) <> "" Then
				AddError("User with email <strong>" & Email & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "UPDATE utb_Users" &_
						 "	 SET UserFirstName = '" & Quote(FirstName) & "'" &_
						 "	   , UserLastName = '" & Quote(LastName) & "'" &_
						 "	   , UserEmail = '" & Quote(Email) & "'" &_
						 "	   , UserPassword = '" & Quote(Encode(Password)) & "'" &_
						 "	   , UserIsActive = '" & Quote(IsActive) & "'" &_
						 "	   , UserIsFromOffice = '" & Quote(IsFromOffice) & "'" &_
						 "	   , UserCommission = '" & IIF(Commission = "", "0", Quote(DecimalPatch(Commission))) & "'" &_
						 "	   , UserNote = " & IIF(Note <> "", "'" & Quote(Note) & "'", "NULL") &_
						 " WHERE UserID = " & iID
				oConn.Execute(sQuery)

				iUserID = iID
				SaveRoles()
				SavePermissions()

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "User has been updated.")
					Redirect("UserForm.asp?Action=Edit&ID=" & iUserID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If
	End Select
%><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Users</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head"><h2><%= sTitle %></h2></div>
		<div class="box" style="padding-right: 10px">
			<form action="UserForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr valign="top">
						<td style="width: 570px">
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td style="text-align: right"><span class="asterisk">*</span> Nick Name</td>
									<td><input type="text" class="form-field" name="NickName" value="<%= NickName %>" style="width: 150px" maxlength="50"<%= IIF(iID > 0, " disabled='disabled'", "") %>/></td>
								</tr>
								<tr>
									<td style="text-align: right"><span class="asterisk">*</span> First Name</td>
									<td><input type="text" class="form-field" name="FirstName" value="<%= FirstName %>" style="width: 200px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><span class="asterisk">*</span> Last Name</td>
									<td><input type="text" class="form-field" name="LastName" value="<%= LastName %>" style="width: 200px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><span class="asterisk">*</span> Email</td>
									<td><input type="text" class="form-field" name="Email" value="<%= Email %>" style="width: 300px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><span class="asterisk">*</span> Password</td>
									<td><input type="password" class="form-field" name="Password" value="<%= Password %>" style="width: 100px" maxlength="100"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><span class="asterisk">*</span> Confirm Password</td>
									<td><input type="password" class="form-field" name="ConfirmPassword" value="<%= ConfirmPassword %>" style="width: 100px" maxlength="100"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="IsActive">Active</label></td>
									<td><input type="checkbox" name="IsActive" id="IsActive" value="1" <%= IIF(IsActive = "1", "checked='checked'", "") %>/></td>
								</tr>
								<tr>
									<td style="text-align: right"><span class="asterisk">*</span> Access From</td>
									<td>
										<select class="selector" name="IsFromOffice" style="width:120px;">
											<option value="0"<%= IIF(IsFromOffice = "0", " selected='selected'", "") %>>Anywhere</option>
											<option value="1"<%= IIF(IsFromOffice = "1", " selected='selected'", "") %>>Office</option>
										</select>
									</td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="Commission">Commission</label></td>
									<td><input type="text" class="form-field" name="Commission" id="Commission" value="<%= Commission %>" style="width: 106px" maxlength="15"/></td>
								</tr>
								<tr>
									<td style="text-align: right">Note</td>
									<td><textarea class="form-field limited limit_1000" name="Note" style="width: 400px; height: 100px"><%= Note %></textarea></td>
								</tr>
								<% If iID > 0 Then %>
								<tr>
									<td style="text-align: right">Date Created</td>
									<td colspan="2"><strong><%= CreateDate %></strong><input type="hidden" name="CreateDate" value="<%= CreateDate %>"/></td>
								</tr>
								<% If VisitDate <> "" Then %>
								<tr>
									<td style="text-align: right">Visit Date</td>
									<td colspan="2"><strong><%= VisitDate %></strong><input type="hidden" name="VisitDate" value="<%= VisitDate %>"/></td>
								</tr>
								<% End If %>
								<% End If %>
								<tr>
									<td>&nbsp;</td>
									<td>
										<div style="float: left"><input type="submit" class="form-btn" value="Save"/></div>
										<div style="float: left"><input type="reset" class="form-btn" value="Reset"/></div>
									</td>
								</tr>
							</table>
						</td>
						<td>
							<h2 style="padding-bottom: 0">Roles</h2>
							<div class="box" style="padding: 6px 0 6px 0px; height: 114px; overflow: scroll; overflow-x: hidden">
								<%
								sQuery = "SELECT r.RoleID" &_
										 "	   , r.RoleName" &_
										 "	   , (CASE WHEN ur.UserRoleID IS NULL THEN '' ELSE ' checked=""checked""' END) AS RoleChecked" &_
										 "	FROM utb_Roles AS r" &_
										 "		 LEFT JOIN utb_UserRoles AS ur ON ur.RoleID = r.RoleID AND ur.UserID = " & iID &_
										 " ORDER BY r.RoleName"
								Set oQuery = oConn.Execute(sQuery)
								
								If Not oQuery.Eof Then
									%><table width="100%" cellpadding="0" cellspacing="0" border="0" class="roles"><%
									While Not oQuery.Eof
										%>
										<tr>
											<td style="width: 25px; text-align: right"><input type="checkbox" name="Role" id="role<%= oQuery("RoleID") %>" value="<%= oQuery("RoleID") %>"<%= oQuery("RoleChecked") %>/></td>
											<td style="padding-left: 3px"><label for="role<%= oQuery("RoleID") %>"><%= oQuery("RoleName") %></label></td>
										</tr>
										<%
										oQuery.MoveNext
									Wend
									%></table><%
								End If
								oQuery.Close
								Set oQuery = Nothing
								%>
							</div>
							<br/>

							<h2 style="padding-bottom: 0">Permissions</h2>
							<div class="box" style="padding: 6px 0 6px 0px; height: 264px; overflow: scroll; overflow-x: hidden">
								<%
								sQuery = "SELECT p.PermissionID" &_
										 "	   , p.PermissionName" &_
										 "	   , (CASE WHEN up.UserPermissionID IS NULL THEN '' ELSE ' checked=""checked""' END) AS PermissionChecked" &_
										 "	FROM utb_Permissions AS p" &_
										 "		 LEFT JOIN utb_UserPermissions AS up ON up.PermissionID = p.PermissionID AND up.UserID = " & iID &_
										 " ORDER BY p.PermissionName"
								Set oQuery = oConn.Execute(sQuery)
								
								If Not oQuery.Eof Then
									%><table width="100%" cellpadding="0" cellspacing="0" border="0" class="permissions"><%
									While Not oQuery.Eof
										%>
										<tr>
											<td style="width: 25px; text-align: right"><input type="checkbox" name="Permissions" id="perm<%= oQuery("PermissionID") %>" value="<%= oQuery("PermissionID") %>"<%= oQuery("PermissionChecked") %>/></td>
											<td style="padding-left: 3px"><label for="perm<%= oQuery("PermissionID") %>"><%= oQuery("PermissionName") %></label></td>
										</tr>
										<%
										oQuery.MoveNext
									Wend
									%></table><%
								End If
								oQuery.Close
								Set oQuery = Nothing
								%>
							</div>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		$(function(){
			$('.permissions input,.roles input').each(function(){
				if ($(this).attr('checked')) {
					$(this).parent().parent().find('label').addClass('checked');
				}
			}).click(function(){
				if ($(this).attr('checked')) {
					$(this).parent().parent().find('label').addClass('checked');
				}
				else {
					$(this).parent().parent().find('label').removeClass('checked');
				}
			});
		});
		</script>
	</body>
</html>
<%
	Sub CommonValidation()
		NickName		= Trim(Request("NickName"))
		FirstName		= Trim(Request("FirstName"))
		LastName		= Trim(Request("LastName"))
		Email			= Trim(Request("Email"))
		Password		= Trim(Request("Password"))
		ConfirmPassword	= Trim(Request("ConfirmPassword"))
		IsActive		= Trim(Request("IsActive"))
		IsFromOffice	= Trim(Request("IsFromOffice"))
		Commission		= Trim(Request("Commission"))
		Note			= Trim(Request("Note"))
		Role			= Trim(Request("Role"))
		Permissions		= Trim(Request("Permissions"))
		CreateDate		= Trim(Request("CreateDate"))
		VisitDate		= Trim(Request("VisitDate"))

		If iID = 0 And NickName = "" Then
			AddError("Field <strong>Nick Name</strong> is required.")
		End If
		If FirstName = "" Then
			AddError("Field <strong>First Name</strong> is required.")
		End If
		If LastName = "" Then
			AddError("Field <strong>Last Name</strong> is required.")
		End If
		If Email = "" Then
			AddError("Field <strong>Email</strong> is required.")
		Else
			If Not ValidateEmail(Email) Then
				AddError("Field <strong>Email</strong> is invalid.")
			End If
		End If
		If Password = "" Then
			AddError("Field <strong>Password</strong> is required.")
		Else
			If Len(Password) < C_PASSWORD_LENGTH Then
				AddError("<strong>Password</strong> length must be more or equal " & C_PASSWORD_LENGTH & " characters.")
			End If
			If Password <> ConfirmPassword Then
				AddError("<strong>Password</strong> and <strong>Confirm Password</strong> do not match.")
			End If
		End If
		If IsFromOffice = "" Then
			AddError("Field <strong>Access From</strong> is required.")
		End If
		If Role = "" Then
			AddError("Field <strong>Role</strong> is required.")
		End If
		If Commission <> "" Then
			If Not ValidateDecimal(Commission) Then
				AddError("Field <strong>Commission</strong> is invalid.")
			End If
		End If
	End Sub

	Sub SaveRoles()
		oConn.Execute("DELETE FROM utb_UserRoles WHERE UserID = " & iUserID)

		Dim iIndex, arCheckedID
		arCheckedID = Split(Role, ", ")

		Dim arQuery
		ReDim arQuery(UBound(arCheckedID))

		For iIndex = 0 To UBound(arCheckedID)
			sQuery = "INSERT INTO utb_UserRoles(UserID, RoleID) VALUES(" & iUserID & ", '" & Quote(arCheckedID(iIndex)) & "')"
			arQuery(iIndex) = sQuery
		Next

		If UBound(arQuery) >= 0 Then
			oConn.Execute(Join(arQuery, vbNewLine))
		End If

		If CLng(Session("UserID")) = CLng(iUserID) Then
			Call UpdateUserRoles(iUserID)
		End If
	End Sub

	Sub SavePermissions()
		oConn.Execute("DELETE FROM utb_UserPermissions WHERE UserID = " & iUserID)

		Dim iIndex, arCheckedID
		arCheckedID = Split(Permissions, ", ")

		Dim arQuery
		ReDim arQuery(UBound(arCheckedID))

		For iIndex = 0 To UBound(arCheckedID)
			sQuery = "INSERT INTO utb_UserPermissions(UserID, PermissionID) VALUES(" & iUserID & ", '" & Quote(arCheckedID(iIndex)) & "')"
			arQuery(iIndex) = sQuery
		Next

		If UBound(arQuery) >= 0 Then
			oConn.Execute(Join(arQuery, vbNewLine))
		End If

		If CLng(Session("UserID")) = CLng(iUserID) Then
			Call UpdateUserPermissions(iUserID)
		End If
	End Sub
%>