<!--#include file="../inc/CommonsGlobal.asp"-->
<!--#include file="inc/CommonsBackend.asp"-->
<!--#include file="../inc/Blowfish.asp"-->
<%
	Dim iID : iID = Request("ID")
	Dim sAction : sAction = Request("Action")
	Dim sBackURL : sBackURL = GetBackURL("VendorList.asp")

	If Not ValidateInteger(iID) Then
		Redirect(sBackURL)
	End If

	If GetIndex(sAction, Array("New", "Edit", "Insert", "Update", "Delete")) = -1 Then 
		Redirect(sBackURL)
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sTitle
	Dim iVendorID, TermID, Name, Memo
	Dim BillAddress1, BillAddress2, BillCity, BillState, BillZip, BillCountry
	Dim BillContact1, BillContact2, BillPhone1, BillPhone2, BillFax1, BillFax2, BillEmail1, BillEmail2
	Dim ShipAddress1, ShipAddress2, ShipCity, ShipState, ShipZip, ShipCountry
	Dim ShipContact1, ShipContact2, ShipPhone1, ShipPhone2, ShipFax1, ShipFax2, ShipEmail1, ShipEmail2

	Select Case sAction
		Case "New"
			sTitle = "Add Vendor"
			sAction = "Insert"

		Case "Edit"
			sTitle = "Edit Vendor Ref # " & iID
			sAction = "Update"

			Set oQuery = oConn.Execute("SELECT * FROM utb_Vendors WHERE VendorID = '" & Quote(iID) & "'")
			If Not oQuery.Eof Then
				TermID	= oQuery("TermID")
				Name	= HTMLEncode(oQuery("VendorName"))
				Memo	= HTMLEncode(oQuery("VendorMemo"))

				BillAddress1	= HTMLEncode(oQuery("VendorBillingAddress1"))
				BillAddress2	= HTMLEncode(oQuery("VendorBillingAddress2"))
				BillCity		= HTMLEncode(oQuery("VendorBillingCity"))
				BillState		= HTMLEncode(oQuery("VendorBillingState"))
				BillZip			= HTMLEncode(oQuery("VendorBillingZip"))
				BillCountry		= HTMLEncode(oQuery("VendorBillingCountry"))
				BillContact1	= HTMLEncode(oQuery("VendorBillingContactName1"))
				BillContact2	= HTMLEncode(oQuery("VendorBillingContactName2"))
				BillPhone1		= HTMLEncode(oQuery("VendorBillingPhone1"))
				BillPhone2		= HTMLEncode(oQuery("VendorBillingPhone2"))
				BillFax1		= HTMLEncode(oQuery("VendorBillingFax1"))
				BillFax2		= HTMLEncode(oQuery("VendorBillingFax2"))
				BillEmail1		= HTMLEncode(oQuery("VendorBillingEmail1"))
				BillEmail2		= HTMLEncode(oQuery("VendorBillingEmail2"))

				ShipAddress1	= HTMLEncode(oQuery("VendorShippingAddress1"))
				ShipAddress2	= HTMLEncode(oQuery("VendorShippingAddress2"))
				ShipCity		= HTMLEncode(oQuery("VendorShippingCity"))
				ShipState		= HTMLEncode(oQuery("VendorShippingState"))
				ShipZip			= HTMLEncode(oQuery("VendorShippingZip"))
				ShipCountry		= HTMLEncode(oQuery("VendorShippingCountry"))
				ShipContact1	= HTMLEncode(oQuery("VendorShippingContactName1"))
				ShipContact2	= HTMLEncode(oQuery("VendorShippingContactName2"))
				ShipPhone1		= HTMLEncode(oQuery("VendorShippingPhone1"))
				ShipPhone2		= HTMLEncode(oQuery("VendorShippingPhone2"))
				ShipFax1		= HTMLEncode(oQuery("VendorShippingFax1"))
				ShipFax2		= HTMLEncode(oQuery("VendorShippingFax2"))
				ShipEmail1		= HTMLEncode(oQuery("VendorShippingEmail1"))
				ShipEmail2		= HTMLEncode(oQuery("VendorShippingEmail2"))
			End If
			oQuery.Close
			Set oQuery = Nothing

		Case "Insert"
			sTitle = "Add Vendor"

			CommonValidation()

			If GetValueFromTable(oConn, "VendorID", "utb_Vendors", "WHERE VendorName = '" & Quote(Name) & "'") <> "" Then
				AddError("Vendor with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = "INSERT INTO utb_Vendors(" &_
						 "	TermID" &_
						 ", VendorName" &_
						 ", VendorMemo" &_

						 ", VendorBillingAddress1" &_
						 ", VendorBillingAddress2" &_
						 ", VendorBillingCity" &_
						 ", VendorBillingState" &_
						 ", VendorBillingZip" &_
						 ", VendorBillingCountry" &_
						 ", VendorBillingContactName1" &_
						 ", VendorBillingContactName2" &_
						 ", VendorBillingPhone1" &_
						 ", VendorBillingPhone2" &_
						 ", VendorBillingFax1" &_
						 ", VendorBillingFax2" &_
						 ", VendorBillingEmail1" &_
						 ", VendorBillingEmail2" &_

						 ", VendorShippingAddress1" &_
						 ", VendorShippingAddress2" &_
						 ", VendorShippingCity" &_
						 ", VendorShippingState" &_
						 ", VendorShippingZip" &_
						 ", VendorShippingCountry" &_
						 ", VendorShippingContactName1" &_
						 ", VendorShippingContactName2" &_
						 ", VendorShippingPhone1" &_
						 ", VendorShippingPhone2" &_
						 ", VendorShippingFax1" &_
						 ", VendorShippingFax2" &_
						 ", VendorShippingEmail1" &_
						 ", VendorShippingEmail2" &_
						 ") " &_
						 "VALUES(" &_
						 "	 " & TermID &_
						 ", '" & Quote(Name) & "'" &_
						 ", '" & Quote(Memo) & "'" &_

						 ",  " & IIF(BillAddress1 <> "", "'" & Quote(BillAddress1) & "'", "NULL") &_
						 ",  " & IIF(BillAddress2 <> "", "'" & Quote(BillAddress2) & "'", "NULL") &_
						 ",  " & IIF(BillCity <> "", "'" & Quote(BillCity) & "'", "NULL") &_
						 ",  " & IIF(BillState <> "", "'" & Quote(BillState) & "'", "NULL") &_
						 ",  " & IIF(BillZip <> "", "'" & Quote(BillZip) & "'", "NULL") &_
						 ",  " & IIF(BillCountry <> "", "'" & Quote(BillCountry) & "'", "NULL") &_
						 ",  " & IIF(BillContact1 <> "", "'" & Quote(BillContact1) & "'", "NULL") &_
						 ",  " & IIF(BillContact2 <> "", "'" & Quote(BillContact2) & "'", "NULL") &_
						 ",  " & IIF(BillPhone1 <> "", "'" & Quote(BillPhone1) & "'", "NULL") &_
						 ",  " & IIF(BillPhone2 <> "", "'" & Quote(BillPhone2) & "'", "NULL") &_
						 ",  " & IIF(BillFax1 <> "", "'" & Quote(BillFax1) & "'", "NULL") &_
						 ",  " & IIF(BillFax2 <> "", "'" & Quote(BillFax2) & "'", "NULL") &_
						 ",  " & IIF(BillEmail1 <> "", "'" & Quote(BillEmail1) & "'", "NULL") &_
						 ",  " & IIF(BillEmail2 <> "", "'" & Quote(BillEmail2) & "'", "NULL") &_

						 ",  " & IIF(ShipAddress1 <> "", "'" & Quote(ShipAddress1) & "'", "NULL") &_
						 ",  " & IIF(ShipAddress2 <> "", "'" & Quote(ShipAddress2) & "'", "NULL") &_
						 ",  " & IIF(ShipCity <> "", "'" & Quote(ShipCity) & "'", "NULL") &_
						 ",  " & IIF(ShipState <> "", "'" & Quote(ShipState) & "'", "NULL") &_
						 ",  " & IIF(ShipZip <> "", "'" & Quote(ShipZip) & "'", "NULL") &_
						 ",  " & IIF(ShipCountry <> "", "'" & Quote(ShipCountry) & "'", "NULL") &_
						 ",  " & IIF(ShipContact1 <> "", "'" & Quote(ShipContact1) & "'", "NULL") &_
						 ",  " & IIF(ShipContact2 <> "", "'" & Quote(ShipContact2) & "'", "NULL") &_
						 ",  " & IIF(ShipPhone1 <> "", "'" & Quote(ShipPhone1) & "'", "NULL") &_
						 ",  " & IIF(ShipPhone2 <> "", "'" & Quote(ShipPhone2) & "'", "NULL") &_
						 ",  " & IIF(ShipFax1 <> "", "'" & Quote(ShipFax1) & "'", "NULL") &_
						 ",  " & IIF(ShipFax2 <> "", "'" & Quote(ShipFax2) & "'", "NULL") &_
						 ",  " & IIF(ShipEmail1 <> "", "'" & Quote(ShipEmail1) & "'", "NULL") &_
						 ",  " & IIF(ShipEmail2 <> "", "'" & Quote(ShipEmail2) & "'", "NULL") &_
						 ")"
				oConn.Execute(sQuery)

				iVendorID = GetLastID(oConn)

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Vendor has been inserted.")
					Redirect("VendorForm.asp?Action=Edit&ID=" & iVendorID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Update"
			sTitle = "Edit Vendor Ref # " & iID

			CommonValidation()

			If GetValueFromTable(oConn, "VendorID", "utb_Vendors", "WHERE VendorName = '" & Quote(Name) & "' AND VendorID <> '" & Quote(iID) & "'") <> "" Then
				AddError("Vendor with name <strong>" & Name & "</strong> already exist in database.")
			End If

			If Not IsError() Then
				oConn.BeginTrans
				On Error Resume Next

				sQuery = " UPDATE utb_Vendors" &_
						 "	  SET TermID = " & TermID &_
						 "		, VendorName = '" & Quote(Name) & "'" &_
						 "		, VendorMemo = '" & Quote(Memo) & "'" &_

						 "		, VendorBillingAddress1		= " & IIF(BillAddress1 <> "", "'" & Quote(BillAddress1) & "'", "NULL") &_
						 "		, VendorBillingAddress2		= " & IIF(BillAddress2 <> "", "'" & Quote(BillAddress2) & "'", "NULL") &_
						 "		, VendorBillingCity			= " & IIF(BillCity <> "", "'" & Quote(BillCity) & "'", "NULL") &_
						 "		, VendorBillingState		= " & IIF(BillState <> "", "'" & Quote(BillState) & "'", "NULL") &_
						 "		, VendorBillingZip			= " & IIF(BillZip <> "", "'" & Quote(BillZip) & "'", "NULL") &_
						 "		, VendorBillingCountry		= " & IIF(BillCountry <> "", "'" & Quote(BillCountry) & "'", "NULL") &_
						 "		, VendorBillingContactName1	= " & IIF(BillContact1 <> "", "'" & Quote(BillContact1) & "'", "NULL") &_
						 "		, VendorBillingContactName2	= " & IIF(BillContact2 <> "", "'" & Quote(BillContact2) & "'", "NULL") &_
						 "		, VendorBillingPhone1		= " & IIF(BillPhone1 <> "", "'" & Quote(BillPhone1) & "'", "NULL") &_
						 "		, VendorBillingPhone2		= " & IIF(BillPhone2 <> "", "'" & Quote(BillPhone2) & "'", "NULL") &_
						 "		, VendorBillingFax1			= " & IIF(BillFax1 <> "", "'" & Quote(BillFax1) & "'", "NULL") &_
						 "		, VendorBillingFax2			= " & IIF(BillFax2 <> "", "'" & Quote(BillFax2) & "'", "NULL") &_
						 "		, VendorBillingEmail1		= " & IIF(BillEmail1 <> "", "'" & Quote(BillEmail1) & "'", "NULL") &_
						 "		, VendorBillingEmail2		= " & IIF(BillEmail2 <> "", "'" & Quote(BillEmail2) & "'", "NULL") &_

						 "		, VendorShippingAddress1	= " & IIF(ShipAddress1 <> "", "'" & Quote(ShipAddress1) & "'", "NULL") &_
						 "		, VendorShippingAddress2	= " & IIF(ShipAddress2 <> "", "'" & Quote(ShipAddress2) & "'", "NULL") &_
						 "		, VendorShippingCity		= " & IIF(ShipCity <> "", "'" & Quote(ShipCity) & "'", "NULL") &_
						 "		, VendorShippingState		= " & IIF(ShipState <> "", "'" & Quote(ShipState) & "'", "NULL") &_
						 "		, VendorShippingZip			= " & IIF(ShipZip <> "", "'" & Quote(ShipZip) & "'", "NULL") &_
						 "		, VendorShippingCountry		= " & IIF(ShipCountry <> "", "'" & Quote(ShipCountry) & "'", "NULL") &_
						 "		, VendorShippingContactName1= " & IIF(ShipContact1 <> "", "'" & Quote(ShipContact1) & "'", "NULL") &_
						 "		, VendorShippingContactName2= " & IIF(ShipContact2 <> "", "'" & Quote(ShipContact2) & "'", "NULL") &_
						 "		, VendorShippingPhone1		= " & IIF(ShipPhone1 <> "", "'" & Quote(ShipPhone1) & "'", "NULL") &_
						 "		, VendorShippingPhone2		= " & IIF(ShipPhone2 <> "", "'" & Quote(ShipPhone2) & "'", "NULL") &_
						 "		, VendorShippingFax1		= " & IIF(ShipFax1 <> "", "'" & Quote(ShipFax1) & "'", "NULL") &_
						 "		, VendorShippingFax2		= " & IIF(ShipFax2 <> "", "'" & Quote(ShipFax2) & "'", "NULL") &_
						 "		, VendorShippingEmail1		= " & IIF(ShipEmail1 <> "", "'" & Quote(ShipEmail1) & "'", "NULL") &_
						 "		, VendorShippingEmail2		= " & IIF(ShipEmail2 <> "", "'" & Quote(ShipEmail2) & "'", "NULL") &_
						 "  WHERE VendorID = " & iID
				oConn.Execute(sQuery)

				iVendorID = iID

				If Err.Number = 0 Then
					oConn.CommitTrans
					Call SetAlertMessage("success", "Vendor has been updated.")
					Redirect("VendorForm.asp?Action=Edit&ID=" & iVendorID)
				Else
					oConn.RollbackTrans
					AddError(Err.Description)
				End If
			End If

		Case "Delete"
			oConn.BeginTrans
			On Error Resume Next

			sQuery = " DELETE " &_
					 "	 FROM utb_Vendors " &_
					 "	WHERE VendorID = '" & Quote(iID) & "'"
			oConn.Execute(sQuery)

			If Err.Number = 0 Then
				oConn.CommitTrans
				Call SetAlertMessage("success", "Vendor has been deleted.")
				Redirect(sBackURL)
			Else
				oConn.RollbackTrans
				Call SetAlertMessage("error", Err.Description)
				Redirect(sBackURL)
			End If
	End Select
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title><%= sPageTitle %></title>
		<meta name="Description" content="<%= sPageDescription %>"/>
		<meta name="Keywords" content="<%= sPageKeywords %>"/>
		<!--#include file="inc/HeaderBackend.asp"-->
	</head>
	<body>
		<!--#include file="inc/TopBackend.asp"-->
		<div class="box-head">
			<a class="head-link-right" href="<%= sBackURL %>"> &laquo; Back</a>
			<h1>Vendors</h1>
			&nbsp;
		</div>
		<!--#include file="../inc/Alert.asp"-->
		<div class="box-head"><h2><%= sTitle %></h2></div>
		<div class="box">
			<form action="VendorForm.asp" method="post">
				<input type="hidden" name="Action" value="<%= sAction %>"/>
				<input type="hidden" name="ID" value="<%= iID %>"/>
				<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td colspan="2">
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td style="text-align: right" width="110"><label for="TermID"><span class="asterisk">*</span> Terms</label></td>
									<td>
										<select class="selector" name="TermID" id="TermID" style="width: auto">
											<option value="">Select One</option>
										<%
										Set oQuery = oConn.Execute("SELECT * FROM utb_Terms ORDER BY TermName")
										While Not oQuery.Eof
											%>
											<option value="<%= oQuery("TermID") %>"<%= IIF(CStr(oQuery("TermID")) = CStr(TermID), " selected='selected'", "") %>><%= oQuery("TermName") %></option>
											<%
											oQuery.MoveNext
										Wend
										oQuery.Close
										Set oQuery = Nothing
										%>
										</select>
									</td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="Name"><span class="asterisk">*</span> Vendor Name</label></td>
									<td><input type="text" class="form-field" name="Name" id="Name" value="<%= Name %>" style="width: 300px" maxlength="100"/></td>
								</tr>
							</table>
							<br/>
						</td>
					</tr>
					<tr valign="top">
						<td width="50%">
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td width="110" style="text-align: right"><strong>Billing Information</strong></td>
									<td colspan="3">&nbsp;</td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillAddress1">Address 1:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillAddress1" id="BillAddress1" value="<%= BillAddress1 %>" style="width: 300px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillAddress2">Address 2:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillAddress2" id="BillAddress2" value="<%= BillAddress2 %>" style="width: 187px" maxlength="100"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillCity">City:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillCity" id="BillCity" value="<%= BillCity %>" style="width: 187px" maxlength="100"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillState">State:</label></td>
									<td colspan="3" style="height: 31px"><div id="bill_state"><img src="images/ae.gif" alt=""/></div></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillZip">Zip:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillZip" id="BillZip" value="<%= BillZip %>" style="width: 100px" maxlength="50"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillCountry">Country:</label></td>
									<td colspan="3">
										<select class="selector" id="BillCountry" name="BillCountry" style="width: 201px" onchange="changeCountry('Bill')">
											<option value="">Select One</option>
										<%
										Set oQuery = oConn.Execute("SELECT * FROM utb_Countries WHERE CountryIsActiveBilling = 1 ORDER BY CountrySortOrder, CountryName")
										While Not oQuery.Eof
											%>
											<option value="<%= oQuery("CountryCode") %>"<%= IIF(CStr(oQuery("CountryCode")) = CStr(IIF(IsNull(BillCountry), "", BillCountry)), " selected='selected'", "") %>><%= oQuery("CountryName") %></option>
											<%
											oQuery.MoveNext
										Wend
										oQuery.Close
										Set oQuery = Nothing
										%>
										</select>
									</td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillContact1">Contact Name 1:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillContact1" id="BillContact1" value="<%= BillContact1 %>" style="width: 187px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillContact2">Contact Name 2:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillContact2" id="BillContact2" value="<%= BillContact2 %>" style="width: 187px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillPhone1">Phone 1:</label></td>
									<td><input type="text" class="form-field" name="BillPhone1" id="BillPhone1" value="<%= BillPhone1 %>" style="width: 100px" maxlength="20"/></td>
									<td style="text-align: right"><label for="BillPhone2">Phone 2:</label></td>
									<td style="text-align: right; width: 115px"><input type="text" class="form-field" name="BillPhone2" id="BillPhone2" value="<%= BillPhone2 %>" style="width: 100px" maxlength="20"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillFax1">Fax 1:</label></td>
									<td><input type="text" class="form-field" name="BillFax1" id="BillFax1" value="<%= BillFax1 %>" style="width: 100px" maxlength="20"/></td>
									<td style="text-align: right"><label for="BillFax2">Fax 2:</label></td>
									<td style="text-align: right; width: 115px"><input type="text" class="form-field" name="BillFax2" id="BillFax2" value="<%= BillFax2 %>" style="width: 100px" maxlength="20"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillEmail1">Email 1:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillEmail1" id="BillEmail1" value="<%= BillEmail1 %>" style="width: 300px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="BillEmail2">Email 2:</label></td>
									<td colspan="3"><input type="text" class="form-field" name="BillEmail2" id="BillEmail2" value="<%= BillEmail2 %>" style="width: 300px" maxlength="255"/></td>
								</tr>
							</table>
						</td>
						<td>
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td width="120"><strong>Shipping Information</strong></td>
									<td colspan="4">
										<input type="checkbox" name="shipTheSame" id="shipTheSame" value="1"<%= IIF(Request("shipTheSame") = "1", " checked='checked'", "") %>/>
										<label for="shipTheSame">Check here if Shipping is the same as Billing Info</label>
									</td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipAddress1">Address 1:</label></td>
									<td colspan="4"><input type="text" class="form-field" name="ShipAddress1" id="ShipAddress1" value="<%= ShipAddress1 %>" style="width: 300px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipAddress2">Address 2:</label></td>
									<td colspan="4"><input type="text" class="form-field" name="ShipAddress2" id="ShipAddress2" value="<%= ShipAddress2 %>" style="width: 187px" maxlength="100"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipCity">City:</label></td>
									<td colspan="4"><input type="text" class="form-field" name="ShipCity" id="ShipCity" value="<%= ShipCity %>" style="width: 187px" maxlength="100"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipState">State:</label></td>
									<td colspan="4" style="height: 31px"><div id="ship_state"><img src="images/ae.gif" alt=""/></div></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipZip">Zip:</label></td>
									<td colspan="4"><input type="text" class="form-field" name="ShipZip" id="ShipZip" value="<%= ShipZip %>" style="width: 100px" maxlength="50"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipCountry">Country:</label></td>
									<td colspan="4">
										<select class="selector" id="ShipCountry" name="ShipCountry" style="width: 201px" onchange="changeCountry('Ship')">
											<option value="">Select One</option>
										<%
										Set oQuery = oConn.Execute("SELECT * FROM utb_Countries WHERE CountryIsActiveShipping = 1 ORDER BY CountrySortOrder, CountryName")
										While Not oQuery.Eof
											%>
											<option value="<%= oQuery("CountryCode") %>"<%= IIF(CStr(oQuery("CountryCode")) = CStr(IIF(IsNull(ShipCountry), "", ShipCountry)), " selected='selected'", "") %>><%= oQuery("CountryName") %></option>
											<%
											oQuery.MoveNext
										Wend
										oQuery.Close
										Set oQuery = Nothing
										%>
										</select>
									</td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipContact1">Contact Name 1:</td>
									<td colspan="4"><input type="text" class="form-field" name="ShipContact1" id="ShipContact1" value="<%= ShipContact1 %>" style="width: 187px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipContact2">Contact Name 2:</label></td>
									<td colspan="4"><input type="text" class="form-field" name="ShipContact2" id="ShipContact2" value="<%= ShipContact2 %>" style="width: 187px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipPhone1">Phone 1:</label></td>
									<td><input type="text" class="form-field" name="ShipPhone1" id="ShipPhone1" value="<%= ShipPhone1 %>" style="width: 100px" maxlength="20"/></td>
									<td>&nbsp;</td>
									<td style="text-align: right"><label for="ShipPhone2">Phone 2:</label></td>
									<td><input type="text" class="form-field" name="ShipPhone2" id="ShipPhone2" value="<%= ShipPhone2 %>" style="width: 100px" maxlength="20"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipFax1">Fax 1:</label></td>
									<td><input type="text" class="form-field" name="ShipFax1" id="ShipFax1" value="<%= ShipFax1 %>" style="width: 100px" maxlength="20"/></td>
									<td>&nbsp;</td>
									<td style="text-align: right"><label for="ShipFax2">Fax 2:</label></td>
									<td><input type="text" class="form-field" name="ShipFax2" id="ShipFax2" value="<%= ShipFax2 %>" style="width: 100px" maxlength="20"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipEmail1">Email 1:</label></td>
									<td colspan="4"><input type="text" class="form-field" name="ShipEmail1" id="ShipEmail1" value="<%= ShipEmail1 %>" style="width: 300px" maxlength="255"/></td>
								</tr>
								<tr>
									<td style="text-align: right"><label for="ShipEmail2">Email 2:</label></td>
									<td colspan="4"><input type="text" class="form-field" name="ShipEmail2" id="ShipEmail2" value="<%= ShipEmail2 %>" style="width: 300px" maxlength="255"/></td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<br/>
							<table cellpadding="0" cellspacing="0" border="0" class="form-cells">
								<tr>
									<td width="110">&nbsp;</td>
									<td>
										<input type="submit" class="form-btn" value="Save"/>
										<input type="reset" class="form-btn" value="Reset"/>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</form>
		</div>
		<!--#include file="inc/BottomBackend.asp"-->
		<script type="text/javascript">
		//<![CDATA[
		var copyFields = new Array('Address1', 'Address2', 'City', 'State', 'Zip', 'Country', 'Contact1', 'Contact2', 'Phone1', 'Phone2', 'Fax1', 'Fax2', 'Email1', 'Email2');

		function changeCountry(type, stateType, callback) {
			var argNum = arguments.length;
			var stType = argNum == 3 ? stateType : type;

			$('#' + stType.toLowerCase() + '_state').html('<img src="images/ae.gif" alt=""/>');
			$.ajax({
				url: 'ajax/GetStates.asp',
				type: 'POST',
				dataType: 'text',
				async: false,
				data: {CountryID: $('#' + type + 'Country').val()},
				success: function(response) {
					if (response != '') {
						var buffer = '';
						var rows = response.split('\n');

						for (var i = 0; i < rows.length; i++) {
							if (rows[i] != '') {
								var columns = rows[i].split('|');
								buffer += '<option value="' + columns[0] + '" ' + (columns[0] == (stType == 'Bill' ? '<%= BillState %>' : '<%= ShipState %>') ? 'selected="selected"' : '') + '>' + columns[1] + '</option>'
							}
						}

						$('#' + stType.toLowerCase() + '_state').html('<select class="selector" name="' + stType + 'State" id="' + stType + 'State" style="width: 201px"><option value="">Select One</option>' + buffer + '</select>');
					}
					else {
						$('#' + stType.toLowerCase() + '_state').html('<input type="text" class="form-field" name="' + stType + 'State" id="' + stType + 'State" value="' + (stType == 'Bill' ? '<%= BillState %>' : '<%= ShipState %>') + '" style="width: 187px" maxlength="50">');
					}
					if (argNum == 3 && typeof callback == 'function') {
						callback();
					}
				}
			});
		}

		$(function(){
			changeCountry('Bill');
			changeCountry('Ship');

			$('#shipTheSame').click(function(){
				if ($(this).is(':checked')) {
					changeCountry('Bill', 'Ship', function(){
						$.each(copyFields, function(i, field){
							$('#Ship'+field).val($('#Bill'+field).val());
						});
					});
				}
				else {
					changeCountry('Bill', 'Ship', function(){
						$.each(copyFields, function(i, field){
							$('#Ship'+field).val('');
						});
					});
				}
			});
		});
		//]]>
		</script>
	</body>
</html>
<%
	Sub CommonValidation()
		TermID = Trim(Request("TermID"))
		Name = Trim(Request("Name"))
		Memo = Trim(Request("Memo"))

		BillAddress1	= Trim(Request("BillAddress1"))
		BillAddress2	= Trim(Request("BillAddress2"))
		BillCity		= Trim(Request("BillCity"))
		BillState		= Trim(Request("BillState"))
		BillZip			= Trim(Request("BillZip"))
		BillCountry		= Trim(Request("BillCountry"))
		BillContact1	= Trim(Request("BillContact1"))
		BillContact2	= Trim(Request("BillContact2"))
		BillPhone1		= Trim(Request("BillPhone1"))
		BillPhone2		= Trim(Request("BillPhone2"))
		BillFax1		= Trim(Request("BillFax1"))
		BillFax2		= Trim(Request("BillFax2"))
		BillEmail1		= Trim(Request("BillEmail1"))
		BillEmail2		= Trim(Request("BillEmail2"))

		ShipAddress1	= Trim(Request("ShipAddress1"))
		ShipAddress2	= Trim(Request("ShipAddress2"))
		ShipCity		= Trim(Request("ShipCity"))
		ShipState		= Trim(Request("ShipState"))
		ShipZip			= Trim(Request("ShipZip"))
		ShipCountry		= Trim(Request("ShipCountry"))
		ShipContact1	= Trim(Request("ShipContact1"))
		ShipContact2	= Trim(Request("ShipContact2"))
		ShipPhone1		= Trim(Request("ShipPhone1"))
		ShipPhone2		= Trim(Request("ShipPhone2"))
		ShipFax1		= Trim(Request("ShipFax1"))
		ShipFax2		= Trim(Request("ShipFax2"))
		ShipEmail1		= Trim(Request("ShipEmail1"))
		ShipEmail2		= Trim(Request("ShipEmail2"))

		If TermID = "" Then
			AddError("Field <strong>Terms</strong> is required.")
		End If
		If Name = "" Then
			AddError("Field <strong>Vendor Name</strong> is required.")
		End If
		If BillEmail1 <> "" And Not ValidateEmail(BillEmail1) Then
			AddError("Field <strong>Billing Email 1</strong> is invalid.")
		End If
		If BillEmail2 <> "" And Not ValidateEmail(BillEmail2) Then
			AddError("Field <strong>Billing Email 2</strong> is invalid.")
		End If
		If ShipEmail1 <> "" And Not ValidateEmail(ShipEmail1) Then
			AddError("Field <strong>Shipping Email 1</strong> is invalid.")
		End If
		If ShipEmail2 <> "" And Not ValidateEmail(ShipEmail2) Then
			AddError("Field <strong>Shipping Email 2</strong> is invalid.")
		End If
	End Sub
%>