<!--#include file="../../inc/CommonsGlobal.asp"-->
<!--#include file="../inc/CommonsBackend.asp"-->
<!--#include file="../../inc/JSON.asp"-->
<%
	Dim jsonOut
	Set jsonOut = jsObject()
	jsonOut("success") = False

	If isAjaxFailed Then
		jsonOut("redirect") = sRedirectTo
		jsonOut.Flush
		Response.End
	End If

	Dim iID : iID = Request("ID")
	If Not ValidateInteger(iID) Then
		jsonOut("message") = "Invalid ID"
		jsonOut.Flush
		Response.End
	End If

	Dim sType : sType = Request("Type")
	If sType <> "Manufacturer" And sType <> "Category" Then
		jsonOut("message") = "Invalid Type"
		jsonOut.Flush
		Response.End
	End If

	On Error Resume Next
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	oConn.BeginTrans

	Dim sImagePath, sImageName
	Select Case sType
		Case "Manufacturer"
			sImagePath = C_MANUFACTURER_IMAGE_PATH
			sImageName = GetValueFromTable(oConn, "ManufacturerImage", "utb_Manufacturers", "WHERE ManufacturerID = " & iID)
			oConn.Execute("UPDATE utb_Manufacturers SET ManufacturerImage = NULL WHERE ManufacturerID = " & iID)

		Case "Category"
			sImagePath = C_CATEGORY_IMAGE_PATH
			sImageName = GetValueFromTable(oConn, "CategoryImage", "utb_Categories", "WHERE CategoryID = " & iID)
			oConn.Execute("UPDATE utb_Categories SET CategoryImage = NULL WHERE CategoryID = " & iID)
	End Select

	If Err.Number = 0 Then
		If sImageName <> "" Then
			Call DeleteFile(Server.MapPath("../" & sImagePath) & "/" & sImageName)
		End If

		oConn.CommitTrans
		jsonOut("success") = True
		jsonOut("src") = C_NO_IMAGE_SMALL
	Else
		oConn.RollbackTrans
		jsonOut("message") = Err.Description
	End If

	oConn.Close
	Set oConn = Nothing

	jsonOut.Flush
%>