<!--#include file="../../inc/CommonsGlobal.asp"-->
<!--#include file="../inc/CommonsBackend.asp"-->
<!--#include file="../../inc/JSON.asp"-->
<!--#include file="../../inc/Blowfish.asp"-->
<%
	Dim jsonOut
	Set jsonOut = jsObject()
	jsonOut("success") = False

	If isAjaxFailed Then
		jsonOut("redirect") = sRedirectTo
		jsonOut.Flush
		Response.End
	End If

	Dim iOrderID : iOrderID = Request("OrderID")
	If Not ValidateInteger(iOrderID) Then
		jsonOut("message") = "Invalid OrderID"
		jsonOut.Flush
		Response.End
	End If

	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sNewValue
	Dim sFieldKey : sFieldKey = Trim(Request("FieldKey"))
	Dim sFieldVal : sFieldVal = Trim(Request("FieldVal"))
	Select Case sFieldKey
		Case "refferal_code"
			sNewValue = Left(sFieldVal, 50)
			sQuery = "UPDATE utb_Orders" &_
					 "	 SET OrderReferralCode = '" & Quote(sNewValue) & "'" &_
					 " WHERE OrderID = " & iOrderID

		Case "shipping_carrier"
			sNewValue = GetValueFromTable(oConn, "OrderDeliveryCarrierName", "utb_OrderDeliveryCarriers", "WHERE OrderDeliveryCarrierID = " & sFieldVal)
			If IsNull(sNewValue) Then
				sNewValue = ""
			End If

			Dim ssErrors, cMethod, tNumber, shiCost
			cMethod = Left(Trim(Request("cMethod")), 100)
			tNumber = Left(Trim(Request("tNumber")), 50)
			shiCost = Trim(Replace(Request("shiCost"), ",", ""))

			If cMethod = "" Then
				ssErrors = ssErrors & "     Field 'Carrier Method' is required." & VbNewLine
			End If
			If tNumber = "" Then
				ssErrors = ssErrors & "     Field 'Tracking Number' is required." & VbNewLine
			End If
			If shiCost = "" Then
				ssErrors = ssErrors & "     Field 'Cost' is required." & VbNewLine
			ElseIf Not ValidateDecimal(shiCost) Then
				ssErrors = ssErrors & "     Field 'Cost' is invalid." & VbNewLine
			End If

			If sNewValue <> "" Then
				If ssErrors = "" Then
					sQuery = " UPDATE utb_Orders" &_
							 "	  SET OrderDeliveryCarrierID = '" & Quote(sFieldVal) & "'" &_
							 "	   	, OrderDeliveryCarrierMethod = '" & Quote(cMethod) & "'" &_
							 "	   	, OrderDeliveryTracking = '" & Quote(tNumber) & "'" &_
							 "	   	, OrderDeliveryCost = '" & Quote(shiCost) & "'" &_
							 "	WHERE OrderID = " & iOrderID

					jsonOut("cMethod") = cMethod
					jsonOut("tNumber") = tNumber
					jsonOut("shiCost") = CurrencyFormat(shiCost, 2)
				Else
					jsonOut("message") = ssErrors
					jsonOut.Flush
					Response.End
				End If
			Else
				sQuery = " UPDATE utb_Orders" &_
						 "	  SET OrderDeliveryCarrierID = NULL" &_
						 "		, OrderDeliveryCarrierMethod = NULL" &_
						 "		, OrderDeliveryTracking = NULL" &_
						 "		, OrderDeliveryCost = 0" &_
						 "	WHERE OrderID = " & iOrderID

				jsonOut("cMethod") = ""
				jsonOut("tNumber") = ""
				jsonOut("shiCost") = CurrencyFormat(0, 2)
			End If

		Case "salesman"
			If Not CheckUserPermission(4) Then
				jsonOut("message") = "You are not allowed to assign Salesman"
				jsonOut.Flush
				Response.End
			ElseIf Not ValidateInteger(sFieldVal) Then
				jsonOut("message") = "Invalid User ID"
				jsonOut.Flush
				Response.End
			Else
				sQuery = " UPDATE utb_Orders" &_
						 "	  SET SalesmanUserID = " & sFieldVal &_
						 "	WHERE OrderID = " & iOrderID

				sNewValue = GetValueFromTable(oConn, "UserNickName", "utb_Users", "WHERE UserID = " & sFieldVal)
				If IsNull(sNewValue) Then
					sNewValue = ""
				End If
			End If
	End Select

	If sQuery <> "" Then
		On Error Resume Next
		oConn.BeginTrans
		oConn.Execute(sQuery)

		If Err.Number = 0 Then
			oConn.CommitTrans
			jsonOut("success") = True
			jsonOut("newvalu") = sNewValue
		Else
			oConn.RollbackTrans
			jsonOut("message") = Err.Description
		End If
	Else
		jsonOut("message") = "Invalid Field Key"
	End If
	oConn.Close
	Set oConn = Nothing

	jsonOut.Flush
%>