<!--#include file="../../inc/CommonsGlobal.asp"-->
<!--#include file="../inc/CommonsBackend.asp"-->
<!--#include file="../../inc/JSON.asp"-->
<!--#include file="../../inc/Blowfish.asp"-->
<%
	Dim jsonOut
	Set jsonOut = jsObject()
	jsonOut("success") = False

	If isAjaxFailed Then
		jsonOut("redirect") = sRedirectTo
		jsonOut.Flush
		Response.End
	End If

	Dim iOrderID : iOrderID = Request("OrderID")
	If Not ValidateInteger(iOrderID) Then
		jsonOut("message") = "Invalid OrderID"
		jsonOut.Flush
		Response.End
	End If

	Dim iStatusID : iStatusID = Request("StatusID")
	If Not ValidateInteger(iStatusID) Then
		jsonOut("message") = "Invalid StatusID"
		jsonOut.Flush
		Response.End
	End If

	On Error Resume Next
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	Dim sReasonName : sReasonName = GetValueFromTable(oConn, "OrderStatusReasonName", "utb_OrderStatusReasons", "WHERE OrderStatusReasonID = '" & Quote(Request("ReasonID")) & "'")
	If IsNull(sReasonName) Then
		sReasonName = ""
	End If
	
	Dim sOrderStatusName
	Set oQuery = oConn.Execute("SELECT OrderStatusName FROM utb_OrderStatuses WHERE OrderStatusID = " & iStatusID)
	If Not oQuery.Eof Then
		sOrderStatusName	= oQuery("OrderStatusName")
	Else
		jsonOut("message") = "Status not exists"
		jsonOut.Flush
		Response.End
	End If
	oQuery.Close
	Set oQuery = Nothing

	oConn.BeginTrans
	sQuery = "UPDATE utb_Orders" &_
			 "	 SET OrderStatusID = " & iStatusID &_
			 "	   , OrderStatusReasonID = " & IIF(Request("ReasonID") <> "", "'" & Quote(Request("ReasonID")) & "'", "NULL") &_
			 "	   , OrderShippedDate = " & IIF(iStatusID = 10, "GETDATE()", "NULL") &_
			 " WHERE OrderID = " & iOrderID
	oConn.Execute(sQuery)

	sQuery = "INSERT INTO utb_OrderStatusChanges(" &_
			 "	OrderID" &_
			 ", UserName" &_
			 ", StatusName" &_
			 ", StatusReasonName" &_
			 ") " &_
			 "VALUES(" &_
			 "	 " & iOrderID &_
			 ", '" & Session("UserNickName") & "'" &_
			 ", '" & Quote(sOrderStatusName) & "'" &_
			 ", '" & Quote(sReasonName) & "'" &_
			 ")"
	oConn.Execute(sQuery)

	If CStr(Request("SendEmail")) = "1" Then
		Dim sOrderEmail : sOrderEmail = GetValueFromTable(oConn, "OrderEmail", "utb_Orders", "WHERE OrderID = " & iOrderID)
		If CStr(sOrderEmail) <> "" Then
			Dim arOrderSt : arOrderSt = GetOrderStatusMessage(iOrderID)
			Call SendEmail(sOrderEmail, GetSetting(oConn, "CompanyEmailForOrder"), arOrderSt(0), arOrderSt(1))
		End If
	End If

	If Err.Number = 0 Then
		oConn.CommitTrans

		jsonOut("success") = True
		jsonOut("reason") = sReasonName

		sQuery = "SELECT c.*" &_
				 "	   , s.OrderStatusName" &_
				 "	   , s.OrderStatusColor" &_
				 "	   , CONVERT(VARCHAR(10), c.OrderStatusChangeCreateDate, 101) + '&nbsp;'" &_
				 "		  + RIGHT(CONVERT(VARCHAR(20), c.OrderStatusChangeCreateDate, 109), 8) + '&nbsp;'" &_
				 "		  + RIGHT(CONVERT(VARCHAR(26), c.OrderStatusChangeCreateDate, 100), 2) AS _OrderStatusChangeCreateDate" &_
				 "	FROM utb_OrderStatusChanges AS c" &_
				 "		 INNER JOIN utb_OrderStatuses AS s ON s.OrderStatusName = c.StatusName" &_
				 " WHERE c.OrderStatusChangeID = " & GetLastID(oConn)
		Set oQuery = oConn.Execute(sQuery)

		Set jsonOut("statuses") = jsObject()
		jsonOut("statuses")("id") = oQuery("OrderStatusChangeID")
		jsonOut("statuses")("user") = oQuery("UserName")
		jsonOut("statuses")("date") = oQuery("_OrderStatusChangeCreateDate")
		jsonOut("statuses")("status") = oQuery("OrderStatusName")
		jsonOut("statuses")("reason") = oQuery("StatusReasonName")
		jsonOut("statuses")("color") = oQuery("OrderStatusColor")

		oQuery.Close
		Set oQuery = Nothing
	Else
		oConn.RollbackTrans
		jsonOut("message") = Err.Description
	End If

	oConn.Close
	Set oConn = Nothing

	jsonOut.Flush
%>