<!--#include file="../../inc/CommonsGlobal.asp"-->
<!--#include file="../inc/CommonsBackend.asp"-->
<!--#include file="../../inc/JSON.asp"-->
<!--#include file="../../inc/Upload.asp"-->
<%
	Dim jsonOut
	Set jsonOut = jsObject()
	jsonOut("success") = False

	Dim oUploader
	Set oUploader = New FileUploader
	oUploader.Upload()

	If isAjaxFailed Then
		jsonOut("redirect") = sRedirectTo
		jsonOut.Flush
		Response.End
	End If

	Dim iID : iID = oUploader.Form("ID")
	If Not ValidateInteger(iID) Then
		jsonOut("message") = "Invalid ID"
		jsonOut.Flush
		Response.End
	End If

	Dim sType : sType = oUploader.Form("Type")
	If sType <> "Manufacturer" And sType <> "Category" Then
		jsonOut("message") = "Invalid Type"
		jsonOut.Flush
		Response.End
	End If

	On Error Resume Next
	Dim oConn, sQuery, oQuery
	Set oConn = Server.CreateObject("ADODB.Connection")
	oConn.Open C_CONNECTION_STRING

	oConn.BeginTrans

	Dim sImagePath, iImageWidth, iImageHeight, sQueryImage
	Select Case sType
		Case "Manufacturer"
			sImagePath = C_MANUFACTURER_IMAGE_PATH
			iImageWidth = C_MANUFACTURER_IMAGE_WIDTH
			iImageHeight = C_MANUFACTURER_IMAGE_HEIGHT

			sQuery = "SELECT ManufacturerName AS Name, ManufacturerImage AS Image FROM utb_Manufacturers WHERE ManufacturerID = " & iID
			sQueryImage = "UPDATE utb_Manufacturers SET ManufacturerImage = '%FileName%' WHERE ManufacturerID = " & iID

		Case "Category"
			sImagePath = C_CATEGORY_IMAGE_PATH
			iImageWidth = C_CATEGORY_IMAGE_WIDTH
			iImageHeight = C_CATEGORY_IMAGE_HEIGHT

			sQuery = "SELECT CategoryName AS Name, CategoryImage AS Image FROM utb_Categories WHERE CategoryID = " & iID
			sQueryImage = "UPDATE utb_Categories SET CategoryImage = '%FileName%' WHERE CategoryID = " & iID
	End Select

	Dim sImageName, sItemName
	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		sImageName = oQuery("Image")
		sItemName = oQuery("Name")
	End If
	oQuery.Close
	Set oQuery = Nothing

	Dim oFile : Set oFile = oUploader.Files.Item("File") 
	Dim sFileName : sFileName = MakeFileName(sItemName, GetFileExtension(oFile.FileName), iID)

	sQueryImage = Replace(sQueryImage, "%FileName%", Quote(sFileName))
	oConn.Execute(sQueryImage)

	If Err.Number = 0 Then
		Call SaveImage(Server.MapPath("../" & sImagePath) & "/" & sFileName, oFile.FileData, iImageWidth, iImageHeight)

		If Err.Number = 0 Then
			If sImageName <> sFileName Then
				Call DeleteFile(Server.MapPath("../" & sImagePath) & "/" & sImageName)
			End If

			oConn.CommitTrans
			jsonOut("success") = True
			jsonOut("src") = sImagePath & "/" & sFileName
		Else
			oConn.RollbackTrans
			jsonOut("message") = Err.Description
		End If
	Else
		oConn.RollbackTrans
		jsonOut("message") = Err.Description
	End If

	oConn.Close
	Set oConn = Nothing

	jsonOut.Flush
%>