<%
	Public Const SALESMAN_ROLE_ID = 2

	Dim sRedirectTo : sRedirectTo = Null
	Dim isAjaxFailed : isAjaxFailed = False
	Dim sFiles : sFiles = ""

	' Check that we are secure
	If (Request.ServerVariables("SERVER_PORT") <> "443") Then
		Dim sSecureUrl : sSecureUrl = C_DOMAIN_PATH_SECURE
		If InStr(Request.ServerVariables("URL"), "/webadmin") > 1 Then
			sSecureUrl = sSecureUrl & Mid(Request.ServerVariables("URL"), InStr(Request.ServerVariables("URL"), "/webadmin"))
		Else
			sSecureUrl = sSecureUrl & Request.ServerVariables("URL")
		End If
		sRedirectTo = sSecureUrl & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End If

	' Check that we are logged in
	If GetFileName() <> "Login.asp" And GetFileName() <> "ForgotPassword.asp" Then
		If Not CheckAdminAccess() Then
			Dim sBack
			If IsNull(sRedirectTo) Then
				sBack = "?back=" & URLEncode(Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, ""))
			End If
			sRedirectTo = "Login.asp" & sBack
		End If
	End If

	If Not IsNull(sRedirectTo) Then
		If Request.ServerVariables("HTTP_X_REQUESTED_WITH") <> "XMLHttpRequest" Then
			Redirect(sRedirectTo)
		Else
			isAjaxFailed = True
		End If
	End If

	sPageTitle = sPageTitle & " - Administration Panel"

	' Permissions checking
	Dim iPermID
	Select Case GetFileName()
		Case "UserList.asp"						iPermID = 1
		Case "UserForm.asp"						iPermID = 1
		Case "RoleList.asp"						iPermID = 1
		Case "RoleForm.asp"						iPermID = 1
		Case "PermissionList.asp"				iPermID = 1
		Case "PermissionForm.asp"				iPermID = 1
		Case "ReportCCDailySummaryCharges.asp"	iPermID = 7
		Case Else					iPermID = 0
	End Select
	If iPermID > 0 Then
		If Not CheckUserPermission(iPermID) Then
			%><!--#include file="PermissionDenied.asp"--><%
			Response.End
		End If
	End If

	Sub SetBackURL()
		Session("BackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
	End Sub

	Function GetBackURL(sDefaultURL)
		GetBackURL = IIF(Session("BackURL") = "", sDefaultURL, Session("BackURL"))
	End Function

	Function TreeLevelOffset(iLevel, iMultiply, sOffsetChar)
		Dim i, sValue

		For i = 0 To iLevel * iMultiply - 1
			sValue = sValue + sOffsetChar
		Next

		TreeLevelOffset = sValue
	End Function

	Function MakeFileName(ByVal sName, sExt, iID)
		sName = LCase(sName)
		sName = Replace(sName, " ", "_")
		sName = Replace(sName, "\", "_")
		sName = Replace(sName, "/", "_")
		sName = Replace(sName, ":", "_")
		sName = Replace(sName, "*", "_")
		sName = Replace(sName, "?", "_")
		sName = Replace(sName, """", "_")
		sName = Replace(sName, "<", "_")
		sName = Replace(sName, ">", "_")
		sName = Replace(sName, "|", "_")
		sName = Replace(sName, ".", "_")
		sName = Replace(sName, "[", "_")
		sName = Replace(sName, "]", "_")
		sName = Replace(sName, "{", "_")
		sName = Replace(sName, "}", "_")
		sName = Replace(sName, ";", "_")
		sName = Replace(sName, "=", "_")
		sName = Replace(sName, ",", "_")
		sName = Replace(sName, "(", "_")
		sName = Replace(sName, ")", "_")
		sName = Replace(sName, "'", "_")
		sName = Replace(sName, "~", "_")
		sName = Replace(sName, "!", "_")
		sName = Replace(sName, "@", "_")
		sName = Replace(sName, "", "_")
		sName = Replace(sName, "", "_")
		sName = Replace(sName, "", "_")
		sName = Replace(sName, "#", "_")
		sName = Replace(sName, "$", "_")
		sName = Replace(sName, "%", "_")
		sName = Replace(sName, "^", "_")
		sName = Replace(sName, "&", "_")
		sName = Replace(sName, "+", "_")
		sName = ReplaceEx(sName, "__", "_")

		sName = Mid(sName, 1, C_FILENAME_LENGTH)
		sName = sName & "_" & iID & "." & sExt

		MakeFileName = sName
	End Function

	Sub SaveImage(sPath, arBuffer, iTargetWidth, iTargetHeight)
		Dim oImage, oCanvas

		Set oImage = Server.CreateObject("Persits.Jpeg")
		oImage.OpenBinary(arBuffer)
		
		oImage.PreserveAspectRatio = 1
		If oImage.OriginalWidth > iTargetWidth Or oImage.OriginalHeight > iTargetHeight Then
			If oImage.OriginalWidth > oImage.OriginalHeight Then
				oImage.Width = iTargetWidth
			Else
				oImage.Height = iTargetHeight
			End If
		End If

		Set oCanvas = Server.CreateObject("Persits.Jpeg")
		Call oCanvas.New(iTargetWidth, iTargetHeight, C_CANVAS_BACKGROUD)
		Call oCanvas.DrawImage(iTargetWidth / 2 - oImage.Width / 2, iTargetHeight / 2 - oImage.Height / 2, oImage)
		oCanvas.Save(sPath)
		oCanvas.Close
		Set oCanvas = Nothing

		oImage.Close
		Set oImage = Nothing
	End Sub

	Sub SaveTextFile(sPath, sContents)
		Dim oFS, oFSFile

		Set oFS = CreateObject("Scripting.FileSystemObject")
		Set oFSFile = oFS.OpenTextFile(sPath, 2, true)

		oFSFile.Write(sContents)
		oFSFile.Close()

		Set oFSFile = Nothing 
		Set oFS = Nothing 
	End Sub

	Sub DeleteFile(sFileName)
		Dim oFS
		Set oFS = CreateObject("Scripting.FileSystemObject")
		If oFS.FileExists(sFileName) Then
			oFS.DeleteFile(sFileName)
		End If
		Set oFS = Nothing
	End Sub

	Function GetFileExtension(sFileName)
		GetFileExtension = LCase(Mid(sFileName, InStrRev(sFileName, ".") + 1))
	End Function

	Function GeneratePromoCode(oConn, iLength)
		Dim sCode, bFound

		bFound = False
		Do
			sCode = UCase(RandomKey(iLength))
			bFound = (GetValueFromTable(oConn, "PromoCodeID", "utb_PromoCodes", "WHERE PromoCodeName = '" & Quote(sCode) & "'") = "")
		Loop Until bFound

		GeneratePromoCode = sCode
	End Function

	Function OrderAddNote(oConn, iOrderID, sNotes, iSendEmail, isHidden)
		If ValidateInteger(iOrderID) Then
			sNotes = Left(sNotes, 500)
			If CStr(iSendEmail) = "1" Then
				sNotes = sNotes & " (Email Send)"
			End If

			sQuery = "INSERT INTO utb_OrderNotes(" &_
					 "	OrderID" &_
					 ", UserName" &_
					 ", OrderNoteContent" &_
					 ", OrderNoteIsHidden" &_
					 ") " &_
					 "VALUES(" &_
					 "	 " & iOrderID &_
					 ", '" & Quote(Session("UserNickName")) & "'" &_
					 ", '" & Quote(sNotes) & "'" &_
					 ",  " & isHidden &_
					 ")"

			oConn.Execute(sQuery)
			OrderAddNote = GetLastID(oConn)
		Else
			OrderAddNote = 0
		End If
	End Function

	Function OrderUpdateTax(oConn, iOrderID)
		If ValidateInteger(iOrderID) Then
			Dim sShippingState, fPromoAmount
			Set oQuery = oConn.Execute(" SELECT * FROM utb_Orders WHERE OrderID = '" & Quote(iOrderID) & "' ")
			If Not oQuery.Eof Then
				sShippingState = oQuery("OrderShippingState")
				fPromoAmount  = oQuery("OrderPromoAmount")
			End If
			oQuery.Close
			Set oQuery = Nothing

			Dim fOrderTaxAmount : fOrderTaxAmount = 0
			Dim bIsResetExemption : bIsResetExemption = False
			Dim fTaxRate : fTaxRate = GetValueFromTable(oConn, "CompanyTaxRate", "utb_Settings", "WHERE CompanyTaxState = '" & Quote(sShippingState) & "'")
			fTaxRate = CCur(IIF(IsNull(fTaxRate), 0, fTaxRate))

			If fTaxRate > 0 Then
				sQuery = " SELECT (ProductPrice * OrderDetailProductQuantity) AS Total " &_
						 "   FROM utb_OrderDetails " &_
						 "  WHERE OrderID = '" & Quote(iOrderID) & "' "

				Set oQuery = oConn.Execute(sQuery)
				Dim fSubTotal : fSubTotal = 0
				While Not oQuery.Eof
					fSubTotal = fSubTotal + CCur(oQuery("Total"))
					oQuery.MoveNext
				Wend
				oQuery.Close
				Set oQuery = Nothing

				Dim fPromo : fPromo = GetValueFromTable(oConn, "OrderPromoAmount", "utb_Orders", "WHERE OrderID = '" & Quote(iOrderID) & "'")
				fPromo = CCur(IIF(IsNull(fPromo), 0, fPromo))

				fOrderTaxAmount = (fSubTotal + fPromo) / 100 * fTaxRate
			Else
				bIsResetExemption = True
			End If

			sQuery = " UPDATE utb_Orders " &_
					 "	SET OrderTaxAmount = '" & fOrderTaxAmount & "' " &_
					 IIF(bIsResetExemption, " , OrderTaxExemption = 0 ", "") &_
					 "  WHERE OrderID = '" & Quote(iOrderID) & "'"

			oConn.Execute(sQuery)

			OrderUpdateTax = fOrderTaxAmount
		Else
			OrderUpdateTax = 0
		End If
	End Function

	Function BuildTabDelemitedLine(Vals)
		Dim i
		Dim Result : Result = ""
		Dim ValsCount : ValsCount = UBound(Vals)

		For i = 0 To ValsCount
			Result = Result & Vals(i) & IIF(ValsCount > i, vbTab, "")
		Next

		BuildTabDelemitedLine = Result
	End Function

	Function BuildCommaDelemitedLine(Vals)
		Dim i
		Dim Result : Result = ""
		Dim ValsCount : ValsCount = UBound(Vals)

		For i = 0 To ValsCount
			Result = Result & Vals(i) & IIF(ValsCount > i, ",", "")
		Next

		BuildCommaDelemitedLine = Result
	End Function

	Function CheckAdminAccess()
		If Session("UserID") = "" Then
			' User not logged in
			CheckAdminAccess = False
		ElseIf Session("DomainName") <> C_DOMAIN_NAME Then
			' Invalid domain name
			Session.Contents.Remove("UserID")
			Session.Contents.Remove("UserNickName")
			Session.Contents.Remove("UserFirstName")
			Session.Contents.Remove("UserLastName")
			CheckAdminAccess = False
		Else
			CheckAdminAccess = True
		End If
	End Function

	Function SqlGetValueOrNull(sValue)
		SqlGetValueOrNull = IIF(IsNull(sValue) Or sValue = "", "NULL", "'" & Quote(sValue) & "'")
	End Function

	Function ItemExists(ByRef arrArray, varValue)
		Dim varItem
		ItemExists = vbFalse
		For Each varItem In arrArray
			If Trim(varItem) = Trim(varValue) Then
				ItemExists = vbTrue
				Exit Function
			End If
		Next
	End Function

	Function GetMenuClass(sFileName)
		Dim sCurFile : sCurFile = GetFileName()
		Dim arFileName : arFileName = Split(sFileName, ",")

		Dim sFile, sResult
		For Each sFile In arFileName
            If sCurFile = sFile Then
				sResult = " class=""top-menu-first"""
				Exit For
			End If
        Next

		GetMenuClass = sResult
	End Function

	Public Function ProductFeedGoogleInit()
		sQuery = "SELECT TOP 1 ISNULL(CompanyGoogleAccountID, '') AS CompanyGoogleAccountID" &_
				 "	   , ISNULL(CompanyGoogleAccountEmail, '') AS CompanyGoogleAccountEmail" &_
				 "	   , ISNULL(CompanyGoogleAccountPassword, '') AS CompanyGoogleAccountPassword" &_
				 "	   , (CASE WHEN CompanyGoogleAccountTokenDate < DATEADD(day, -10, GETDATE()) OR CompanyGoogleAccountTokenDate IS NULL" &_
				 "			   THEN ''" &_
				 "			   ELSE ISNULL(CompanyGoogleAccountToken, '')" &_
				 "		 END) AS CompanyGoogleAccountToken" &_
				 "	FROM utb_Settings"

		Set oQuery = oConn.Execute(sQuery)
		gAccID = oQuery("CompanyGoogleAccountID")
		gEmail = oQuery("CompanyGoogleAccountEmail")
		gPassw = oQuery("CompanyGoogleAccountPassword")
		gToken = oQuery("CompanyGoogleAccountToken")
		If gPassw <> "" Then
			gPassw = Decode(oQuery("CompanyGoogleAccountPassword"))
		End If

		oQuery.Close
		Set oQuery = Nothing
	End Function

	Public Function ProductFeedGoogleSave(iProductID)
		Call ProductFeedGoogleInit()

		Dim isFeed : isFeed = IIF(GetValueFromTable(oConn, "FeedIsAllProducts", "utb_Feeds", "WHERE FeedID = 1") = 1, True, False)
		If Not isFeed Then
			If GetValueFromTable(oConn, "COUNT(*)", "utb_FeedProducts", "WHERE FeedID = 1 AND ProductID = " & iProductID) = 1 Then
				isFeed = True
			End If
		End If

		If isFeed Then
			ProductFeedGoogleSave = "<br/>" & IIF(gProductSave(iProductID), gSuccess, "<strong>Google Base Error:</strong> " & gError)
		Else
			ProductFeedGoogleSave = "<br/>" & IIF(gProductDelete(iProductID), gSuccess, "<strong>Google Base Error:</strong> " & gError)
		End If
	End Function

	Public Function ProductFeedGoogleDelete(iProductID)
		Call ProductFeedGoogleInit()

		ProductFeedGoogleDelete = "<br/>" & IIF(gProductDelete(iProductID), gSuccess, "<strong>Google Base Error:</strong> " & gError)
	End Function

	' added 09/29/2011
	Function SetSetting(oConn, sField, sValue)
		oConn.Execute("UPDATE utb_Settings SET " & sField & " = '" & Quote(sValue) & "'")
	End Function

	' added 09/29/2011
	Public Function GetProductSearchSQL(sSearchStr)
		If sSearchStr = "" Then
			GetProductSearchSQL = ""
			Exit Function
		End If

		Dim sWord, arWhere(4)
		For Each sWord In Split(sSearchStr, " ")
			sWord = Trim(sWord)
			If sWord <> "" Then
				arWhere(0) = arWhere(0) & IIF(arWhere(0) <> "", " AND ", "") & "p.ProductName LIKE '%" & Quote(sWord) & "%'"
				arWhere(1) = arWhere(1) & IIF(arWhere(1) <> "", "  OR ", "") & "p.ProductSKU LIKE '%" & Quote(sWord) & "%'"
				arWhere(2) = arWhere(2) & IIF(arWhere(2) <> "", "  OR ", "") & "p.ProductMPN LIKE '%" & Quote(sWord) & "%'"
				arWhere(3) = arWhere(3) & IIF(arWhere(3) <> "", "  OR ", "") & "p.ProductUPC LIKE '%" & Quote(sWord) & "%'"
				arWhere(4) = arWhere(4) & IIF(arWhere(4) <> "", "  OR ", "") & "CAST(p.ProductID AS VARCHAR(10)) = '" & Quote(sWord) & "'"
			End If
		Next
		GetProductSearchSQL = "((" & Join(arWhere, ") OR (") & "))"
	End Function

	' added 10/14/2011
	Public Function UpdateUserPermissions(UserID)
		Dim UserPermissions : UserPermissions = Array()
		Set oQuery = oConn.Execute("SELECT PermissionID FROM utb_UserPermissions WHERE UserID = " & UserID)
		While Not oQuery.Eof
			ReDim Preserve UserPermissions(Ubound(UserPermissions) + 1)
			UserPermissions(Ubound(UserPermissions)) = oQuery("PermissionID")
			oQuery.MoveNext
		Wend
		oQuery.Close
		Set oQuery = Nothing

		Session("UserPermissions") = UserPermissions
	End Function

	' added 10/14/2011
	Public Function CheckUserPermission(PermissionID)
		CheckUserPermission = ItemExists(Session("UserPermissions"), PermissionID)
	End Function

	' added 10/15/2011
	Public Function UpdateUserRoles(UserID)
		Dim UserRoles : UserRoles = Array()
		Set oQuery = oConn.Execute("SELECT RoleID FROM utb_UserRoles WHERE UserID = " & UserID)
		While Not oQuery.Eof
			ReDim Preserve UserRoles(Ubound(UserRoles) + 1)
			UserRoles(Ubound(UserRoles)) = oQuery("RoleID")
			oQuery.MoveNext
		Wend
		oQuery.Close
		Set oQuery = Nothing

		Session("UserRoles") = UserRoles
	End Function

	' added 10/15/2011
	Public Function CheckUserRole(RoleID)
		CheckUserRole = ItemExists(Session("UserRoles"), RoleID)
	End Function
%>