<%

Dim gAccID, gEmail, gPassw, gToken, gError, gSuccess

Public Function gProductSave(iProductID)
	Dim sXML : sXML = getProductXml(iProductID)
	If sXML <> False Then
		If gProductExists(iProductID) Then
			If sendRequest("PUT", "generic/online:en:US:" & iProductID, sXML) Then
				gSuccess = "Google Base data updated."
			End If
		Else
			If sendRequest("POST", "generic", sXML) Then
				gSuccess = "Product has been added to Google Base."
			End If
		End If
	End If
	gProductSave = (gError = "")
End Function

Public Function gProductDelete(iProductID)
	If gProductExists(iProductID) Then
		If sendRequest("DELETE", "generic/online:en:US:" & iProductID, "") Then
			gSuccess = "Product has been deleted from Google Base."
		End If
	End If
	gProductDelete = (gError = "")
End Function

Public Function gProductExists(iProductID)
	gProductExists = sendRequest("GET", "schema/online:en:US:" & iProductID, "")
	If gError = "item not found" Then
		gError = ""
	End if
End Function

Public Function sendRequest(sMethod, sUrl, sData)
	Dim XMLHttp, XMLDom
	If gAuthorize() Then
		Set XMLHttp = Server.CreateObject("MSXML2.XMLHTTP")
		XMLHttp.Open sMethod, "https://content.googleapis.com/content/v1/" & gAccID & "/items/products/" & sUrl, False
		XMLHttp.SetRequestHeader "Content-Type", "application/atom+xml"
		XMLHttp.SetRequestHeader "Authorization", "GoogleLogin Auth=" & gToken
		XMLHttp.Send sData

		Set XMLDom = Server.CreateObject("Microsoft.XMLDOM")
		XMLDom.async = False
		If XMLDom.loadXML(XMLHttp.responseText) Then
			If Not XMLDom.documentElement.selectSingleNode("error/internalReason") Is Nothing Then
				gError = XMLDom.documentElement.selectSingleNode("error/internalReason").text
				sendRequest = False
			Else
				sendRequest = True
			End If
		Else
			sendRequest = True
		End If
		Set XMLDom = Nothing
	Else
		sendRequest = False
	End If
End Function

Public Function gAuthorize()
	If gToken = "" Then
		Dim XMLHttp
		Set XMLHttp = Server.CreateObject("MSXML2.XMLHTTP")
		XMLHttp.Open "POST", "https://www.google.com/accounts/ClientLogin", False
		XMLHttp.SetRequestHeader "Content-Type", "application/x-www-form-urlencoded"
		XMLHttp.Send "Email=" & gEmail & "&Passwd=" & gPassw & "&service=structuredcontent&source=test"

		Dim arResponse, sResponseLine, arResponseLine
		arResponse = Split(XMLHttp.responseText, vbLf)
		For Each sResponseLine In arResponse
			If sResponseLine <> "" Then
				arResponseLine = Split(sResponseLine, "=")
				If arResponseLine(0) = "Error" Then
					gError = arResponseLine(1)
				ElseIf arResponseLine(0) = "Auth" Then
					gToken = arResponseLine(1)
				End If
			End If
		Next

		If gError = "" Then
			sQuery = "UPDATE utb_Settings" &_
					 "	 SET CompanyGoogleAccountToken = '" & Quote(gToken) & "'" &_
					 "	   , CompanyGoogleAccountTokenDate = GETDATE()"
			oConn.Execute(sQuery)
		End If
	End If

	gAuthorize = (gError = "")
End Function

Public Function getProductXml(iProductID)
	Dim arShippingPrices
	Set arShippingPrices = Server.CreateObject("Scripting.Dictionary")
	sQuery = "SELECT ShippingLevelID" &_
			 "	   , MIN(ShippingFirstItemPrice) AS ShippingFirstItemPrice" &_
			 "	FROM utb_Shippings" &_
			 " GROUP BY ShippingLevelID"
	Set oQuery = oConn.Execute(sQuery)
	While Not oQuery.Eof
		arShippingPrices.Add "" & oQuery("ShippingLevelID") & "", "" & oQuery("ShippingFirstItemPrice") & ""
		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing

	sQuery = "SELECT p.ProductID" &_
			 "	   , LEFT(p.ProductName, 70) AS ProductName" &_
			 "	   , p.ProductPrice" &_
			 "	   , p.ProductDescription" &_
			 "	   , ISNULL(p.ProductMPN, '') AS ProductMPN" &_
			 "	   , p.ProductImage" &_
			 "	   , p.ShippingLevelID" &_
			 "	   , m.ManufacturerName" &_
			 "	   , ISNULL(c.CategoryReserved2, '') AS CategoryReserved2" &_
			 "	   , LOWER(pc.ProductConditionName) AS ProductConditionName" &_
			 "	   , LOWER(ps.ProductStatusName) AS ProductStatusName" &_
			 "	FROM utb_Products AS p" &_
			 "		 INNER JOIN utb_Manufacturers AS m ON m.ManufacturerID = p.ManufacturerID" &_
			 "		 INNER JOIN utb_ProductCategories AS pcat ON pcat.ProductID = p.ProductID AND pcat.ProductCategoryIsMain = 1" &_
			 "		 INNER JOIN utb_Categories AS c ON c.CategoryID = pcat.CategoryID" &_
			 "		 INNER JOIN utb_ProductConditions AS pc ON pc.ProductConditionID = p.ProductConditionID" &_
			 "		 INNER JOIN utb_ProductStatuses AS ps ON ps.ProductStatusID = p.ProductStatusID" &_
			 " WHERE p.ProductStatusID IN(2, 3, 4)" &_
			 "	 AND LOWER(pc.ProductConditionName) IN('new', 'used', 'refurbished')" &_
			 "	 AND LOWER(ps.ProductStatusName) IN('in stock', 'out of stock', 'limited availability')" &_
			 "	 AND p.ProductID = '" & Quote(iProductID) & "'"

	Set oQuery = oConn.Execute(sQuery)
	If Not oQuery.Eof Then
		Dim sUrl, sImage, sDescription, dShippingPrice
		sUrl = BuildFriendlyDetailURL(oQuery("ProductName"), oQuery("ProductID"))
		'sUrl = "http://ajrichard.rtsplusdev.com/LP-E4-Extended-Long-Life-Replacement-Battery/p-452"
		sImage = GetProductImageSrc__(oQuery("ProductImage"), "medium", False)
		sDescription = Replace(StripTags(oQuery("ProductDescription")), VbCrlf, " ")
		dShippingPrice = DecimalFormat(arShippingPrices.Item(CStr(oQuery("ShippingLevelID"))), 2)

		getProductXml = "" &_
			"<?xml version='1.0' encoding='UTF-8'?>" &_
			"<entry xmlns='http://www.w3.org/2005/Atom'" &_
				  " xmlns:sc='http://schemas.google.com/structuredcontent/2009'" &_
				  " xmlns:scp='http://schemas.google.com/structuredcontent/2009/products'" &_
				  " xmlns:app='http://www.w3.org/2007/app'>" &_
				"<title>" & oQuery("ProductName") & "</title>" &_
				"<content type='text'>" & sDescription & "</content>" &_
				"<link rel='alternate' type='text/html' href='" & sUrl & "'/>" &_
				"<sc:id>" & iProductID & "</sc:id>" &_
				"<sc:image_link>" & sImage & "</sc:image_link>" &_
				"<sc:content_language>en</sc:content_language>" &_
				"<sc:target_country>US</sc:target_country>" &_

				"<scp:availability>" & oQuery("ProductStatusName") & "</scp:availability>" &_
				"<scp:brand>" & oQuery("ManufacturerName") & "</scp:brand>" &_
				"<scp:condition>" & oQuery("ProductConditionName") & "</scp:condition>"
		
		If oQuery("ProductMPN") <> "" Then
			getProductXml = getProductXml &_
				"<scp:mpn>" & oQuery("ProductMPN") & "</scp:mpn>"
		End If

		If oQuery("CategoryReserved2") <> "" Then
			getProductXml = getProductXml &_
				"<scp:product_type>" & HTMLEncode(oQuery("CategoryReserved2")) & "</scp:product_type>"
		End If

		getProductXml = getProductXml &_
				"<scp:price unit='USD'>" & DecimalPatch(DecimalFormat(oQuery("ProductPrice"), 2)) & "</scp:price>" &_
				"<scp:shipping>" &_
					"<scp:shipping_price unit='USD'>" & DecimalPatch(dShippingPrice) & "</scp:shipping_price>" &_
				"</scp:shipping>" &_
			"</entry>"
	Else
		gError = "Product #" & iProductID & " not found"
		getProductXml = False
	End If
	oQuery.Close
	Set oQuery = Nothing
End Function

%>