<%
fSubTotal = 0
fSubTotalCost = 0
sQuery = "SELECT d.*" &_
		 "	   , s.ProductStatusName" &_
		 "	   , (CASE OrderDetailTypeID" &_
		 "		 	   WHEN 1 THEN 'Kit'" &_
		 "		 	   WHEN 2 THEN 'Kit Item'" &_
		 "			   WHEN 3 THEN 'Free Gift'" &_
		 "			   ELSE ''" &_
		 "		 END) AS OrderDetailType" &_
		 "	   , (ProductPrice * OrderDetailProductQuantity) AS Total" &_
		 "	   , (ProductCost * OrderDetailProductQuantity) AS TotalCost" &_
		 "	   , ProductPrice AS 'SortOrder'" &_
		 "	FROM utb_OrderDetails d" &_
		 "		 JOIN utb_ProductStatuses s on d.ProductStatusID = s.ProductStatusID " &_
		 " WHERE OrderID = " & iOrderID & " AND ParentID IS NULL" &_
		 " UNION " &_
		 "SELECT d.*" &_
		 "	   , s.ProductStatusName" &_
		 "	   , (CASE OrderDetailTypeID" &_
		 "			   WHEN 1 THEN 'Kit'" &_
		 "			   WHEN 2 THEN 'Kit Item'" &_
		 "			   WHEN 3 THEN 'Free Gift'" &_
		 "			   ELSE ''" &_
		 "		 END) AS OrderDetailType" &_
		 "	   , (ProductPrice * OrderDetailProductQuantity) AS Total" &_
		 "	   , (ProductCost * OrderDetailProductQuantity) AS TotalCost" &_
		 "	   , ProductPrice as 'SortOrder'" &_
		 "	FROM utb_OrderDetails d" &_
		 "		 JOIN utb_ProductStatuses s on d.ProductStatusID = s.ProductStatusID " &_
		 " WHERE OrderID = " & iOrderID & " AND ParentID IS NOT NULL" &_
		 " ORDER BY SortOrder DESC, ProductName"
Set oPQuery = oConn.Execute(sQuery)
%>
<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
	<% While Not oPQuery.Eof %>
		<tr>
			<td style="width: 120px; text-align: left; border-left: 0; border-top: 0"><%= oPQuery("ProductSKU") %></td>
			<td style="text-align: left; border-top: 0; border-top: 0"><%= oPQuery("ProductName") %> &nbsp; <span style="color: #999999"><%= oPQuery("OrderDetailType") %></span></td>
			<td style="width: 60px; text-align: right; border-top: 0"><%= CurrencyFormat(oPQuery("ProductPrice"), 2) %></td>
			<td style="width: 60px; text-align: right; border-top: 0"><%= CurrencyFormat(oPQuery("ProductCost"), 2) %></td>
			<td style="width: 70px; border-top: 0"><%= oPQuery("ProductStatusName") %></td>
			<td style="width: 60px; text-align: center; border-top: 0"><%= oPQuery("OrderDetailProductQuantity") %></td>
			<td style="width: 80px; text-align: right; border-right: 0; border-top: 0"><%= CurrencyFormat(oPQuery("Total"), 2) %></td>
		</tr>
		<%
		fSubTotal = fSubTotal + CCur(oPQuery("Total"))
		fSubTotalCost = fSubTotalCost + CCur(oPQuery("TotalCost"))
		oPQuery.MoveNext
	Wend
	%>
	<tr>
		<td style="text-align: left; color: red; border-left: 0; border-right: 0; border-bottom: 0<%= IIF(fSubTotal = 0, "; border-top: 0", "") %>" colspan="7">
			<span style="color: #000">Total Goods:</span> <%= CurrencyFormat(fSubTotal, 2) %>
			&nbsp;&nbsp;&nbsp;
			<span style="color: #000">Total Cost:</span> <%= CurrencyFormat(fSubTotalCost, 2) %>
			&nbsp;&nbsp;&nbsp;
			<span style="color: #000">PNL:</span> <%= CurrencyFormat(CCur(fSubTotal) - CCur(fSubTotalCost), 2) %>
		</td>
	</tr>
</table>
<%
oPQuery.Close
Set oPQuery = Nothing
%>