<%
	If iGridMode = 0 Or iGridMode = 2 Then
		SetBackURL()
	End If

	If iGridMode = 2 Then
		Dim arStatus
		Set arStatus = Server.CreateObject("Scripting.Dictionary")
		Set oQuery = oConn.Execute("SELECT * FROM utb_ProductStatuses ORDER BY ProductStatusID")
		While Not oQuery.Eof
			arStatus.Add CStr(oQuery("ProductStatusID")), CStr(oQuery("ProductStatusName"))
			oQuery.MoveNext
		Wend
		oQuery.Close
		Dim arStatusKeys : arStatusKeys = arStatus.Keys
	End If

	Dim sOrder, sArrow, sOrderBy, sOrderQuery
	sOrder = "8"
	sArrow = "2"
	If Request("Order") <> "" And Request("Arrow") <> "" Then
		sOrder = Request("Order")
		sArrow = Request("Arrow")
	End If
	sOrderBy = " ORDER BY " & GetColumnByIndex(sOrder) & " " & IIF(sArrow = "1", "ASC", "DESC")
	sOrderQuery = GetURLWithout("Order,Arrow")

	sQuery = "SELECT p.*" &_
			 "	   , ps.ProductStatusName" &_
			 "	   , (CASE WHEN ISNULL(ProductDescription, '') <> '' THEN 1 ELSE 0 END) AS _ProductDescription" &_
			 "	   , CONVERT(VARCHAR(10), p.ProductCreateDate, 101) AS _ProductCreateDate" &_
			 "	FROM utb_Products p" &_
			 "		 INNER JOIN utb_ProductStatuses ps ON ps.ProductStatusID = p.ProductStatusID" &_
			 " " & sWhere &_
			 " " & sOrderBy

	Dim iRecordCount, iCurrentPage, iRecordFrom, iPageCount, iCount
	iCurrentPage = IIF(Request("Page") <> "", CInt(Request("Page")), 1)
	iRecordFrom = (iCurrentPage - 1) * C_PAGE_SIZE + 1
	Set oQuery = ExecuteWithPager(oConn, sQuery, iRecordFrom, iRecordCount)
	iPageCount = Ceil(iRecordCount / C_PAGE_SIZE)
%>
<div class="box-head">
	<!--#include file="PagerBackend.asp"-->
	<%
	If iGridMode = 0 Or iGridMode = 2 Then
		Dim sProductLink : sProductLink = "ProductForm.asp?Action=New&amp;ID=0" &_
			IIF(Request("CategoryID") <> "", "&amp;CategoryID=" & Request("CategoryID"), "") &_
			IIF(Request("ManufacturerID") <> "", "&amp;ManufacturerID=" & Request("ManufacturerID"), "")

		%><a href="<%= sProductLink %>" class="head-link-right act-add">Add Product</a><%
	End If
	%>
	<h2><%= sProductListTitle %></h2>
</div>
<table width="100%" cellpadding="0" cellspacing="0" border="0" class="grid">
	<tr class="head-line">
		<% If iGridMode = 1 Then %>
		<td style="width: 40px"><input type="checkbox" id="check_all" onclick="$('.checkbox').attr('checked', $('#check_all').is(':checked'))"/></td>
		<% End If %>
		<td style="width: 120px"><%= GetURLForOrder("SKU", "1", sOrderQuery, sOrder, sArrow) %></td>
		<td><%= GetURLForOrder("Name", "2", sOrderQuery, sOrder, sArrow) %></td>
		<td style="width: 70px"><%= GetURLForOrder("Quantity", "3", sOrderQuery, sOrder, sArrow) %></td>
		<td style="width: 70px"><%= GetURLForOrder("MSRP", "4", sOrderQuery, sOrder, sArrow) %></td>
		<td style="width: 70px"><%= GetURLForOrder("Price", "5", sOrderQuery, sOrder, sArrow) %></td>
		<td style="width: 70px"><%= GetURLForOrder("Cost", "6", sOrderQuery, sOrder, sArrow) %></td>
		<td style="width: 79px"><%= GetURLForOrder("Status", "7", sOrderQuery, sOrder, sArrow) %></td>
		<td style="width: 70px"><%= GetURLForOrder("Created", "8", sOrderQuery, sOrder, sArrow) %></td>
	</tr>
	<%
	While Not oQuery.Eof 
		iCount = iCount + 1
		%>
		<tr class="<%= IIF(iCount Mod 2 = 0, "row-hl", "") %>">
			<% If iGridMode = 1 Then %>
			<td><input type="checkbox" class="checkbox" name="CheckedID" value="<%= oQuery("ProductID") %>"/></td>
			<% End If %>
			<td style="text-align: left"><a href="ProductForm.asp?Action=Edit&amp;ID=<%= oQuery("ProductID") %>"><%= oQuery("ProductSKU") %></a></td>
			<td style="text-align: left"><%= oQuery("ProductName") %></td>
			<% If iGridMode = 2 Then %>
				<td style="padding: 0">
					<input type="hidden" name="_ID" value="<%= oQuery("ProductID") %>" />
					<input type="hidden" name="_SKU" value="<%= oQuery("ProductSKU") %>" />
					<input type="text" name="_Quantity" value="<%= oQuery("ProductQuantity") %>" style="width: 71px; text-align: center" maxlength="10"/>
				</td>
				<td style="padding: 0">
					<input type="text" name="_MSRP" value="<%= DecimalFormat(oQuery("ProductMSRP"), 2) %>" style="width: 71px; text-align: right" maxlength="15"/>
				</td>
				<td style="padding: 0">
					<input type="text" name="_Price" value="<%= DecimalFormat(oQuery("ProductPrice"), 2) %>" style="width: 71px; text-align: right" maxlength="15"/>
				</td>
				<td style="padding: 0">
					<input type="text" name="_Cost" value="<%= DecimalFormat(oQuery("ProductCost"), 2) %>" style="width: 71px; text-align: right" maxlength="15"/>
				</td>
			<% Else %>
				<td><%= oQuery("ProductQuantity") %></td>
				<td style="text-align: right"><%= CurrencyFormat(oQuery("ProductMSRP"), 2) %></td>
				<td style="text-align: right"><%= CurrencyFormat(oQuery("ProductPrice"), 2) %></td>
				<td style="text-align: right"><%= CurrencyFormat(oQuery("ProductCost"), 2) %></td>
			<% End If %>

			<td style="padding: 0">
				<% If iGridMode = 0 Or iGridMode = 1 Then %>
				<%= oQuery("ProductStatusName") %>
				<% End If %>
				<% If iGridMode = 2 Then %>
				<select name="_StatusID">
					<%
					Dim sStatusKey
					For Each sStatusKey In arStatusKeys
						%><option value="<%= sStatusKey %>"<%= IIF(sStatusKey = CStr(oQuery("ProductStatusID")), " selected='selected'", "") %>><%= arStatus.Item(sStatusKey) %></option><%
					Next
					%>	
				</select>
				<% End If %>
			</td>
			<td><%= oQuery("_ProductCreateDate") %></td>
		</tr>
		<%
		oQuery.MoveNext
	Wend
	oQuery.Close
	Set oQuery = Nothing
	%>
</table>
<%
	If iRecordCount = 0 Then
		%><!--#include file="NoRecords.asp"--><%
	End If

	Function GetColumnByIndex(sIndex)
		Dim sColumn : sColumn = "p.ProductSKU"

		Select Case sIndex
			Case "1" sColumn = "p.ProductSKU"
			Case "2" sColumn = "p.ProductName"
			Case "3" sColumn = "p.ProductQuantity"
			Case "4" sColumn = "p.ProductMSRP"
			Case "5" sColumn = "p.ProductPrice"
			Case "6" sColumn = "p.ProductCost"
			Case "7" sColumn = "ps.ProductStatusName"
			Case "8" sColumn = "p.ProductCreateDate"
		End Select

		GetColumnByIndex = sColumn
	End Function

	If iGridMode = 0 Or iGridMode = 2 Then
		Sub SetBackURL()
			Session("ProductBackURL") = Request.ServerVariables("URL") & IIF(Request.QueryString <> "", "?" & Request.QueryString, "")
		End Sub
	End If
%>