$(function(){
	$('.update-btn').click(updateQty);
	$('.promo-btn').click(applyPromo);
	$('#ShippingCountry,#ShippingState').live('change', calculateShipping);
	$('#Shipping').live('change', function(){
		$('#load-shipping').show();
		$.post('CustomerBasket.asp', preparePostData('recountTotals'), function(data){
			$('#load-shipping').hide();
			if (data.success) {
				updateTotals(data);
			}
			else {
				alert(data.message);
			}
		}, 'json');
	});
	$('#place-order input').click(placeOrder);

	$('.remove-item').live('click', function(){
		if (areYouSure()) {
			$(this).parent().parent().find('input').val('0');
			$('.update-btn').trigger('click');
		}
		return false;
	});
	$('.search-accessories').live('click', function(){
		var a = $(this);
		a.find('img').attr('src', 'images/ajax-loading.gif');
		return searchAccessories('ProductID='+parseInt(a.attr('href').replace('#accessories-', '')), function(){
			a.find('img').attr('src', 'images/p_accessories.png');
		});
	});
	$('.search-products').click(function(){
		var a = $(this);
		var val = $('#DetailsSearch').val();
		if (val == '' || val == 'Search Products') {
			$('#DetailsSearch').focus();
			return;
		}

		a.blur().attr('disabled', true).parent().append('<div class="iloading"><div style="left: 92px"><img src="images/ajax-loading.gif" alt="..."/></div></div>');
		return searchProducts('q='+val, function(){
			$('.iloading').remove();
			a.removeAttr('disabled');
		});
	});

	$('#DetailsSearch').bind('keypress', function(e){
		if (e.keyCode == 13) {
			$('.search-products').trigger('click');
		}
	});
	$('#PromoCode').bind('keypress', function(e){
		if (e.keyCode == 13) {
			$('.promo-btn').trigger('click');
		}
	});

	$('#search-results a').live('click', searchResultsAction);

	$('.addtocart').click(addToCart);
});

function updateQty() {
	$('.update-btn').blur().after('<div class="iloading"><div><img src="images/ajax-loading.gif" alt="..."/></div></div>');
	$('.update-btn, .qty').attr('disabled', true);

	var newQtys = [], newIds = [];
	$('.qty').each(function(){
		var a = $(this);
		var val = parseInt(a.val());
		if (!isNaN(val) && val >= 0) {
			newQtys.push(val);
			newIds.push(parseInt(a.attr('name').replace('qty-', '')));
		}
		else {
			alert('Invalid Qty value: '+a.val());
			$('.update-btn, .qty').removeAttr('disabled');
			$('.iloading').remove();
			a.focus();
			return;
		}
	});

	var postData = preparePostData('updateQty');
	postData.Qtys = newQtys.join(',');
	postData.Ids = newIds.join(',');

	$.post('CustomerBasket.asp', postData, function(data){
		if (data.success) {
			$.each(newQtys, function(i, val){
				if (val == 0) {
					$('.product-'+newIds[i]).fadeOut(300, function(){
						$(this).remove();
					});
				}
			});

			$.each(data.items, function(i, v){
				$('.product-'+v.id+' .qty').val(v.qty);
				$('.product-'+v.id+' .price_total').text(v.price_total);
			});
			updateTotals(data);

			setTimeout(function(){
				var i = $('#basket-items tr:last-child').hasClass('row-hl') ? 1 : 0;
				$('#basket-totals tr').each(function(){
					if (i % 2 == 0) {
						$(this).addClass('row-hl');
					}
					else {
						$(this).removeClass('row-hl');
					}
					i++;
				});

				$('#alert').hide().html(data.message).show();
				$('.update-btn').val('Update');
				$('.update-btn, .qty').removeAttr('disabled');
				$('.iloading').remove();
			}, 500);
		}
		else {
			alert(data.message);
			$('.update-btn').val('Update');
			$('.update-btn, .qty').removeAttr('disabled');
			$('.iloading').remove();
		}
	}, 'json');
}

function applyPromo() {
	var codeObj = $('#PromoCode');
	if (codeObj.val() == '') {
		codeObj.focus();
		return;
	}

	var a = $(this);
	a.attr('disabled', true).blur();
	codeObj.attr('disabled', true);

	$('#load-promo').show();
	$.post('CustomerBasket.asp', preparePostData('applyPromo'), function(data){
		$('#load-promo').hide();
		a.removeAttr('disabled');
		codeObj.removeAttr('disabled');
		if (data.success) {
			$('#ShippingState').trigger('change');
			$('#alert').hide();
		}
		else {
			$('#alert').hide().html(data.message).show();
		}
		updateTotals(data);
	}, 'json');
}

function calculateShipping() {
	var a = $(this);
	$('#load-shipping').show();
	if (a.attr('id') == 'ShippingCountry') {
		$.post('ajax/GetStates.asp', {CountryID: a.val(), JsonMe: true}, function(data){
			$('#load-shipping').hide();
			if (data.success) {
				var s = '<select id="ShippingState" name="ShippingState" class="selector-nowidth" style="margin-right: 5px">';
				$.each(data.states, function(i, d){
					s += '<option value="'+d.id+'">'+d.name+'</option>';
				});
				s += '</select>';
				$('#ShippingState').parent().html(s);
				$('#ShippingState').trigger('change');
			}
			else if (typeof(data.redirect) != 'undefined') {
				document.location.href = data.redirect;
			}
			else if (typeof(data.message) != 'undefined') {
				alert('Error: ' + data.message);
			}
			else {
				alert('Unknown Error. Please contact support.');
			}
		}, 'json');

		return;
	}

	$('#load-shipping').show();
	$.post('CustomerBasket.asp', preparePostData('calcShipping'), function(data){
		$('#load-shipping').hide();
		if (data.success) {
			var s = '<select name="Shipping" id="Shipping" class="selector-nowidth" style="margin-right: 5px">';
			$.each(data.items, function(i, d){
				s += '<option value="'+d.id+'">'+d.name+'</option>';
			});
			s += '</select>';

			$('#Shipping').parent().html(s);
			$('#Shipping').trigger('change');
			updateTotals(data);
		}
		else {
			alert(data.message);
		}
	}, 'json');
}

function preparePostData(jAction) {
	return {
		jAction: jAction,
		BasketID: BasketID,
		PromoCode: $('#PromoCode').val(),
		Country: $('#ShippingCountry').val(),
		State: $('#ShippingState').val() != null ? $('#ShippingState').val() : '',
		ShippingID: $('#Shipping').val() != null ? $('#Shipping').val() : ''
	};
}

function updateTotals(data) {
	$('.subtotal').text(data.subtotal);
	$('.shipping').text(data.shipping);
	$('.promo').text(data.promo);
	$('.tax').text(data.tax);
	$('.grand_total').text(data.grand_total);
}

function placeOrder() {
	if (!areYouSure()) {
		return;
	}
	$(this).blur();
	$('.cbasket input, .cbasket select').attr('disabled', true);
	$('#load-place').show();
	$.post('CustomerBasket.asp', preparePostData('placeOrder'), function(data){
		$('#load-place').hide();
		if (data.success) {
			document.location.href = data.redirect
		}
		else {
			$('.cbasket input, .cbasket select').removeAttr('disabled');
			$('#alert').hide().html(data.message).show();
		}
	}, 'json');
}

var lastSearch = '';
function searchAccessories(link, callback) {
	$('#DetailsSearch').val('Search Products');
	lastSearch = 'accessories';
	$.post('ajax/GetProductAccessories.asp?'+link, {}, function(data){
		if (typeof(callback) == 'function') {
			callback();
		}
		$('#search-results').html(data).show();
		$('#search-results .checkbox,#check_all').click(countSelected);
	});

	return false;
}

function searchProducts(link, callback) {
	lastSearch = 'products';
	$.post('ajax/SearchProducts.asp?'+link, {}, function(data){
		if (typeof(callback) == 'function') {
			callback();
		}
		$('#search-results').html(data).show();
		$('#search-results .checkbox,#check_all').click(countSelected);
	});

	return false;
}

function searchResultsAction() {
	var a = $(this);
	var aArr = a.attr('href').split('?');

	$('#search-results .grid').css('opacity', 0.5);
	if (typeof(aArr[1]) != 'undefined') {
		if (lastSearch == 'accessories') {
			searchAccessories(aArr[1], function(){
				$('#search-results .grid').css('opacity', 1);
			});
		}
		else {
			searchProducts(aArr[1], function(){
				$('#search-results .grid').css('opacity', 1);
			});
		}
	}

	return false;
}

function countSelected() {
	var checkedCnt = 0;
	$('#search-results input[type=checkbox]').each(function(){
		if ($(this).attr('checked') && $(this).attr('id') != 'check_all') {
			checkedCnt++;
		}
	});

	if (checkedCnt > 0) {
		$('.addtocart').val('Add to Cart ('+checkedCnt+')').show();
	}
	else {
		$('.addtocart').empty().hide();
	}
}

function addToCart() {
	var a = $(this);
	var aParent = a.parent();
	$('#search-results input[type=checkbox]').attr('disabled', true);
	a.blur().attr('disabled', true);
	
	var ids = [];
	$('#search-results input[type=checkbox]').each(function(i, v){
		if ($(this).attr('checked') && $(this).attr('id') != 'check_all') {
			ids.push($(this).val());
		}
	});

	var post = preparePostData('addToCart');
	post.ids = ids.join(',');
	aParent.append('<div class="iloading"><div style="left: 135px; top: -19px"><img src="images/ajax-loading.gif" alt="..."/></div></div>');
	$.post('CustomerBasket.asp', post, function(data){
		$('#search-results input[type=checkbox]').removeAttr('disabled').attr('checked', false);
		a.removeAttr('disabled');
		countSelected();

		if (data.success) {
			$.post('ajax/GetBasketItems.asp?BasketID='+BasketID, {}, function(data2){
				$('.iloading').remove();
				$('#basket-items').html(data2);
				updateTotals(data);
				$('#alert').hide().html(data.message).show();

				var i = $('#basket-items tr:last-child').hasClass('row-hl') ? 1 : 0;
				$('#basket-totals tr').each(function(){
					if (i % 2 == 0) {
						$(this).addClass('row-hl');
					}
					else {
						$(this).removeClass('row-hl');
					}
					i++;
				});

				var url = document.location.href.replace('#', '') + '#';
				document.location.href = url;
			});
		}
		else {
			$('.iloading').remove();
			alert(data.message);
		}
	}, 'json');
}
