var waitTpl = '<div style="position: relative" id="order-info-wait">'
			+ 	'<div style="position: absolute; right: 0; top: -1px"><img src="images/ae.gif" alt=""/></div>'
			+ '</div>';
var editTpl = '<div class="cell-edit"><div title="Click here to edit value" onclick="return cellEdit(this)">Edit</div></div>';
var ctrlTpl = '<div class="cell-ctrl"><div>'
			+ 	'<a class="cell-save" onclick="return cellAction(this)">Save</a>&nbsp;'
			+ 	'<a class="cell-cancel" onclick="return cellAction(this)">Cancel</a>'
			+ '</div></div>';

$(function(){
	$('.cell-editable').each(function(){
		$(this).html('<span>'+$(this).text()+'</span>');
		if (!$(this).hasClass('no-icon')) {
			$(this).prepend(editTpl);
		}
	});
	if ($.browser.msie && parseInt($.browser.version, 10) == 8) {
		$('.especiallyforie8').html('Cost:');
	}

	$('#order-notes-form textarea').keydown(function (e) {
		if (e.ctrlKey && e.keyCode == 13) {
			addNote();
		}
	});
	$('#order-notes-form input[type=button]').click(addNote);
	$('#st-change-controls input[type=button]').click(changeSt);

	$('#OrderStatusID,#OrderStatusReasonID').change(function(){
		switch ($(this).attr('id')) {
			case 'OrderStatusID':
				var stId = $(this).val();

				$('#st-changing').show();
				$('#OrderStatusReasonID').attr('disabled', true);
				$.post('ajax/GetOrderStatusReasons.asp', {OrderStatusID: stId}, function(data){
					var newOptions = '<option value="">None</option>';
					if (data.length > 0) {
						newOptions = '<option value="">Select One</option>';
						$.each(data, function(i, o) {
							var selected = OrderStatusReasonID == o.OrderStatusReasonID ? ' selected="selected"' : '';
							newOptions += '<option value="'+o.OrderStatusReasonID+'"'+selected+'>'+o.OrderStatusReasonName+'</option>';
						});
					}
					$('#OrderStatusReasonID').html(newOptions).removeAttr('disabled');
					$('#st-changing').hide();
				}, 'json');
				break;

			case 'OrderStatusReasonID':
				break;
		}

		$('#st-change-controls').slideDown();
		return;
	});

	var emailField = $('#email-proff');
	$('#EmailProffOfPurchase-form').dialog({
		autoOpen: false,
		height: 120,
		width: 330,
		modal: true,
		buttons: {
			Send: function(){
				var a = $(this);
				$('#proff-err').hide();
				if (checkRegexp(emailField, /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i)) {
					var winObj = $('#EmailProffOfPurchase-form').parent();
					winObj.find('button').attr('disabled', true).blur();
					emailField.attr('disabled', true);
					$('.ui-dialog-buttonpane').prepend('<div style="position: relative" id="ae"><div style="position: absolute; top: 3px; left: 3px"><img src="images/ae.gif" width="32" height="16" alt="" /></div></div>');

					$.post('OrderPrintProffOfPurchase.asp', {OrderID: OrderID, Email: emailField.val()}, function(data){
						if (data.success) {
							$('#alert').hide().html(data.message).slideDown();
							a.dialog('close');
						}
						else {
							alert(data.message);
						}
						winObj.find('button').attr('disabled', false);
						emailField.attr('disabled', false);
						$('#ae').remove();
					}, 'json');
				}
				else {
					$('#proff-err').show();
				}
			},
			Cancel: function(){
				$(this).dialog('close');
			}
		},
		close: function(){
			$('#proff-err').hide();
		}
	});
	checkStatusesHeight();
});

var statusesWidthChanged = false;
function checkStatusesHeight() {
	var maxHeight = 165;
	if ($('.st-history').attr('scrollHeight') > maxHeight) {
		$('.st-history').css({
			height: maxHeight + 'px'
		});
		if ($.browser.msie && parseInt($.browser.version, 10) == 7 && !statusesWidthChanged) {
			$('#block-status_changes').width(($('#block-status_changes').width() - 17) + 'px');
			statusesWidthChanged = true;
		}
	}
	else {
		$('.st-history').css('maxHeight', maxHeight + 'px');
	}
}
function addNote() {
	var textObj = $('#order-notes-form textarea');
	var textVal = textObj.val();

	var notesSize = $('#order-notes-content div.note-item').size();
	var recordsCount = 0;
	var addClass = '';
	$('#order-notes-content div.note-item').each(function(i){
		if (i == notesSize-1) {
			if (!$(this).hasClass('row-hl')) {
				addClass = ' row-hl';
			}
		}
		recordsCount++;
	});

	if (textVal == '') {
		textObj.focus();
		return false;
	}

	$('#ae').remove();
	$('#order-notes-form').append('<div style="position: relative" id="ae"><div style="position: absolute; top: -19px; right: 3px"><img src="images/ae.gif" width="32" height="16" alt="" /></div></div>');
	$('#order-notes-form textarea, #order-notes-form input[type=button]').attr('disabled', true);

	$.ajax({type: 'POST', url: 'ajax/OrderFormNotes.asp', dataType: 'json',
		data: {OrderID: OrderID, Notes: textVal.replace(/\n/gi, '<br/>'), SendEmail: $('#send-email').attr('checked') ? 1 : 0},
		success: function(retData){
			if (retData.success) {
				var newNote = '' +
					'<div id="note-' + retData.notes.id + '" style="padding: 3px; display: none;' + (recordsCount > 0 ? ' border-top: 1px solid #ccc' : '') + '" class="note-item' + addClass + '">' +
						'<div style="float: right">' + retData.notes.date + '</div>' +
						'<strong>' + retData.notes.user + '</strong>' +
						'<div style="clear: both"></div>' + retData.notes.cont +
					'</div>';

				$('#order-notes-content').append(newNote);
				$('#note-0').slideUp();
				$('#note-' + retData.notes.id).slideDown(function(){
					$('#order-notes-content').scrollTop($('#order-notes-content').attr('scrollHeight'));
				});
			}
			else if (typeof(retData.redirect) != 'undefined') {
				document.location.href = retData.redirect;
			}
			else if (typeof(retData.message) != 'undefined') {
				alert('Error: ' + retData.message);
			}
			else {
				alert('Unknown Error. Please contact support.');
			}
		},
		complete: function(){
			$('#ae').fadeOut(function(){$(this).remove();});
			$('#order-notes-form textarea').val('');
			$('#limit_').text(500);
			$('#order-notes-form textarea, #order-notes-form input[type=button]').attr('disabled', false);
		}
	});
}
function changeSt() {
	$('#st-change-controls input[type=button]').blur().attr('disabled', true);
	$('#st-changing').fadeIn();
	$.ajax({type: 'POST', url: 'ajax/OrderFormStatus.asp', dataType: 'json',
		data: {
			OrderID: OrderID,
			StatusID: $('#OrderStatusID').val(),
			ReasonID: $('#OrderStatusReasonID').val(),
			SendEmail: $('#send-email-status').attr('checked') ? 1 : 0
		},
		success: function(retData){
			if (retData.success) {
				var newStatus = '' +
					'<tr>' +
						'<td style="border-bottom: 0; border-left: 0; text-align: center">' + retData.statuses.date + '</td>' +
						'<td style="border-bottom: 0">' + retData.statuses.status + '</td>' +
						'<td style="border-bottom: 0">' + retData.statuses.reason + '</td>' +
						'<td style="border-bottom: 0; border-right: 0">' + retData.statuses.user + '</td>' +
					'</tr>';

				$('#grid-status-titles').after(newStatus);
				$('#block-status_changes tr').each(function(i){
					if (i > 0) {
						if (i % 2 == 0) {
							$(this).addClass('row-hl');
						}
						else {
							$(this).removeClass('row-hl');
						}
					}
				});

				$('#cur-st').text(retData.statuses.status).css('color', '#'+retData.statuses.color);
				$('#cur-st-reason').text(retData.reason != '' ? retData.reason : '');
				checkStatusesHeight();
				setTimeout(function(){
					$('#st-change-controls').slideUp();
				}, 200);
			}
			else if (typeof(retData.redirect) != 'undefined') {
				document.location.href = retData.redirect;
			}
			else if (typeof(retData.message) != 'undefined') {
				alert('Error: ' + retData.message);
			}
			else {
				alert('Unknown Error. Please contact support.');
			}
		},
		complete: function(){
			$('#st-change-controls input[type=button]').removeAttr('disabled');
			$('#st-changing').fadeOut();
		}
	});
}

var oldCellValue = '';
var oldCellVals = {};
function cellEdit(o) {
	var a = $(o).parents('.cell-editable');
	oldCellValue = a.find('span').text().replace(/"/gi, '&quot;');

	a.find('.cell-edit').remove();
	a.prepend(ctrlTpl);
	a.find('span').remove();

	switch (a.attr('id')) {
		case 'cell-shipping_carrier':
			var html = '<select>'
					 + 	'<option value="0">Select one</option>';
			$.each(DeliveryCarriers, function(i, c){
				html += '<option value="'+c.id+'"'+(c.name == oldCellValue ? ' selected="selected"' : '')+'>'+c.name+'</option>';
			});
			html += '</select>';
			a.append(html);

			oldCellVals = {
				carrier_method: $('#cell-carrier_method').find('span').text(),
				tracking_number: $('#cell-tracking_number').find('span').text(),
				shipping_cost: $('#cell-shipping_cost').find('span').text()
			};
			$('#cell-carrier_method').find('span').remove();
			$('#cell-carrier_method').append('<input value="'+oldCellVals.carrier_method.replace(/"/gi, '&quot;')+'"/>');
			$('#cell-tracking_number').find('span').remove();
			$('#cell-tracking_number').append('<input value="'+oldCellVals.tracking_number.replace(/"/gi, '&quot;')+'"/>');
			$('#cell-shipping_cost').find('span').remove();
			$('#cell-shipping_cost').append('<input value="'+oldCellVals.shipping_cost.replace('$', '').replace(/,/gi, '')+'"/>');
			break;

		case 'cell-shipping_cost':
			a.append('<input value="'+oldCellValue.replace('$', '').replace(/,/gi, '')+'"/>');
			a.find('input').focus()
				.keypress(function(e){
					if ((e.keyCode ? e.keyCode : e.which) == 13) {
						a.find('.cell-ctrl .cell-save').trigger('click');
					}
				});
			break;

		case 'cell-salesman':
			var html = '<select>'
					 + 	'<option value="0">Select one</option>';
			$.each(Salesmen, function(i, c){
				html += '<option value="'+c.id+'"'+(c.name == oldCellValue ? ' selected="selected"' : '')+'>'+c.name+'</option>';
			});
			html += '</select>';
			a.append(html);
			break;

		default:
			a.append('<input value="'+oldCellValue+'"/>');
			a.find('input').focus()
				.keypress(function(e){
					if ((e.keyCode ? e.keyCode : e.which) == 13) {
						a.find('.cell-ctrl .cell-save').trigger('click');
					}
				});
	}
	return false;
}
function cellAction(o) {
	var a = $(o).parents('.cell-editable');

	if ($(o).hasClass('cell-cancel')) {
		a.find('.cell-ctrl').remove();
		a.prepend(editTpl);

		a.find('select').remove();
		a.find('input').remove();
		a.append('<span>'+oldCellValue.replace(/&quot;/gi, '"')+'</span>');

		if (a.attr('id') == 'cell-shipping_carrier') {
			$('#cell-carrier_method').find('input').remove();
			$('#cell-carrier_method').append('<span>'+oldCellVals.carrier_method+'</span>');
			$('#cell-tracking_number').find('input').remove();
			$('#cell-tracking_number').append('<span>'+oldCellVals.tracking_number+'</span>');
			$('#cell-shipping_cost').find('input').remove();
			$('#cell-shipping_cost').append('<span>'+oldCellVals.shipping_cost+'</span>');
		}
	}
	else if ($(o).hasClass('cell-save')) {
		var val = '';
		if (a.find('select').length) {
			val = a.find('select').val();
		}
		else {
			val = a.find('input').val();
		}
		$('#order-info-wait').remove();
		$('.order-info .head-line td').prepend(waitTpl);

		var d = {
			OrderID: OrderID,
			FieldKey: a.attr('id').replace('cell-', ''),
			FieldVal: val
		};
		if (a.attr('id') == 'cell-shipping_carrier') {
			d.cMethod = $('#cell-carrier_method').find('input').val();
			d.tNumber = $('#cell-tracking_number').find('input').val();
			d.shiCost = $('#cell-shipping_cost').find('input').val();
		}

		$.ajax({type: 'POST', url: 'ajax/OrderFormInfo.asp', dataType: 'json',
			data: d,
			success: function(retData){
				if (retData.success) {
					a.find('.cell-ctrl').remove();
					a.prepend(editTpl);

					a.find('select').remove();
					a.find('input').remove();

					newvalu = retData.newvalu == null ? '' : retData.newvalu;
					a.append('<span>'+newvalu.replace(/&quot;/gi, '"')+'</span>');

					if (a.attr('id') == 'cell-shipping_carrier') {
						$('#cell-carrier_method').find('input').remove();
						$('#cell-carrier_method').append('<span>'+retData.cMethod.replace(/&quot;/gi, '"')+'</span>');
						$('#cell-tracking_number').find('input').remove();
						$('#cell-tracking_number').append('<span>'+retData.tNumber.replace(/&quot;/gi, '"')+'</span>');
						$('#cell-shipping_cost').find('input').remove();
						$('#cell-shipping_cost').append('<span>'+retData.shiCost.replace(/&quot;/gi, '"')+'</span>');
					}
				}
				else if (typeof(retData.redirect) != 'undefined') {
					document.location.href = retData.redirect;
				}
				else if (typeof(retData.message) != 'undefined') {
					alert('Error Message:\n' + retData.message);
				}
				else {
					alert('Unknown Error. Please contact support.');
				}
			},
			complete: function(){
				$('#order-info-wait').remove();
			}
		});
	}
	return false;
}

function emailProffOfPurchase() {
	$('#EmailProffOfPurchase-form').dialog('open');
	return false;
}
function checkRegexp(o, regexp) {
	return regexp.test(o.val());
}
