$(function(){
	$('.more-soptions a').click(function(){
		if ($('.smore-options').is(':hidden')) {
			$(this).html('&laquo; Less options');
			$('.smore-options').show();
			$.cookie('OrderListSearch', 'show');
		}
		else {
			$(this).html('More options &raquo;');
			$('.smore-options').hide();
			$.cookie('OrderListSearch', 'hide');
		}
		return false;
	});

	if ($('.grid-list tr').length > 1) {
		$('.grid-list').after($('.grid-prehead').clone());
		checkBoxes();
	}

	$('.GridAction').live('change', function(){
		var root = getGActionRoot($(this));
		switch (root.find('.GridAction').val()) {
			case 'export':
				root.find('.st-list,.sl-list').hide();
				root.find('.GridActionStatusID,.GridActionSalesmanID').val('');
				root.find('.ex-list,.action-go').show();
				break;

			case 'status':
				root.find('.ex-list,.sl-list').hide();
				root.find('.st-list').show();
				break;

			case 'packing':
				root.find('.ex-list,.st-list,.sl-list').hide();
				root.find('.GridActionStatusID,.GridActionSalesmanID').val('');
				root.find('.action-go').show();
				break;

			case 'salesman':
				root.find('.ex-list,.st-list').hide();
				root.find('.GridActionStatusID,.GridActionSalesmanID').val('');
				root.find('.sl-list').show();
				break;

			default:
				root.find('.ex-list,.st-list,.sl-list').hide();
				root.find('.GridActionStatusID,.GridActionSalesmanID').val('');
				root.find('.action-go').hide();
		}
	});
	$('.GridActionStatusID').live('change', function(){
		var root = getGActionRoot($(this));
		if (root.find('.GridActionStatusID').val() != '') {
			root.find('.action-go').show();
		}
		else {
			root.find('.action-go').hide();
		}
	});
	$('.GridActionSalesmanID').live('change', function(){
		var root = getGActionRoot($(this));
		if (root.find('.GridActionSalesmanID').val() != '') {
			root.find('.action-go').show();
		}
		else {
			root.find('.action-go').hide();
		}
	});

	$('.action-go input').click(function(){
		var root = getGActionRoot($(this));
		switch (root.find('.GridAction').val()) {
			case 'export':
				$('#orders-list').attr({target: '_self', action: 'OrderListExport.asp?del='+$('.GridActionExportType').val()})
					.submit();
				break;

			case 'status':
				var Ids = [];
				$('.checkbox').each(function(){
					var a = $(this);
					if (a.attr('checked')) {
						var val = parseInt(a.val());
						if (!isNaN(val) && val >= 0) {
							Ids.push(val);
						}
					}
				});

				$(this).blur().after('<div class="iloading"><div><img src="images/ajax-loading.gif" alt="..."/></div></div>');
				$('.grid-actions input,.grid-actions select,.checkbox,#check-all').attr('disabled', true);
				$.post('ajax/OrderListStatus.asp', {Ids: Ids.join(','), Status: root.find('.GridActionStatusID').val()}, function(data){
					if (data.success) {
						$('.checkbox').each(function(){
							var a = $(this);
							var b;
							if (a.attr('checked')) {
								b = a.parent().parent();
								b.find('a').css('color', '#'+data.color);
								b.find('a.status-name').text(data.status);
							}
						});
					}
					$('.iloading').remove();
					$('.grid-actions input,.grid-actions select,.checkbox,#check-all').removeAttr('disabled');
					$('#alert').hide().html(data.message).show();
				}, 'json');
				break;

			case 'salesman':
				var Ids = [];
				$('.checkbox').each(function(){
					var a = $(this);
					if (a.attr('checked')) {
						var val = parseInt(a.val());
						if (!isNaN(val) && val >= 0) {
							Ids.push(val);
						}
					}
				});

				$(this).blur().after('<div class="iloading"><div><img src="images/ajax-loading.gif" alt="..."/></div></div>');
				$('.grid-actions input,.grid-actions select,.checkbox,#check-all').attr('disabled', true);
				$.post('ajax/OrderListSalesman.asp', {Ids: Ids.join(','), UserID: root.find('.GridActionSalesmanID').val()}, function(data){
					if (data.success) {
						$('.checkbox').each(function(){
							var a = $(this);
							var b;
							if (a.attr('checked')) {
								b = a.parent().parent();
								b.find('.salesman-name').text(data.salesman);
							}
						});
					}
					$('.iloading').remove();
					$('.grid-actions input,.grid-actions select,.checkbox,#check-all').removeAttr('disabled');
					$('#alert').hide().html(data.message).show();
				}, 'json');
				break;

			case 'packing':
				$('#orders-list').attr({target: '_blank', action: 'OrderPrintInvoice.asp'})
					.submit();
				break;
		}
	});

	$('#SearchStartDate,#SearchFinishDate').datepicker({dateFormat: 'm/d/yy'});

	$('#SearchOrderStatusID').change(getReasons);
	if ($('#SearchOrderStatusID').val() != '') {
		getReasons();
	}

	$('.checkbox,#check-all').click(checkBoxes);
	$('.expander').click(function(){
		var a = $(this);
		var tr = a.parent().parent();
		var aHref = a.attr('href');
		var orderId = parseInt(aHref.replace('#ExpOrder-', ''));
		
		if (a.hasClass('loading')) {
			return false;
		}

		if (aHref == '#ExpAll') {
			$.cookie('OrderListExpanded', (!a.hasClass('expanded') ? 'yes' : 'no'));
			redirect('_self');
		}
		else if (a.hasClass('expanded')) {
			tr.next().hide();
			tr.next().next().hide();
			tr.removeClass('row-hl-expanded');
			a.removeClass('expanded')
				.addClass('collapsed');
		}
		else if (a.hasClass('collapsed')) {
			tr.next().show();
			tr.next().next().show();
			tr.addClass('row-hl-expanded');
			a.removeClass('collapsed')
				.addClass('expanded');
		}
		else {
			a.addClass('loading');
			$.post('ajax/GetOrderProducts.asp', {OrderID: orderId}, function(data){
				tr.addClass('row-hl-expanded');
				a.removeClass('loading')
					.addClass('expanded')
					.parent().parent().after(data);
			});
		}
		return false;
	});
});

function getGActionRoot(obj) {
	return obj.parentsUntil('.grid-actions');
}

function getReasons() {
	$.post('ajax/GetOrderStatusReasons.asp', {OrderStatusID: $('#SearchOrderStatusID').val()}, function(data){
		if (data.length > 0) {
			var combobox = '<select name="SearchOrderStatusReasonID" id="SearchOrderStatusReasonID" class="selector" style="width:130px;">';
			combobox += '<option value="">All</option>';
			$.each(data, function(i, o) {
				var selected = OrderStatusReasonID == o.OrderStatusReasonID ? ' selected="selected"' : '';
				combobox += '<option value="'+o.OrderStatusReasonID+'"'+selected+'>'+o.OrderStatusReasonName+'</option>';
			});
			combobox += '</select>';
			$('#ReasonBoxSelect').html(combobox);
			$('#ReasonBox,#ReasonLabel').show();
		}
		else {
			$('#ReasonBoxSelect').empty();
			$('#ReasonBox,#ReasonLabel').hide();
		}
	}, 'json');
}
function checkBoxes() {
	var checkedCnt = 0;
	var allChecked = true;
	$('.checkbox').each(function(){
		if (!$(this).attr('checked')) {
			if (allChecked == true) {
				allChecked = false;
			}
		}
		else {
			checkedCnt++;
		}
	});
	$('#check-all').attr('checked', allChecked);
	if (checkedCnt > 0) {
		$('.gselected').text(checkedCnt);
		$('.grid-actions').show();
	}
	else {
		$('.grid-actions').hide();
		$('.GridAction,.GridActionStatusID').val('');
		$('.GridAction').trigger('change');
	}
}