function checkLimit(o) {
	var limit = $(o).attr('class').match(/limit_[\d]+/);
	var total = limit[0].split('_')[1];
	var left = total - $(o).attr('value').length;

	if (left < 0) {
		$(o).val($(o).attr('value').substr(0, total));
		left = 0;
	}

	return left;
}

function setCounter(o) {
	var counterObj = $('#' + $(o).attr('id') + '-counter');
	if (counterObj.length) {
		counterObj.html('<br />Number of characters left: <span id="limit_' + $(o).attr('name') + '">' + checkLimit(o) + '</span>');
	}
	else {
		$(o).parent().append('<br />Number of characters left: <span id="limit_' + $(o).attr('name') + '">' + checkLimit(o) + '</span>');
	}
}

$(function() {
	$('.limited').each(function() {
		if ($(this).is('textarea')) {
			setCounter(this);
			$(this).bind('keyup', function() {
				$('#limit_' + $(this).attr('name')).html(checkLimit(this));
			});
		}
	});
});